<?php
// This file was auto-generated from sdk-root/src/data/datazone/2018-05-10/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2018-05-10', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'datazone', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'Amazon DataZone', 'serviceId' => 'DataZone', 'signatureVersion' => 'v4', 'signingName' => 'datazone', 'uid' => 'datazone-2018-05-10', ], 'operations' => [ 'AcceptPredictions' => [ 'name' => 'AcceptPredictions', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v2/domains/{domainIdentifier}/assets/{identifier}/accept-predictions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AcceptPredictionsInput', ], 'output' => [ 'shape' => 'AcceptPredictionsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'AcceptSubscriptionRequest' => [ 'name' => 'AcceptSubscriptionRequest', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v2/domains/{domainIdentifier}/subscription-requests/{identifier}/accept', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AcceptSubscriptionRequestInput', ], 'output' => [ 'shape' => 'AcceptSubscriptionRequestOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'AddEntityOwner' => [ 'name' => 'AddEntityOwner', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/addOwner', 'responseCode' => 201, ], 'input' => [ 'shape' => 'AddEntityOwnerInput', ], 'output' => [ 'shape' => 'AddEntityOwnerOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'AddPolicyGrant' => [ 'name' => 'AddPolicyGrant', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/policies/managed/{entityType}/{entityIdentifier}/addGrant', 'responseCode' => 201, ], 'input' => [ 'shape' => 'AddPolicyGrantInput', ], 'output' => [ 'shape' => 'AddPolicyGrantOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'AssociateEnvironmentRole' => [ 'name' => 'AssociateEnvironmentRole', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/roles/{environmentRoleArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AssociateEnvironmentRoleInput', ], 'output' => [ 'shape' => 'AssociateEnvironmentRoleOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'AssociateGovernedTerms' => [ 'name' => 'AssociateGovernedTerms', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/associate-governed-terms', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AssociateGovernedTermsInput', ], 'output' => [ 'shape' => 'AssociateGovernedTermsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'BatchGetAttributesMetadata' => [ 'name' => 'BatchGetAttributesMetadata', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/attributes-metadata', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchGetAttributesMetadataInput', ], 'output' => [ 'shape' => 'BatchGetAttributesMetadataOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'BatchPutAttributesMetadata' => [ 'name' => 'BatchPutAttributesMetadata', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/attributes-metadata', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchPutAttributesMetadataInput', ], 'output' => [ 'shape' => 'BatchPutAttributesMetadataOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CancelMetadataGenerationRun' => [ 'name' => 'CancelMetadataGenerationRun', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/metadata-generation-runs/{identifier}/cancel', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CancelMetadataGenerationRunInput', ], 'output' => [ 'shape' => 'CancelMetadataGenerationRunOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CancelSubscription' => [ 'name' => 'CancelSubscription', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v2/domains/{domainIdentifier}/subscriptions/{identifier}/cancel', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CancelSubscriptionInput', ], 'output' => [ 'shape' => 'CancelSubscriptionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CreateAccountPool' => [ 'name' => 'CreateAccountPool', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/account-pools', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateAccountPoolInput', ], 'output' => [ 'shape' => 'CreateAccountPoolOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CreateAsset' => [ 'name' => 'CreateAsset', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/assets', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateAssetInput', ], 'output' => [ 'shape' => 'CreateAssetOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CreateAssetFilter' => [ 'name' => 'CreateAssetFilter', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateAssetFilterInput', ], 'output' => [ 'shape' => 'CreateAssetFilterOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CreateAssetRevision' => [ 'name' => 'CreateAssetRevision', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/assets/{identifier}/revisions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateAssetRevisionInput', ], 'output' => [ 'shape' => 'CreateAssetRevisionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CreateAssetType' => [ 'name' => 'CreateAssetType', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/asset-types', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateAssetTypeInput', ], 'output' => [ 'shape' => 'CreateAssetTypeOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CreateConnection' => [ 'name' => 'CreateConnection', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/connections', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateConnectionInput', ], 'output' => [ 'shape' => 'CreateConnectionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CreateDataProduct' => [ 'name' => 'CreateDataProduct', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/data-products', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateDataProductInput', ], 'output' => [ 'shape' => 'CreateDataProductOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CreateDataProductRevision' => [ 'name' => 'CreateDataProductRevision', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/data-products/{identifier}/revisions', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateDataProductRevisionInput', ], 'output' => [ 'shape' => 'CreateDataProductRevisionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CreateDataSource' => [ 'name' => 'CreateDataSource', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/data-sources', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateDataSourceInput', ], 'output' => [ 'shape' => 'CreateDataSourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CreateDomain' => [ 'name' => 'CreateDomain', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateDomainInput', ], 'output' => [ 'shape' => 'CreateDomainOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CreateDomainUnit' => [ 'name' => 'CreateDomainUnit', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/domain-units', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateDomainUnitInput', ], 'output' => [ 'shape' => 'CreateDomainUnitOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CreateEnvironment' => [ 'name' => 'CreateEnvironment', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/environments', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateEnvironmentInput', ], 'output' => [ 'shape' => 'CreateEnvironmentOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CreateEnvironmentAction' => [ 'name' => 'CreateEnvironmentAction', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateEnvironmentActionInput', ], 'output' => [ 'shape' => 'CreateEnvironmentActionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CreateEnvironmentBlueprint' => [ 'name' => 'CreateEnvironmentBlueprint', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/environment-blueprints', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateEnvironmentBlueprintInput', ], 'output' => [ 'shape' => 'CreateEnvironmentBlueprintOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CreateEnvironmentProfile' => [ 'name' => 'CreateEnvironmentProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/environment-profiles', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateEnvironmentProfileInput', ], 'output' => [ 'shape' => 'CreateEnvironmentProfileOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CreateFormType' => [ 'name' => 'CreateFormType', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/form-types', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateFormTypeInput', ], 'output' => [ 'shape' => 'CreateFormTypeOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CreateGlossary' => [ 'name' => 'CreateGlossary', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/glossaries', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateGlossaryInput', ], 'output' => [ 'shape' => 'CreateGlossaryOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CreateGlossaryTerm' => [ 'name' => 'CreateGlossaryTerm', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/glossary-terms', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateGlossaryTermInput', ], 'output' => [ 'shape' => 'CreateGlossaryTermOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CreateGroupProfile' => [ 'name' => 'CreateGroupProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/group-profiles', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateGroupProfileInput', ], 'output' => [ 'shape' => 'CreateGroupProfileOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CreateListingChangeSet' => [ 'name' => 'CreateListingChangeSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/listings/change-set', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateListingChangeSetInput', ], 'output' => [ 'shape' => 'CreateListingChangeSetOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CreateProject' => [ 'name' => 'CreateProject', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/projects', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateProjectInput', ], 'output' => [ 'shape' => 'CreateProjectOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CreateProjectMembership' => [ 'name' => 'CreateProjectMembership', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/projects/{projectIdentifier}/createMembership', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateProjectMembershipInput', ], 'output' => [ 'shape' => 'CreateProjectMembershipOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CreateProjectProfile' => [ 'name' => 'CreateProjectProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/project-profiles', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateProjectProfileInput', ], 'output' => [ 'shape' => 'CreateProjectProfileOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CreateRule' => [ 'name' => 'CreateRule', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/rules', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateRuleInput', ], 'output' => [ 'shape' => 'CreateRuleOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'CreateSubscriptionGrant' => [ 'name' => 'CreateSubscriptionGrant', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/subscription-grants', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateSubscriptionGrantInput', ], 'output' => [ 'shape' => 'CreateSubscriptionGrantOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CreateSubscriptionRequest' => [ 'name' => 'CreateSubscriptionRequest', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/subscription-requests', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateSubscriptionRequestInput', ], 'output' => [ 'shape' => 'CreateSubscriptionRequestOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CreateSubscriptionTarget' => [ 'name' => 'CreateSubscriptionTarget', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateSubscriptionTargetInput', ], 'output' => [ 'shape' => 'CreateSubscriptionTargetOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'CreateUserProfile' => [ 'name' => 'CreateUserProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/user-profiles', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateUserProfileInput', ], 'output' => [ 'shape' => 'CreateUserProfileOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteAccountPool' => [ 'name' => 'DeleteAccountPool', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/account-pools/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteAccountPoolInput', ], 'output' => [ 'shape' => 'DeleteAccountPoolOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteAsset' => [ 'name' => 'DeleteAsset', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/assets/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteAssetInput', ], 'output' => [ 'shape' => 'DeleteAssetOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteAssetFilter' => [ 'name' => 'DeleteAssetFilter', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteAssetFilterInput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteAssetType' => [ 'name' => 'DeleteAssetType', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/asset-types/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteAssetTypeInput', ], 'output' => [ 'shape' => 'DeleteAssetTypeOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'DeleteConnection' => [ 'name' => 'DeleteConnection', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/connections/{identifier}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteConnectionInput', ], 'output' => [ 'shape' => 'DeleteConnectionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteDataExportConfiguration' => [ 'name' => 'DeleteDataExportConfiguration', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/data-export-configuration', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteDataExportConfigurationInput', ], 'output' => [ 'shape' => 'DeleteDataExportConfigurationOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteDataProduct' => [ 'name' => 'DeleteDataProduct', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/data-products/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteDataProductInput', ], 'output' => [ 'shape' => 'DeleteDataProductOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteDataSource' => [ 'name' => 'DeleteDataSource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/data-sources/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteDataSourceInput', ], 'output' => [ 'shape' => 'DeleteDataSourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteDomain' => [ 'name' => 'DeleteDomain', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{identifier}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'DeleteDomainInput', ], 'output' => [ 'shape' => 'DeleteDomainOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteDomainUnit' => [ 'name' => 'DeleteDomainUnit', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/domain-units/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteDomainUnitInput', ], 'output' => [ 'shape' => 'DeleteDomainUnitOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteEnvironment' => [ 'name' => 'DeleteEnvironment', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteEnvironmentInput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteEnvironmentAction' => [ 'name' => 'DeleteEnvironmentAction', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteEnvironmentActionInput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteEnvironmentBlueprint' => [ 'name' => 'DeleteEnvironmentBlueprint', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/environment-blueprints/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteEnvironmentBlueprintInput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteEnvironmentBlueprintConfiguration' => [ 'name' => 'DeleteEnvironmentBlueprintConfiguration', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/environment-blueprint-configurations/{environmentBlueprintIdentifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteEnvironmentBlueprintConfigurationInput', ], 'output' => [ 'shape' => 'DeleteEnvironmentBlueprintConfigurationOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteEnvironmentProfile' => [ 'name' => 'DeleteEnvironmentProfile', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/environment-profiles/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteEnvironmentProfileInput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteFormType' => [ 'name' => 'DeleteFormType', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/form-types/{formTypeIdentifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteFormTypeInput', ], 'output' => [ 'shape' => 'DeleteFormTypeOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'DeleteGlossary' => [ 'name' => 'DeleteGlossary', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/glossaries/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteGlossaryInput', ], 'output' => [ 'shape' => 'DeleteGlossaryOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteGlossaryTerm' => [ 'name' => 'DeleteGlossaryTerm', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/glossary-terms/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteGlossaryTermInput', ], 'output' => [ 'shape' => 'DeleteGlossaryTermOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteListing' => [ 'name' => 'DeleteListing', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/listings/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteListingInput', ], 'output' => [ 'shape' => 'DeleteListingOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteProject' => [ 'name' => 'DeleteProject', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/projects/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteProjectInput', ], 'output' => [ 'shape' => 'DeleteProjectOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteProjectMembership' => [ 'name' => 'DeleteProjectMembership', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/projects/{projectIdentifier}/deleteMembership', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteProjectMembershipInput', ], 'output' => [ 'shape' => 'DeleteProjectMembershipOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteProjectProfile' => [ 'name' => 'DeleteProjectProfile', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/project-profiles/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteProjectProfileInput', ], 'output' => [ 'shape' => 'DeleteProjectProfileOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteRule' => [ 'name' => 'DeleteRule', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/rules/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteRuleInput', ], 'output' => [ 'shape' => 'DeleteRuleOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DeleteSubscriptionGrant' => [ 'name' => 'DeleteSubscriptionGrant', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/subscription-grants/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteSubscriptionGrantInput', ], 'output' => [ 'shape' => 'DeleteSubscriptionGrantOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'DeleteSubscriptionRequest' => [ 'name' => 'DeleteSubscriptionRequest', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/subscription-requests/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteSubscriptionRequestInput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'DeleteSubscriptionTarget' => [ 'name' => 'DeleteSubscriptionTarget', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets/{identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteSubscriptionTargetInput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'DeleteTimeSeriesDataPoints' => [ 'name' => 'DeleteTimeSeriesDataPoints', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/time-series-data-points', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteTimeSeriesDataPointsInput', ], 'output' => [ 'shape' => 'DeleteTimeSeriesDataPointsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'DisassociateEnvironmentRole' => [ 'name' => 'DisassociateEnvironmentRole', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/roles/{environmentRoleArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisassociateEnvironmentRoleInput', ], 'output' => [ 'shape' => 'DisassociateEnvironmentRoleOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'DisassociateGovernedTerms' => [ 'name' => 'DisassociateGovernedTerms', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/disassociate-governed-terms', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisassociateGovernedTermsInput', ], 'output' => [ 'shape' => 'DisassociateGovernedTermsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'GetAccountPool' => [ 'name' => 'GetAccountPool', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/account-pools/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAccountPoolInput', ], 'output' => [ 'shape' => 'GetAccountPoolOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetAsset' => [ 'name' => 'GetAsset', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/assets/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAssetInput', ], 'output' => [ 'shape' => 'GetAssetOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetAssetFilter' => [ 'name' => 'GetAssetFilter', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAssetFilterInput', ], 'output' => [ 'shape' => 'GetAssetFilterOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetAssetType' => [ 'name' => 'GetAssetType', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/asset-types/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetAssetTypeInput', ], 'output' => [ 'shape' => 'GetAssetTypeOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetConnection' => [ 'name' => 'GetConnection', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/connections/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetConnectionInput', ], 'output' => [ 'shape' => 'GetConnectionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetDataExportConfiguration' => [ 'name' => 'GetDataExportConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/data-export-configuration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDataExportConfigurationInput', ], 'output' => [ 'shape' => 'GetDataExportConfigurationOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetDataProduct' => [ 'name' => 'GetDataProduct', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/data-products/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDataProductInput', ], 'output' => [ 'shape' => 'GetDataProductOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetDataSource' => [ 'name' => 'GetDataSource', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/data-sources/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDataSourceInput', ], 'output' => [ 'shape' => 'GetDataSourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetDataSourceRun' => [ 'name' => 'GetDataSourceRun', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/data-source-runs/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDataSourceRunInput', ], 'output' => [ 'shape' => 'GetDataSourceRunOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetDomain' => [ 'name' => 'GetDomain', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDomainInput', ], 'output' => [ 'shape' => 'GetDomainOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetDomainUnit' => [ 'name' => 'GetDomainUnit', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/domain-units/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDomainUnitInput', ], 'output' => [ 'shape' => 'GetDomainUnitOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetEnvironment' => [ 'name' => 'GetEnvironment', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetEnvironmentInput', ], 'output' => [ 'shape' => 'GetEnvironmentOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetEnvironmentAction' => [ 'name' => 'GetEnvironmentAction', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetEnvironmentActionInput', ], 'output' => [ 'shape' => 'GetEnvironmentActionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetEnvironmentBlueprint' => [ 'name' => 'GetEnvironmentBlueprint', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/environment-blueprints/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetEnvironmentBlueprintInput', ], 'output' => [ 'shape' => 'GetEnvironmentBlueprintOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetEnvironmentBlueprintConfiguration' => [ 'name' => 'GetEnvironmentBlueprintConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/environment-blueprint-configurations/{environmentBlueprintIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetEnvironmentBlueprintConfigurationInput', ], 'output' => [ 'shape' => 'GetEnvironmentBlueprintConfigurationOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetEnvironmentCredentials' => [ 'name' => 'GetEnvironmentCredentials', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/credentials', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetEnvironmentCredentialsInput', ], 'output' => [ 'shape' => 'GetEnvironmentCredentialsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetEnvironmentProfile' => [ 'name' => 'GetEnvironmentProfile', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/environment-profiles/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetEnvironmentProfileInput', ], 'output' => [ 'shape' => 'GetEnvironmentProfileOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetFormType' => [ 'name' => 'GetFormType', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/form-types/{formTypeIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetFormTypeInput', ], 'output' => [ 'shape' => 'GetFormTypeOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetGlossary' => [ 'name' => 'GetGlossary', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/glossaries/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetGlossaryInput', ], 'output' => [ 'shape' => 'GetGlossaryOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetGlossaryTerm' => [ 'name' => 'GetGlossaryTerm', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/glossary-terms/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetGlossaryTermInput', ], 'output' => [ 'shape' => 'GetGlossaryTermOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetGroupProfile' => [ 'name' => 'GetGroupProfile', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/group-profiles/{groupIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetGroupProfileInput', ], 'output' => [ 'shape' => 'GetGroupProfileOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetIamPortalLoginUrl' => [ 'name' => 'GetIamPortalLoginUrl', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/get-portal-login-url', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetIamPortalLoginUrlInput', ], 'output' => [ 'shape' => 'GetIamPortalLoginUrlOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'GetJobRun' => [ 'name' => 'GetJobRun', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/jobRuns/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetJobRunInput', ], 'output' => [ 'shape' => 'GetJobRunOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetLineageEvent' => [ 'name' => 'GetLineageEvent', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/lineage/events/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetLineageEventInput', ], 'output' => [ 'shape' => 'GetLineageEventOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetLineageNode' => [ 'name' => 'GetLineageNode', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/lineage/nodes/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetLineageNodeInput', ], 'output' => [ 'shape' => 'GetLineageNodeOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetListing' => [ 'name' => 'GetListing', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/listings/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetListingInput', ], 'output' => [ 'shape' => 'GetListingOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetMetadataGenerationRun' => [ 'name' => 'GetMetadataGenerationRun', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/metadata-generation-runs/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMetadataGenerationRunInput', ], 'output' => [ 'shape' => 'GetMetadataGenerationRunOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetProject' => [ 'name' => 'GetProject', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/projects/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetProjectInput', ], 'output' => [ 'shape' => 'GetProjectOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetProjectProfile' => [ 'name' => 'GetProjectProfile', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/project-profiles/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetProjectProfileInput', ], 'output' => [ 'shape' => 'GetProjectProfileOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetRule' => [ 'name' => 'GetRule', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/rules/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetRuleInput', ], 'output' => [ 'shape' => 'GetRuleOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetSubscription' => [ 'name' => 'GetSubscription', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/subscriptions/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSubscriptionInput', ], 'output' => [ 'shape' => 'GetSubscriptionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetSubscriptionGrant' => [ 'name' => 'GetSubscriptionGrant', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/subscription-grants/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSubscriptionGrantInput', ], 'output' => [ 'shape' => 'GetSubscriptionGrantOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetSubscriptionRequestDetails' => [ 'name' => 'GetSubscriptionRequestDetails', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/subscription-requests/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSubscriptionRequestDetailsInput', ], 'output' => [ 'shape' => 'GetSubscriptionRequestDetailsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetSubscriptionTarget' => [ 'name' => 'GetSubscriptionTarget', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSubscriptionTargetInput', ], 'output' => [ 'shape' => 'GetSubscriptionTargetOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetTimeSeriesDataPoint' => [ 'name' => 'GetTimeSeriesDataPoint', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/time-series-data-points/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetTimeSeriesDataPointInput', ], 'output' => [ 'shape' => 'GetTimeSeriesDataPointOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'GetUserProfile' => [ 'name' => 'GetUserProfile', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/user-profiles/{userIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetUserProfileInput', ], 'output' => [ 'shape' => 'GetUserProfileOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListAccountPools' => [ 'name' => 'ListAccountPools', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/account-pools', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAccountPoolsInput', ], 'output' => [ 'shape' => 'ListAccountPoolsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListAccountsInAccountPool' => [ 'name' => 'ListAccountsInAccountPool', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/account-pools/{identifier}/accounts', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAccountsInAccountPoolInput', ], 'output' => [ 'shape' => 'ListAccountsInAccountPoolOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListAssetFilters' => [ 'name' => 'ListAssetFilters', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAssetFiltersInput', ], 'output' => [ 'shape' => 'ListAssetFiltersOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListAssetRevisions' => [ 'name' => 'ListAssetRevisions', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/assets/{identifier}/revisions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListAssetRevisionsInput', ], 'output' => [ 'shape' => 'ListAssetRevisionsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListConnections' => [ 'name' => 'ListConnections', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/connections', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListConnectionsInput', ], 'output' => [ 'shape' => 'ListConnectionsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListDataProductRevisions' => [ 'name' => 'ListDataProductRevisions', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/data-products/{identifier}/revisions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDataProductRevisionsInput', ], 'output' => [ 'shape' => 'ListDataProductRevisionsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListDataSourceRunActivities' => [ 'name' => 'ListDataSourceRunActivities', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/data-source-runs/{identifier}/activities', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDataSourceRunActivitiesInput', ], 'output' => [ 'shape' => 'ListDataSourceRunActivitiesOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListDataSourceRuns' => [ 'name' => 'ListDataSourceRuns', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/data-sources/{dataSourceIdentifier}/runs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDataSourceRunsInput', ], 'output' => [ 'shape' => 'ListDataSourceRunsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListDataSources' => [ 'name' => 'ListDataSources', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/data-sources', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDataSourcesInput', ], 'output' => [ 'shape' => 'ListDataSourcesOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListDomainUnitsForParent' => [ 'name' => 'ListDomainUnitsForParent', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/domain-units', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDomainUnitsForParentInput', ], 'output' => [ 'shape' => 'ListDomainUnitsForParentOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListDomains' => [ 'name' => 'ListDomains', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDomainsInput', ], 'output' => [ 'shape' => 'ListDomainsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListEntityOwners' => [ 'name' => 'ListEntityOwners', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/owners', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListEntityOwnersInput', ], 'output' => [ 'shape' => 'ListEntityOwnersOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListEnvironmentActions' => [ 'name' => 'ListEnvironmentActions', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListEnvironmentActionsInput', ], 'output' => [ 'shape' => 'ListEnvironmentActionsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListEnvironmentBlueprintConfigurations' => [ 'name' => 'ListEnvironmentBlueprintConfigurations', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/environment-blueprint-configurations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListEnvironmentBlueprintConfigurationsInput', ], 'output' => [ 'shape' => 'ListEnvironmentBlueprintConfigurationsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListEnvironmentBlueprints' => [ 'name' => 'ListEnvironmentBlueprints', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/environment-blueprints', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListEnvironmentBlueprintsInput', ], 'output' => [ 'shape' => 'ListEnvironmentBlueprintsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListEnvironmentProfiles' => [ 'name' => 'ListEnvironmentProfiles', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/environment-profiles', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListEnvironmentProfilesInput', ], 'output' => [ 'shape' => 'ListEnvironmentProfilesOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListEnvironments' => [ 'name' => 'ListEnvironments', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/environments', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListEnvironmentsInput', ], 'output' => [ 'shape' => 'ListEnvironmentsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListJobRuns' => [ 'name' => 'ListJobRuns', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/jobs/{jobIdentifier}/runs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListJobRunsInput', ], 'output' => [ 'shape' => 'ListJobRunsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListLineageEvents' => [ 'name' => 'ListLineageEvents', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/lineage/events', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListLineageEventsInput', ], 'output' => [ 'shape' => 'ListLineageEventsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListLineageNodeHistory' => [ 'name' => 'ListLineageNodeHistory', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/lineage/nodes/{identifier}/history', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListLineageNodeHistoryInput', ], 'output' => [ 'shape' => 'ListLineageNodeHistoryOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListMetadataGenerationRuns' => [ 'name' => 'ListMetadataGenerationRuns', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/metadata-generation-runs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListMetadataGenerationRunsInput', ], 'output' => [ 'shape' => 'ListMetadataGenerationRunsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListNotifications' => [ 'name' => 'ListNotifications', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/notifications', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListNotificationsInput', ], 'output' => [ 'shape' => 'ListNotificationsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListPolicyGrants' => [ 'name' => 'ListPolicyGrants', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/policies/managed/{entityType}/{entityIdentifier}/grants', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListPolicyGrantsInput', ], 'output' => [ 'shape' => 'ListPolicyGrantsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListProjectMemberships' => [ 'name' => 'ListProjectMemberships', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/projects/{projectIdentifier}/memberships', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListProjectMembershipsInput', ], 'output' => [ 'shape' => 'ListProjectMembershipsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListProjectProfiles' => [ 'name' => 'ListProjectProfiles', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/project-profiles', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListProjectProfilesInput', ], 'output' => [ 'shape' => 'ListProjectProfilesOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListProjects' => [ 'name' => 'ListProjects', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/projects', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListProjectsInput', ], 'output' => [ 'shape' => 'ListProjectsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListRules' => [ 'name' => 'ListRules', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/list-rules/{targetType}/{targetIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListRulesInput', ], 'output' => [ 'shape' => 'ListRulesOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListSubscriptionGrants' => [ 'name' => 'ListSubscriptionGrants', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/subscription-grants', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSubscriptionGrantsInput', ], 'output' => [ 'shape' => 'ListSubscriptionGrantsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListSubscriptionRequests' => [ 'name' => 'ListSubscriptionRequests', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/subscription-requests', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSubscriptionRequestsInput', ], 'output' => [ 'shape' => 'ListSubscriptionRequestsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListSubscriptionTargets' => [ 'name' => 'ListSubscriptionTargets', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSubscriptionTargetsInput', ], 'output' => [ 'shape' => 'ListSubscriptionTargetsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListSubscriptions' => [ 'name' => 'ListSubscriptions', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/subscriptions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSubscriptionsInput', ], 'output' => [ 'shape' => 'ListSubscriptionsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'ListTimeSeriesDataPoints' => [ 'name' => 'ListTimeSeriesDataPoints', 'http' => [ 'method' => 'GET', 'requestUri' => '/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/time-series-data-points', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTimeSeriesDataPointsInput', ], 'output' => [ 'shape' => 'ListTimeSeriesDataPointsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'readonly' => true, ], 'PostLineageEvent' => [ 'name' => 'PostLineageEvent', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/lineage/events', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PostLineageEventInput', ], 'output' => [ 'shape' => 'PostLineageEventOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'PostTimeSeriesDataPoints' => [ 'name' => 'PostTimeSeriesDataPoints', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/time-series-data-points', 'responseCode' => 201, ], 'input' => [ 'shape' => 'PostTimeSeriesDataPointsInput', ], 'output' => [ 'shape' => 'PostTimeSeriesDataPointsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'PutDataExportConfiguration' => [ 'name' => 'PutDataExportConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v2/domains/{domainIdentifier}/data-export-configuration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutDataExportConfigurationInput', ], 'output' => [ 'shape' => 'PutDataExportConfigurationOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'PutEnvironmentBlueprintConfiguration' => [ 'name' => 'PutEnvironmentBlueprintConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v2/domains/{domainIdentifier}/environment-blueprint-configurations/{environmentBlueprintIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutEnvironmentBlueprintConfigurationInput', ], 'output' => [ 'shape' => 'PutEnvironmentBlueprintConfigurationOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'RejectPredictions' => [ 'name' => 'RejectPredictions', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v2/domains/{domainIdentifier}/assets/{identifier}/reject-predictions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RejectPredictionsInput', ], 'output' => [ 'shape' => 'RejectPredictionsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'RejectSubscriptionRequest' => [ 'name' => 'RejectSubscriptionRequest', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v2/domains/{domainIdentifier}/subscription-requests/{identifier}/reject', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RejectSubscriptionRequestInput', ], 'output' => [ 'shape' => 'RejectSubscriptionRequestOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'RemoveEntityOwner' => [ 'name' => 'RemoveEntityOwner', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/removeOwner', 'responseCode' => 204, ], 'input' => [ 'shape' => 'RemoveEntityOwnerInput', ], 'output' => [ 'shape' => 'RemoveEntityOwnerOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'RemovePolicyGrant' => [ 'name' => 'RemovePolicyGrant', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/policies/managed/{entityType}/{entityIdentifier}/removeGrant', 'responseCode' => 204, ], 'input' => [ 'shape' => 'RemovePolicyGrantInput', ], 'output' => [ 'shape' => 'RemovePolicyGrantOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'RevokeSubscription' => [ 'name' => 'RevokeSubscription', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v2/domains/{domainIdentifier}/subscriptions/{identifier}/revoke', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RevokeSubscriptionInput', ], 'output' => [ 'shape' => 'RevokeSubscriptionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'Search' => [ 'name' => 'Search', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/search', 'responseCode' => 200, ], 'input' => [ 'shape' => 'SearchInput', ], 'output' => [ 'shape' => 'SearchOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'SearchGroupProfiles' => [ 'name' => 'SearchGroupProfiles', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/search-group-profiles', 'responseCode' => 200, ], 'input' => [ 'shape' => 'SearchGroupProfilesInput', ], 'output' => [ 'shape' => 'SearchGroupProfilesOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'SearchListings' => [ 'name' => 'SearchListings', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/listings/search', 'responseCode' => 200, ], 'input' => [ 'shape' => 'SearchListingsInput', ], 'output' => [ 'shape' => 'SearchListingsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'SearchTypes' => [ 'name' => 'SearchTypes', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/types-search', 'responseCode' => 200, ], 'input' => [ 'shape' => 'SearchTypesInput', ], 'output' => [ 'shape' => 'SearchTypesOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'SearchUserProfiles' => [ 'name' => 'SearchUserProfiles', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/search-user-profiles', 'responseCode' => 200, ], 'input' => [ 'shape' => 'SearchUserProfilesInput', ], 'output' => [ 'shape' => 'SearchUserProfilesOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'StartDataSourceRun' => [ 'name' => 'StartDataSourceRun', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/data-sources/{dataSourceIdentifier}/runs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartDataSourceRunInput', ], 'output' => [ 'shape' => 'StartDataSourceRunOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'StartMetadataGenerationRun' => [ 'name' => 'StartMetadataGenerationRun', 'http' => [ 'method' => 'POST', 'requestUri' => '/v2/domains/{domainIdentifier}/metadata-generation-runs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartMetadataGenerationRunInput', ], 'output' => [ 'shape' => 'StartMetadataGenerationRunOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateAccountPool' => [ 'name' => 'UpdateAccountPool', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/account-pools/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateAccountPoolInput', ], 'output' => [ 'shape' => 'UpdateAccountPoolOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateAssetFilter' => [ 'name' => 'UpdateAssetFilter', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateAssetFilterInput', ], 'output' => [ 'shape' => 'UpdateAssetFilterOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateConnection' => [ 'name' => 'UpdateConnection', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/connections/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateConnectionInput', ], 'output' => [ 'shape' => 'UpdateConnectionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateDataSource' => [ 'name' => 'UpdateDataSource', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/data-sources/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateDataSourceInput', ], 'output' => [ 'shape' => 'UpdateDataSourceOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateDomain' => [ 'name' => 'UpdateDomain', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v2/domains/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateDomainInput', ], 'output' => [ 'shape' => 'UpdateDomainOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateDomainUnit' => [ 'name' => 'UpdateDomainUnit', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v2/domains/{domainIdentifier}/domain-units/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateDomainUnitInput', ], 'output' => [ 'shape' => 'UpdateDomainUnitOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateEnvironment' => [ 'name' => 'UpdateEnvironment', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateEnvironmentInput', ], 'output' => [ 'shape' => 'UpdateEnvironmentOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'UpdateEnvironmentAction' => [ 'name' => 'UpdateEnvironmentAction', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateEnvironmentActionInput', ], 'output' => [ 'shape' => 'UpdateEnvironmentActionOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'UpdateEnvironmentBlueprint' => [ 'name' => 'UpdateEnvironmentBlueprint', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/environment-blueprints/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateEnvironmentBlueprintInput', ], 'output' => [ 'shape' => 'UpdateEnvironmentBlueprintOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateEnvironmentProfile' => [ 'name' => 'UpdateEnvironmentProfile', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/environment-profiles/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateEnvironmentProfileInput', ], 'output' => [ 'shape' => 'UpdateEnvironmentProfileOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'UpdateGlossary' => [ 'name' => 'UpdateGlossary', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/glossaries/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateGlossaryInput', ], 'output' => [ 'shape' => 'UpdateGlossaryOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateGlossaryTerm' => [ 'name' => 'UpdateGlossaryTerm', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/glossary-terms/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateGlossaryTermInput', ], 'output' => [ 'shape' => 'UpdateGlossaryTermOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateGroupProfile' => [ 'name' => 'UpdateGroupProfile', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v2/domains/{domainIdentifier}/group-profiles/{groupIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateGroupProfileInput', ], 'output' => [ 'shape' => 'UpdateGroupProfileOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], 'UpdateProject' => [ 'name' => 'UpdateProject', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/projects/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateProjectInput', ], 'output' => [ 'shape' => 'UpdateProjectOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateProjectProfile' => [ 'name' => 'UpdateProjectProfile', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/project-profiles/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateProjectProfileInput', ], 'output' => [ 'shape' => 'UpdateProjectProfileOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateRootDomainUnitOwner' => [ 'name' => 'UpdateRootDomainUnitOwner', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/root-domain-unit-owner', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UpdateRootDomainUnitOwnerInput', ], 'output' => [ 'shape' => 'UpdateRootDomainUnitOwnerOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateRule' => [ 'name' => 'UpdateRule', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/rules/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateRuleInput', ], 'output' => [ 'shape' => 'UpdateRuleOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateSubscriptionGrantStatus' => [ 'name' => 'UpdateSubscriptionGrantStatus', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/subscription-grants/{identifier}/status/{assetIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateSubscriptionGrantStatusInput', ], 'output' => [ 'shape' => 'UpdateSubscriptionGrantStatusOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateSubscriptionRequest' => [ 'name' => 'UpdateSubscriptionRequest', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/subscription-requests/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateSubscriptionRequestInput', ], 'output' => [ 'shape' => 'UpdateSubscriptionRequestOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateSubscriptionTarget' => [ 'name' => 'UpdateSubscriptionTarget', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets/{identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateSubscriptionTargetInput', ], 'output' => [ 'shape' => 'UpdateSubscriptionTargetOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], 'idempotent' => true, ], 'UpdateUserProfile' => [ 'name' => 'UpdateUserProfile', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v2/domains/{domainIdentifier}/user-profiles/{userIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateUserProfileInput', ], 'output' => [ 'shape' => 'UpdateUserProfileOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'UnauthorizedException', ], ], ], ], 'shapes' => [ 'AcceptChoice' => [ 'type' => 'structure', 'required' => [ 'predictionTarget', ], 'members' => [ 'predictionTarget' => [ 'shape' => 'String', ], 'predictionChoice' => [ 'shape' => 'Integer', ], 'editedValue' => [ 'shape' => 'EditedValue', ], ], ], 'AcceptChoices' => [ 'type' => 'list', 'member' => [ 'shape' => 'AcceptChoice', ], ], 'AcceptPredictionsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'AssetIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], 'revision' => [ 'shape' => 'Revision', 'location' => 'querystring', 'locationName' => 'revision', ], 'acceptRule' => [ 'shape' => 'AcceptRule', ], 'acceptChoices' => [ 'shape' => 'AcceptChoices', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'AcceptPredictionsOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'assetId', 'revision', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'assetId' => [ 'shape' => 'AssetId', ], 'revision' => [ 'shape' => 'Revision', ], ], ], 'AcceptRule' => [ 'type' => 'structure', 'members' => [ 'rule' => [ 'shape' => 'AcceptRuleBehavior', ], 'threshold' => [ 'shape' => 'Float', ], ], ], 'AcceptRuleBehavior' => [ 'type' => 'string', 'enum' => [ 'ALL', 'NONE', ], ], 'AcceptSubscriptionRequestInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'SubscriptionRequestId', 'location' => 'uri', 'locationName' => 'identifier', ], 'decisionComment' => [ 'shape' => 'DecisionComment', ], 'assetScopes' => [ 'shape' => 'AcceptedAssetScopes', ], 'assetPermissions' => [ 'shape' => 'AssetPermissions', ], ], ], 'AcceptSubscriptionRequestOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'status', 'createdAt', 'updatedAt', 'requestReason', 'subscribedPrincipals', 'subscribedListings', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionRequestId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'status' => [ 'shape' => 'SubscriptionRequestStatus', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'requestReason' => [ 'shape' => 'RequestReason', ], 'subscribedPrincipals' => [ 'shape' => 'AcceptSubscriptionRequestOutputSubscribedPrincipalsList', ], 'subscribedListings' => [ 'shape' => 'AcceptSubscriptionRequestOutputSubscribedListingsList', ], 'reviewerId' => [ 'shape' => 'String', ], 'decisionComment' => [ 'shape' => 'DecisionComment', ], 'existingSubscriptionId' => [ 'shape' => 'SubscriptionId', ], 'metadataForms' => [ 'shape' => 'MetadataForms', ], ], ], 'AcceptSubscriptionRequestOutputSubscribedListingsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedListing', ], 'max' => 1, 'min' => 1, ], 'AcceptSubscriptionRequestOutputSubscribedPrincipalsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedPrincipal', ], 'max' => 1, 'min' => 1, ], 'AcceptedAssetScope' => [ 'type' => 'structure', 'required' => [ 'assetId', 'filterIds', ], 'members' => [ 'assetId' => [ 'shape' => 'AssetId', ], 'filterIds' => [ 'shape' => 'FilterIds', ], ], ], 'AcceptedAssetScopes' => [ 'type' => 'list', 'member' => [ 'shape' => 'AcceptedAssetScope', ], ], 'AccessDeniedException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AccountInfo' => [ 'type' => 'structure', 'required' => [ 'awsAccountId', 'supportedRegions', ], 'members' => [ 'awsAccountId' => [ 'shape' => 'AwsAccountId', ], 'supportedRegions' => [ 'shape' => 'AwsRegionList', ], 'awsAccountName' => [ 'shape' => 'AwsAccountName', ], ], ], 'AccountInfoList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccountInfo', ], 'max' => 25, 'min' => 1, ], 'AccountPoolId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'AccountPoolList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccountPoolId', ], 'max' => 10, 'min' => 1, ], 'AccountPoolName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[\\w -]+', 'sensitive' => true, ], 'AccountPoolSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccountPoolSummary', ], ], 'AccountPoolSummary' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'AccountPoolId', ], 'name' => [ 'shape' => 'AccountPoolName', ], 'resolutionStrategy' => [ 'shape' => 'ResolutionStrategy', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], ], ], 'AccountSource' => [ 'type' => 'structure', 'members' => [ 'accounts' => [ 'shape' => 'AccountInfoList', ], 'customAccountPoolHandler' => [ 'shape' => 'CustomAccountPoolHandler', ], ], 'union' => true, ], 'ActionLink' => [ 'type' => 'string', 'sensitive' => true, ], 'ActionParameters' => [ 'type' => 'structure', 'members' => [ 'awsConsoleLink' => [ 'shape' => 'AwsConsoleLinkParameters', ], ], 'union' => true, ], 'AddEntityOwnerInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityType', 'entityIdentifier', 'owner', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityType' => [ 'shape' => 'DataZoneEntityType', 'location' => 'uri', 'locationName' => 'entityType', ], 'entityIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'entityIdentifier', ], 'owner' => [ 'shape' => 'OwnerProperties', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'AddEntityOwnerOutput' => [ 'type' => 'structure', 'members' => [], ], 'AddPolicyGrantInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityType', 'entityIdentifier', 'policyType', 'principal', 'detail', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityType' => [ 'shape' => 'TargetEntityType', 'location' => 'uri', 'locationName' => 'entityType', ], 'entityIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'entityIdentifier', ], 'policyType' => [ 'shape' => 'ManagedPolicyType', ], 'principal' => [ 'shape' => 'PolicyGrantPrincipal', ], 'detail' => [ 'shape' => 'PolicyGrantDetail', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'AddPolicyGrantOutput' => [ 'type' => 'structure', 'members' => [ 'grantId' => [ 'shape' => 'GrantIdentifier', ], ], ], 'AddToProjectMemberPoolPolicyGrantDetail' => [ 'type' => 'structure', 'members' => [ 'includeChildDomainUnits' => [ 'shape' => 'Boolean', ], ], ], 'AggregationAttributeDisplayValue' => [ 'type' => 'string', ], 'AggregationAttributeValue' => [ 'type' => 'string', ], 'AggregationDisplayValue' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'AggregationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AggregationListItem', ], 'max' => 10, 'min' => 1, ], 'AggregationListItem' => [ 'type' => 'structure', 'required' => [ 'attribute', ], 'members' => [ 'attribute' => [ 'shape' => 'Attribute', ], 'displayValue' => [ 'shape' => 'AggregationDisplayValue', ], ], ], 'AggregationOutput' => [ 'type' => 'structure', 'members' => [ 'attribute' => [ 'shape' => 'Attribute', ], 'displayValue' => [ 'shape' => 'AggregationDisplayValue', ], 'items' => [ 'shape' => 'AggregationOutputItems', ], ], ], 'AggregationOutputItem' => [ 'type' => 'structure', 'members' => [ 'value' => [ 'shape' => 'AggregationAttributeValue', ], 'count' => [ 'shape' => 'Integer', ], 'displayValue' => [ 'shape' => 'AggregationAttributeDisplayValue', ], ], ], 'AggregationOutputItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'AggregationOutputItem', ], ], 'AggregationOutputList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AggregationOutput', ], ], 'AllDomainUnitsGrantFilter' => [ 'type' => 'structure', 'members' => [], ], 'AllUsersGrantFilter' => [ 'type' => 'structure', 'members' => [], ], 'AmazonQPropertiesInput' => [ 'type' => 'structure', 'required' => [ 'isEnabled', ], 'members' => [ 'isEnabled' => [ 'shape' => 'Boolean', ], 'profileArn' => [ 'shape' => 'AmazonQPropertiesInputProfileArnString', ], 'authMode' => [ 'shape' => 'AmazonQPropertiesInputAuthModeString', ], ], ], 'AmazonQPropertiesInputAuthModeString' => [ 'type' => 'string', 'max' => 128, 'min' => 0, ], 'AmazonQPropertiesInputProfileArnString' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws[a-z\\-]*:[a-z0-9\\-]+:[a-z0-9\\-]*:[0-9]*:.*', ], 'AmazonQPropertiesOutput' => [ 'type' => 'structure', 'required' => [ 'isEnabled', ], 'members' => [ 'isEnabled' => [ 'shape' => 'Boolean', ], 'profileArn' => [ 'shape' => 'AmazonQPropertiesOutputProfileArnString', ], 'authMode' => [ 'shape' => 'AmazonQPropertiesOutputAuthModeString', ], ], ], 'AmazonQPropertiesOutputAuthModeString' => [ 'type' => 'string', 'max' => 128, 'min' => 0, ], 'AmazonQPropertiesOutputProfileArnString' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws[a-z\\-]*:[a-z0-9\\-]+:[a-z0-9\\-]*:[0-9]*:.*', ], 'AmazonQPropertiesPatch' => [ 'type' => 'structure', 'required' => [ 'isEnabled', ], 'members' => [ 'isEnabled' => [ 'shape' => 'Boolean', ], 'profileArn' => [ 'shape' => 'AmazonQPropertiesPatchProfileArnString', ], 'authMode' => [ 'shape' => 'AmazonQPropertiesPatchAuthModeString', ], ], ], 'AmazonQPropertiesPatchAuthModeString' => [ 'type' => 'string', 'max' => 128, 'min' => 0, ], 'AmazonQPropertiesPatchProfileArnString' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws[a-z\\-]*:[a-z0-9\\-]+:[a-z0-9\\-]*:[0-9]*:.*', ], 'ApplicableAssetTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'TypeName', ], ], 'AssetFilterConfiguration' => [ 'type' => 'structure', 'members' => [ 'columnConfiguration' => [ 'shape' => 'ColumnFilterConfiguration', ], 'rowConfiguration' => [ 'shape' => 'RowFilterConfiguration', ], ], 'union' => true, ], 'AssetFilterSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'domainId', 'assetId', 'name', ], 'members' => [ 'id' => [ 'shape' => 'FilterId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'assetId' => [ 'shape' => 'AssetId', ], 'name' => [ 'shape' => 'FilterName', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'FilterStatus', ], 'effectiveColumnNames' => [ 'shape' => 'ColumnNameList', ], 'effectiveRowFilter' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'errorMessage' => [ 'shape' => 'String', ], ], ], 'AssetFilters' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssetFilterSummary', ], ], 'AssetId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'AssetIdentifier' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'AssetInDataProductListingItem' => [ 'type' => 'structure', 'members' => [ 'entityId' => [ 'shape' => 'String', ], 'entityRevision' => [ 'shape' => 'String', ], 'entityType' => [ 'shape' => 'String', ], ], ], 'AssetInDataProductListingItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssetInDataProductListingItem', ], ], 'AssetItem' => [ 'type' => 'structure', 'required' => [ 'domainId', 'identifier', 'name', 'typeIdentifier', 'typeRevision', 'owningProjectId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'identifier' => [ 'shape' => 'AssetIdentifier', ], 'name' => [ 'shape' => 'AssetName', ], 'typeIdentifier' => [ 'shape' => 'AssetTypeIdentifier', ], 'typeRevision' => [ 'shape' => 'Revision', ], 'externalIdentifier' => [ 'shape' => 'ExternalIdentifier', ], 'description' => [ 'shape' => 'Description', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'firstRevisionCreatedAt' => [ 'shape' => 'CreatedAt', ], 'firstRevisionCreatedBy' => [ 'shape' => 'CreatedBy', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'additionalAttributes' => [ 'shape' => 'AssetItemAdditionalAttributes', ], 'governedGlossaryTerms' => [ 'shape' => 'AssetItemGovernedGlossaryTermsList', ], ], ], 'AssetItemAdditionalAttributes' => [ 'type' => 'structure', 'members' => [ 'formsOutput' => [ 'shape' => 'FormOutputList', ], 'readOnlyFormsOutput' => [ 'shape' => 'FormOutputList', ], 'latestTimeSeriesDataPointFormsOutput' => [ 'shape' => 'TimeSeriesDataPointSummaryFormOutputList', ], 'matchRationale' => [ 'shape' => 'MatchRationale', ], ], ], 'AssetItemGovernedGlossaryTermsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GlossaryTermId', ], 'max' => 20, 'min' => 0, ], 'AssetListing' => [ 'type' => 'structure', 'members' => [ 'assetId' => [ 'shape' => 'AssetId', ], 'assetRevision' => [ 'shape' => 'Revision', ], 'assetType' => [ 'shape' => 'TypeName', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'forms' => [ 'shape' => 'Forms', ], 'latestTimeSeriesDataPointForms' => [ 'shape' => 'TimeSeriesDataPointSummaryFormOutputList', ], 'glossaryTerms' => [ 'shape' => 'DetailedGlossaryTerms', ], 'governedGlossaryTerms' => [ 'shape' => 'AssetListingGovernedGlossaryTermsList', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], ], ], 'AssetListingDetails' => [ 'type' => 'structure', 'required' => [ 'listingId', 'listingStatus', ], 'members' => [ 'listingId' => [ 'shape' => 'ListingId', ], 'listingStatus' => [ 'shape' => 'ListingStatus', ], ], ], 'AssetListingGovernedGlossaryTermsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DetailedGlossaryTerm', ], 'max' => 20, 'min' => 0, ], 'AssetListingItem' => [ 'type' => 'structure', 'members' => [ 'listingId' => [ 'shape' => 'ListingId', ], 'listingRevision' => [ 'shape' => 'Revision', ], 'name' => [ 'shape' => 'AssetName', ], 'entityId' => [ 'shape' => 'AssetId', ], 'entityRevision' => [ 'shape' => 'Revision', ], 'entityType' => [ 'shape' => 'TypeName', ], 'description' => [ 'shape' => 'Description', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'listingCreatedBy' => [ 'shape' => 'CreatedBy', ], 'listingUpdatedBy' => [ 'shape' => 'UpdatedBy', ], 'glossaryTerms' => [ 'shape' => 'DetailedGlossaryTerms', ], 'governedGlossaryTerms' => [ 'shape' => 'AssetListingItemGovernedGlossaryTermsList', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'additionalAttributes' => [ 'shape' => 'AssetListingItemAdditionalAttributes', ], ], ], 'AssetListingItemAdditionalAttributes' => [ 'type' => 'structure', 'members' => [ 'forms' => [ 'shape' => 'Forms', ], 'matchRationale' => [ 'shape' => 'MatchRationale', ], 'latestTimeSeriesDataPointForms' => [ 'shape' => 'TimeSeriesDataPointSummaryFormOutputList', ], ], ], 'AssetListingItemGovernedGlossaryTermsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DetailedGlossaryTerm', ], 'max' => 20, 'min' => 0, ], 'AssetName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'sensitive' => true, ], 'AssetPermission' => [ 'type' => 'structure', 'required' => [ 'assetId', 'permissions', ], 'members' => [ 'assetId' => [ 'shape' => 'AssetId', ], 'permissions' => [ 'shape' => 'Permissions', ], ], ], 'AssetPermissions' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssetPermission', ], ], 'AssetRevision' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'AssetId', ], 'revision' => [ 'shape' => 'Revision', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], ], ], 'AssetRevisions' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssetRevision', ], ], 'AssetScope' => [ 'type' => 'structure', 'required' => [ 'assetId', 'filterIds', 'status', ], 'members' => [ 'assetId' => [ 'shape' => 'AssetId', ], 'filterIds' => [ 'shape' => 'FilterIds', ], 'status' => [ 'shape' => 'String', ], 'errorMessage' => [ 'shape' => 'String', ], ], ], 'AssetTargetNameMap' => [ 'type' => 'structure', 'required' => [ 'assetId', 'targetName', ], 'members' => [ 'assetId' => [ 'shape' => 'AssetId', ], 'targetName' => [ 'shape' => 'String', ], ], ], 'AssetTargetNames' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssetTargetNameMap', ], ], 'AssetTypeIdentifier' => [ 'type' => 'string', 'max' => 513, 'min' => 1, 'pattern' => '(?!\\.)[\\w\\.]*\\w', ], 'AssetTypeIdentifiers' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssetTypeIdentifier', ], ], 'AssetTypeItem' => [ 'type' => 'structure', 'required' => [ 'domainId', 'name', 'revision', 'formsOutput', 'owningProjectId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'TypeName', ], 'revision' => [ 'shape' => 'Revision', ], 'description' => [ 'shape' => 'Description', ], 'formsOutput' => [ 'shape' => 'FormsOutputMap', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'originDomainId' => [ 'shape' => 'DomainId', ], 'originProjectId' => [ 'shape' => 'ProjectId', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], ], ], 'AssetTypesForRule' => [ 'type' => 'structure', 'required' => [ 'selectionMode', ], 'members' => [ 'selectionMode' => [ 'shape' => 'RuleScopeSelectionMode', ], 'specificAssetTypes' => [ 'shape' => 'RuleAssetTypeList', ], ], ], 'AssociateEnvironmentRoleInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentIdentifier', 'environmentRoleArn', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'environmentIdentifier', ], 'environmentRoleArn' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentRoleArn', ], ], ], 'AssociateEnvironmentRoleOutput' => [ 'type' => 'structure', 'members' => [], ], 'AssociateGovernedTermsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityIdentifier', 'entityType', 'governedGlossaryTerms', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityIdentifier' => [ 'shape' => 'EntityIdentifier', 'location' => 'uri', 'locationName' => 'entityIdentifier', ], 'entityType' => [ 'shape' => 'GovernedEntityType', 'location' => 'uri', 'locationName' => 'entityType', ], 'governedGlossaryTerms' => [ 'shape' => 'AssociateGovernedTermsInputGovernedGlossaryTermsList', ], ], ], 'AssociateGovernedTermsInputGovernedGlossaryTermsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GlossaryTermId', ], 'max' => 5, 'min' => 1, ], 'AssociateGovernedTermsOutput' => [ 'type' => 'structure', 'members' => [], ], 'AthenaPropertiesInput' => [ 'type' => 'structure', 'members' => [ 'workgroupName' => [ 'shape' => 'AthenaPropertiesInputWorkgroupNameString', ], ], ], 'AthenaPropertiesInputWorkgroupNameString' => [ 'type' => 'string', 'max' => 64, 'min' => 0, ], 'AthenaPropertiesOutput' => [ 'type' => 'structure', 'members' => [ 'workgroupName' => [ 'shape' => 'AthenaPropertiesOutputWorkgroupNameString', ], ], ], 'AthenaPropertiesOutputWorkgroupNameString' => [ 'type' => 'string', 'max' => 64, 'min' => 0, ], 'AthenaPropertiesPatch' => [ 'type' => 'structure', 'members' => [ 'workgroupName' => [ 'shape' => 'AthenaPropertiesPatchWorkgroupNameString', ], ], ], 'AthenaPropertiesPatchWorkgroupNameString' => [ 'type' => 'string', 'max' => 64, 'min' => 0, ], 'Attribute' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'AttributeEntityType' => [ 'type' => 'string', 'enum' => [ 'ASSET', 'LISTING', ], ], 'AttributeError' => [ 'type' => 'structure', 'required' => [ 'attributeIdentifier', 'code', 'message', ], 'members' => [ 'attributeIdentifier' => [ 'shape' => 'AttributeIdentifier', ], 'code' => [ 'shape' => 'String', ], 'message' => [ 'shape' => 'String', ], ], ], 'AttributeIdentifier' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'AttributeInput' => [ 'type' => 'structure', 'required' => [ 'attributeIdentifier', 'forms', ], 'members' => [ 'attributeIdentifier' => [ 'shape' => 'AttributeIdentifier', ], 'forms' => [ 'shape' => 'FormInputList', ], ], ], 'Attributes' => [ 'type' => 'list', 'member' => [ 'shape' => 'AttributeInput', ], 'max' => 5, 'min' => 0, ], 'AttributesErrors' => [ 'type' => 'list', 'member' => [ 'shape' => 'AttributeError', ], ], 'AttributesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AttributeIdentifier', ], 'max' => 5, 'min' => 1, ], 'AuthType' => [ 'type' => 'string', 'enum' => [ 'IAM_IDC', 'DISABLED', ], ], 'AuthenticationConfiguration' => [ 'type' => 'structure', 'members' => [ 'authenticationType' => [ 'shape' => 'AuthenticationType', ], 'secretArn' => [ 'shape' => 'AuthenticationConfigurationSecretArnString', ], 'oAuth2Properties' => [ 'shape' => 'OAuth2Properties', ], ], ], 'AuthenticationConfigurationInput' => [ 'type' => 'structure', 'members' => [ 'authenticationType' => [ 'shape' => 'AuthenticationType', ], 'oAuth2Properties' => [ 'shape' => 'OAuth2Properties', ], 'secretArn' => [ 'shape' => 'AuthenticationConfigurationInputSecretArnString', ], 'kmsKeyArn' => [ 'shape' => 'AuthenticationConfigurationInputKmsKeyArnString', ], 'basicAuthenticationCredentials' => [ 'shape' => 'BasicAuthenticationCredentials', ], 'customAuthenticationCredentials' => [ 'shape' => 'CredentialMap', ], ], ], 'AuthenticationConfigurationInputKmsKeyArnString' => [ 'type' => 'string', 'pattern' => '$|arn:aws[a-z0-9-]*:kms:.*', ], 'AuthenticationConfigurationInputSecretArnString' => [ 'type' => 'string', 'pattern' => 'arn:aws(-(cn|us-gov|iso(-[bef])?))?:secretsmanager:.*', ], 'AuthenticationConfigurationPatch' => [ 'type' => 'structure', 'members' => [ 'secretArn' => [ 'shape' => 'AuthenticationConfigurationPatchSecretArnString', ], 'basicAuthenticationCredentials' => [ 'shape' => 'BasicAuthenticationCredentials', ], ], ], 'AuthenticationConfigurationPatchSecretArnString' => [ 'type' => 'string', 'pattern' => 'arn:aws(-(cn|us-gov|iso(-[bef])?))?:secretsmanager:.*', ], 'AuthenticationConfigurationSecretArnString' => [ 'type' => 'string', 'pattern' => 'arn:aws(-(cn|us-gov|iso(-[bef])?))?:secretsmanager:.*', ], 'AuthenticationType' => [ 'type' => 'string', 'enum' => [ 'BASIC', 'OAUTH2', 'CUSTOM', ], ], 'AuthorizationCodeProperties' => [ 'type' => 'structure', 'members' => [ 'authorizationCode' => [ 'shape' => 'AuthorizationCodePropertiesAuthorizationCodeString', ], 'redirectUri' => [ 'shape' => 'AuthorizationCodePropertiesRedirectUriString', ], ], ], 'AuthorizationCodePropertiesAuthorizationCodeString' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, ], 'AuthorizationCodePropertiesRedirectUriString' => [ 'type' => 'string', 'max' => 512, 'min' => 0, ], 'AuthorizedPrincipalIdentifier' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9:/._-]*', ], 'AuthorizedPrincipalIdentifiers' => [ 'type' => 'list', 'member' => [ 'shape' => 'AuthorizedPrincipalIdentifier', ], 'max' => 20, 'min' => 1, ], 'AwsAccount' => [ 'type' => 'structure', 'members' => [ 'awsAccountId' => [ 'shape' => 'AwsAccountId', ], 'awsAccountIdPath' => [ 'shape' => 'ParameterStorePath', ], ], 'union' => true, ], 'AwsAccountId' => [ 'type' => 'string', 'pattern' => '\\d{12}', ], 'AwsAccountName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'sensitive' => true, ], 'AwsConsoleLinkParameters' => [ 'type' => 'structure', 'members' => [ 'uri' => [ 'shape' => 'String', ], ], ], 'AwsLocation' => [ 'type' => 'structure', 'members' => [ 'accessRole' => [ 'shape' => 'AwsLocationAccessRoleString', ], 'awsAccountId' => [ 'shape' => 'AwsAccountId', ], 'awsRegion' => [ 'shape' => 'AwsRegion', ], 'iamConnectionId' => [ 'shape' => 'ConnectionId', ], ], ], 'AwsLocationAccessRoleString' => [ 'type' => 'string', 'pattern' => 'arn:aws[^:]*:iam::\\d{12}:(role|role/service-role)/[\\w+=,.@-]*', ], 'AwsRegion' => [ 'type' => 'string', 'pattern' => '[a-z]{2}-[a-z]{4,10}-\\d', ], 'AwsRegionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsRegion', ], 'max' => 3, 'min' => 1, ], 'BasicAuthenticationCredentials' => [ 'type' => 'structure', 'members' => [ 'userName' => [ 'shape' => 'BasicAuthenticationCredentialsUserNameString', ], 'password' => [ 'shape' => 'BasicAuthenticationCredentialsPasswordString', ], ], 'sensitive' => true, ], 'BasicAuthenticationCredentialsPasswordString' => [ 'type' => 'string', 'max' => 512, 'min' => 0, 'pattern' => '.*', ], 'BasicAuthenticationCredentialsUserNameString' => [ 'type' => 'string', 'max' => 512, 'min' => 0, 'pattern' => '\\S+', ], 'BatchGetAttributeItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchGetAttributeOutput', ], ], 'BatchGetAttributeOutput' => [ 'type' => 'structure', 'required' => [ 'attributeIdentifier', ], 'members' => [ 'attributeIdentifier' => [ 'shape' => 'AttributeIdentifier', ], 'forms' => [ 'shape' => 'FormOutputList', ], ], ], 'BatchGetAttributesMetadataInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityType', 'entityIdentifier', 'attributeIdentifiers', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityType' => [ 'shape' => 'AttributeEntityType', 'location' => 'uri', 'locationName' => 'entityType', ], 'entityIdentifier' => [ 'shape' => 'EntityId', 'location' => 'uri', 'locationName' => 'entityIdentifier', ], 'entityRevision' => [ 'shape' => 'Revision', 'location' => 'querystring', 'locationName' => 'entityRevision', ], 'attributeIdentifiers' => [ 'shape' => 'AttributesList', 'location' => 'querystring', 'locationName' => 'attributeIdentifier', ], ], ], 'BatchGetAttributesMetadataOutput' => [ 'type' => 'structure', 'required' => [ 'errors', ], 'members' => [ 'attributes' => [ 'shape' => 'BatchGetAttributeItems', ], 'errors' => [ 'shape' => 'AttributesErrors', ], ], ], 'BatchPutAttributeItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchPutAttributeOutput', ], ], 'BatchPutAttributeOutput' => [ 'type' => 'structure', 'required' => [ 'attributeIdentifier', ], 'members' => [ 'attributeIdentifier' => [ 'shape' => 'AttributeIdentifier', ], ], ], 'BatchPutAttributesMetadataInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityType', 'entityIdentifier', 'attributes', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityType' => [ 'shape' => 'AttributeEntityType', 'location' => 'uri', 'locationName' => 'entityType', ], 'entityIdentifier' => [ 'shape' => 'EntityId', 'location' => 'uri', 'locationName' => 'entityIdentifier', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'attributes' => [ 'shape' => 'Attributes', ], ], ], 'BatchPutAttributesMetadataOutput' => [ 'type' => 'structure', 'members' => [ 'errors' => [ 'shape' => 'AttributesErrors', ], 'attributes' => [ 'shape' => 'BatchPutAttributeItems', ], ], ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'BusinessNameGenerationConfiguration' => [ 'type' => 'structure', 'members' => [ 'enabled' => [ 'shape' => 'Boolean', ], ], ], 'CancelMetadataGenerationRunInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'MetadataGenerationRunIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'CancelMetadataGenerationRunOutput' => [ 'type' => 'structure', 'members' => [], ], 'CancelSubscriptionInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'SubscriptionId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'CancelSubscriptionOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'status', 'createdAt', 'updatedAt', 'subscribedPrincipal', 'subscribedListing', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'status' => [ 'shape' => 'SubscriptionStatus', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'subscribedPrincipal' => [ 'shape' => 'SubscribedPrincipal', ], 'subscribedListing' => [ 'shape' => 'SubscribedListing', ], 'subscriptionRequestId' => [ 'shape' => 'SubscriptionRequestId', ], 'retainPermissions' => [ 'shape' => 'Boolean', ], ], ], 'ChangeAction' => [ 'type' => 'string', 'enum' => [ 'PUBLISH', 'UNPUBLISH', ], ], 'ClientToken' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[\\x21-\\x7E]+', ], 'CloudFormationProperties' => [ 'type' => 'structure', 'required' => [ 'templateUrl', ], 'members' => [ 'templateUrl' => [ 'shape' => 'String', ], ], ], 'ColumnFilterConfiguration' => [ 'type' => 'structure', 'members' => [ 'includedColumnNames' => [ 'shape' => 'ColumnNameList', ], ], ], 'ColumnNameList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'ComputeEnvironments' => [ 'type' => 'string', 'enum' => [ 'SPARK', 'ATHENA', 'PYTHON', ], ], 'ComputeEnvironmentsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ComputeEnvironments', ], 'max' => 50, 'min' => 1, ], 'ConfigurableActionParameter' => [ 'type' => 'structure', 'members' => [ 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'ConfigurableActionParameterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConfigurableActionParameter', ], ], 'ConfigurableActionTypeAuthorization' => [ 'type' => 'string', 'enum' => [ 'IAM', 'HTTPS', ], ], 'ConfigurableEnvironmentAction' => [ 'type' => 'structure', 'required' => [ 'type', 'parameters', ], 'members' => [ 'type' => [ 'shape' => 'String', ], 'auth' => [ 'shape' => 'ConfigurableActionTypeAuthorization', ], 'parameters' => [ 'shape' => 'ConfigurableActionParameterList', ], ], ], 'ConfigurationStatus' => [ 'type' => 'string', 'enum' => [ 'COMPLETED', 'FAILED', ], ], 'ConflictException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ConnectionCredentials' => [ 'type' => 'structure', 'members' => [ 'accessKeyId' => [ 'shape' => 'String', ], 'secretAccessKey' => [ 'shape' => 'String', ], 'sessionToken' => [ 'shape' => 'String', ], 'expiration' => [ 'shape' => 'SyntheticTimestamp_date_time', ], ], 'sensitive' => true, ], 'ConnectionId' => [ 'type' => 'string', 'max' => 128, 'min' => 0, ], 'ConnectionName' => [ 'type' => 'string', 'max' => 64, 'min' => 0, ], 'ConnectionProperties' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'ConnectionPropertiesValueString', ], ], 'ConnectionPropertiesInput' => [ 'type' => 'structure', 'members' => [ 'athenaProperties' => [ 'shape' => 'AthenaPropertiesInput', ], 'glueProperties' => [ 'shape' => 'GluePropertiesInput', ], 'hyperPodProperties' => [ 'shape' => 'HyperPodPropertiesInput', ], 'iamProperties' => [ 'shape' => 'IamPropertiesInput', ], 'redshiftProperties' => [ 'shape' => 'RedshiftPropertiesInput', ], 'sparkEmrProperties' => [ 'shape' => 'SparkEmrPropertiesInput', ], 'sparkGlueProperties' => [ 'shape' => 'SparkGluePropertiesInput', ], 's3Properties' => [ 'shape' => 'S3PropertiesInput', ], 'amazonQProperties' => [ 'shape' => 'AmazonQPropertiesInput', ], 'mlflowProperties' => [ 'shape' => 'MlflowPropertiesInput', ], 'workflowsMwaaProperties' => [ 'shape' => 'WorkflowsMwaaPropertiesInput', ], 'workflowsServerlessProperties' => [ 'shape' => 'WorkflowsServerlessPropertiesInput', ], ], 'union' => true, ], 'ConnectionPropertiesOutput' => [ 'type' => 'structure', 'members' => [ 'athenaProperties' => [ 'shape' => 'AthenaPropertiesOutput', ], 'glueProperties' => [ 'shape' => 'GluePropertiesOutput', ], 'hyperPodProperties' => [ 'shape' => 'HyperPodPropertiesOutput', ], 'iamProperties' => [ 'shape' => 'IamPropertiesOutput', ], 'redshiftProperties' => [ 'shape' => 'RedshiftPropertiesOutput', ], 'sparkEmrProperties' => [ 'shape' => 'SparkEmrPropertiesOutput', ], 'sparkGlueProperties' => [ 'shape' => 'SparkGluePropertiesOutput', ], 's3Properties' => [ 'shape' => 'S3PropertiesOutput', ], 'amazonQProperties' => [ 'shape' => 'AmazonQPropertiesOutput', ], 'mlflowProperties' => [ 'shape' => 'MlflowPropertiesOutput', ], 'workflowsMwaaProperties' => [ 'shape' => 'WorkflowsMwaaPropertiesOutput', ], 'workflowsServerlessProperties' => [ 'shape' => 'WorkflowsServerlessPropertiesOutput', ], ], 'union' => true, ], 'ConnectionPropertiesPatch' => [ 'type' => 'structure', 'members' => [ 'athenaProperties' => [ 'shape' => 'AthenaPropertiesPatch', ], 'glueProperties' => [ 'shape' => 'GluePropertiesPatch', ], 'iamProperties' => [ 'shape' => 'IamPropertiesPatch', ], 'redshiftProperties' => [ 'shape' => 'RedshiftPropertiesPatch', ], 'sparkEmrProperties' => [ 'shape' => 'SparkEmrPropertiesPatch', ], 's3Properties' => [ 'shape' => 'S3PropertiesPatch', ], 'amazonQProperties' => [ 'shape' => 'AmazonQPropertiesPatch', ], 'mlflowProperties' => [ 'shape' => 'MlflowPropertiesPatch', ], ], 'union' => true, ], 'ConnectionPropertiesValueString' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'ConnectionScope' => [ 'type' => 'string', 'enum' => [ 'DOMAIN', 'PROJECT', ], ], 'ConnectionStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'CREATE_FAILED', 'DELETING', 'DELETE_FAILED', 'READY', 'UPDATING', 'UPDATE_FAILED', 'DELETED', ], ], 'ConnectionSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConnectionSummary', ], ], 'ConnectionSummary' => [ 'type' => 'structure', 'required' => [ 'connectionId', 'domainId', 'domainUnitId', 'name', 'physicalEndpoints', 'type', ], 'members' => [ 'connectionId' => [ 'shape' => 'ConnectionId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'name' => [ 'shape' => 'ConnectionName', ], 'physicalEndpoints' => [ 'shape' => 'PhysicalEndpoints', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'props' => [ 'shape' => 'ConnectionPropertiesOutput', ], 'type' => [ 'shape' => 'ConnectionType', ], 'scope' => [ 'shape' => 'ConnectionScope', ], ], ], 'ConnectionType' => [ 'type' => 'string', 'enum' => [ 'ATHENA', 'BIGQUERY', 'DATABRICKS', 'DOCUMENTDB', 'DYNAMODB', 'HYPERPOD', 'IAM', 'MYSQL', 'OPENSEARCH', 'ORACLE', 'POSTGRESQL', 'REDSHIFT', 'S3', 'SAPHANA', 'SNOWFLAKE', 'SPARK', 'SQLSERVER', 'TERADATA', 'VERTICA', 'WORKFLOWS_MWAA', 'AMAZON_Q', 'MLFLOW', ], ], 'CreateAccountPoolInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'name', 'resolutionStrategy', 'accountSource', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'name' => [ 'shape' => 'AccountPoolName', ], 'description' => [ 'shape' => 'Description', ], 'resolutionStrategy' => [ 'shape' => 'ResolutionStrategy', ], 'accountSource' => [ 'shape' => 'AccountSource', ], ], ], 'CreateAccountPoolOutput' => [ 'type' => 'structure', 'required' => [ 'accountSource', 'createdBy', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'AccountPoolName', ], 'id' => [ 'shape' => 'AccountPoolId', ], 'description' => [ 'shape' => 'Description', ], 'resolutionStrategy' => [ 'shape' => 'ResolutionStrategy', ], 'accountSource' => [ 'shape' => 'AccountSource', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], ], ], 'CreateAssetFilterInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'assetIdentifier', 'name', 'configuration', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'assetIdentifier' => [ 'shape' => 'AssetId', 'location' => 'uri', 'locationName' => 'assetIdentifier', ], 'name' => [ 'shape' => 'FilterName', ], 'description' => [ 'shape' => 'Description', ], 'configuration' => [ 'shape' => 'AssetFilterConfiguration', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], ], ], 'CreateAssetFilterOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'domainId', 'assetId', 'name', 'configuration', ], 'members' => [ 'id' => [ 'shape' => 'FilterId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'assetId' => [ 'shape' => 'AssetId', ], 'name' => [ 'shape' => 'FilterName', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'FilterStatus', ], 'configuration' => [ 'shape' => 'AssetFilterConfiguration', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'errorMessage' => [ 'shape' => 'String', ], 'effectiveColumnNames' => [ 'shape' => 'ColumnNameList', ], 'effectiveRowFilter' => [ 'shape' => 'String', ], ], ], 'CreateAssetInput' => [ 'type' => 'structure', 'required' => [ 'name', 'domainIdentifier', 'typeIdentifier', 'owningProjectIdentifier', ], 'members' => [ 'name' => [ 'shape' => 'AssetName', ], 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'externalIdentifier' => [ 'shape' => 'ExternalIdentifier', ], 'typeIdentifier' => [ 'shape' => 'AssetTypeIdentifier', ], 'typeRevision' => [ 'shape' => 'Revision', ], 'description' => [ 'shape' => 'Description', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'formsInput' => [ 'shape' => 'FormInputList', ], 'owningProjectIdentifier' => [ 'shape' => 'ProjectId', ], 'predictionConfiguration' => [ 'shape' => 'PredictionConfiguration', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateAssetOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'typeIdentifier', 'typeRevision', 'revision', 'owningProjectId', 'domainId', 'formsOutput', ], 'members' => [ 'id' => [ 'shape' => 'AssetId', ], 'name' => [ 'shape' => 'AssetName', ], 'typeIdentifier' => [ 'shape' => 'AssetTypeIdentifier', ], 'typeRevision' => [ 'shape' => 'Revision', ], 'externalIdentifier' => [ 'shape' => 'ExternalIdentifier', ], 'revision' => [ 'shape' => 'Revision', ], 'description' => [ 'shape' => 'Description', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'firstRevisionCreatedAt' => [ 'shape' => 'CreatedAt', ], 'firstRevisionCreatedBy' => [ 'shape' => 'CreatedBy', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'governedGlossaryTerms' => [ 'shape' => 'CreateAssetOutputGovernedGlossaryTermsList', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'listing' => [ 'shape' => 'AssetListingDetails', ], 'formsOutput' => [ 'shape' => 'FormOutputList', ], 'readOnlyFormsOutput' => [ 'shape' => 'FormOutputList', ], 'latestTimeSeriesDataPointFormsOutput' => [ 'shape' => 'TimeSeriesDataPointSummaryFormOutputList', ], 'predictionConfiguration' => [ 'shape' => 'PredictionConfiguration', ], ], ], 'CreateAssetOutputGovernedGlossaryTermsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GlossaryTermId', ], 'max' => 20, 'min' => 0, ], 'CreateAssetRevisionInput' => [ 'type' => 'structure', 'required' => [ 'name', 'domainIdentifier', 'identifier', ], 'members' => [ 'name' => [ 'shape' => 'AssetName', ], 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'AssetIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], 'typeRevision' => [ 'shape' => 'Revision', ], 'description' => [ 'shape' => 'Description', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'formsInput' => [ 'shape' => 'FormInputList', ], 'predictionConfiguration' => [ 'shape' => 'PredictionConfiguration', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateAssetRevisionOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'typeIdentifier', 'typeRevision', 'revision', 'owningProjectId', 'domainId', 'formsOutput', ], 'members' => [ 'id' => [ 'shape' => 'AssetId', ], 'name' => [ 'shape' => 'AssetName', ], 'typeIdentifier' => [ 'shape' => 'AssetTypeIdentifier', ], 'typeRevision' => [ 'shape' => 'Revision', ], 'externalIdentifier' => [ 'shape' => 'ExternalIdentifier', ], 'revision' => [ 'shape' => 'Revision', ], 'description' => [ 'shape' => 'Description', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'firstRevisionCreatedAt' => [ 'shape' => 'CreatedAt', ], 'firstRevisionCreatedBy' => [ 'shape' => 'CreatedBy', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'governedGlossaryTerms' => [ 'shape' => 'CreateAssetRevisionOutputGovernedGlossaryTermsList', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'listing' => [ 'shape' => 'AssetListingDetails', ], 'formsOutput' => [ 'shape' => 'FormOutputList', ], 'readOnlyFormsOutput' => [ 'shape' => 'FormOutputList', ], 'latestTimeSeriesDataPointFormsOutput' => [ 'shape' => 'TimeSeriesDataPointSummaryFormOutputList', ], 'predictionConfiguration' => [ 'shape' => 'PredictionConfiguration', ], ], ], 'CreateAssetRevisionOutputGovernedGlossaryTermsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GlossaryTermId', ], 'max' => 20, 'min' => 0, ], 'CreateAssetTypeInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'name', 'formsInput', 'owningProjectIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'name' => [ 'shape' => 'TypeName', ], 'description' => [ 'shape' => 'Description', ], 'formsInput' => [ 'shape' => 'FormsInputMap', ], 'owningProjectIdentifier' => [ 'shape' => 'ProjectId', ], ], ], 'CreateAssetTypeOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'name', 'revision', 'formsOutput', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'TypeName', ], 'revision' => [ 'shape' => 'Revision', ], 'description' => [ 'shape' => 'Description', ], 'formsOutput' => [ 'shape' => 'FormsOutputMap', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'originDomainId' => [ 'shape' => 'DomainId', ], 'originProjectId' => [ 'shape' => 'ProjectId', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], ], ], 'CreateAssetTypePolicyGrantDetail' => [ 'type' => 'structure', 'members' => [ 'includeChildDomainUnits' => [ 'shape' => 'Boolean', ], ], ], 'CreateConnectionInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'name', ], 'members' => [ 'awsLocation' => [ 'shape' => 'AwsLocation', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'description' => [ 'shape' => 'CreateConnectionInputDescriptionString', ], 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', ], 'name' => [ 'shape' => 'ConnectionName', ], 'props' => [ 'shape' => 'ConnectionPropertiesInput', ], 'enableTrustedIdentityPropagation' => [ 'shape' => 'Boolean', ], 'scope' => [ 'shape' => 'ConnectionScope', ], ], ], 'CreateConnectionInputDescriptionString' => [ 'type' => 'string', 'max' => 128, 'min' => 0, 'sensitive' => true, ], 'CreateConnectionOutput' => [ 'type' => 'structure', 'required' => [ 'connectionId', 'domainId', 'domainUnitId', 'name', 'physicalEndpoints', 'type', ], 'members' => [ 'connectionId' => [ 'shape' => 'ConnectionId', ], 'description' => [ 'shape' => 'Description', ], 'domainId' => [ 'shape' => 'DomainId', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'name' => [ 'shape' => 'ConnectionName', ], 'physicalEndpoints' => [ 'shape' => 'PhysicalEndpoints', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'props' => [ 'shape' => 'ConnectionPropertiesOutput', ], 'type' => [ 'shape' => 'ConnectionType', ], 'scope' => [ 'shape' => 'ConnectionScope', ], ], ], 'CreateDataProductInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'name', 'owningProjectIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'name' => [ 'shape' => 'DataProductName', ], 'owningProjectIdentifier' => [ 'shape' => 'ProjectId', ], 'description' => [ 'shape' => 'DataProductDescription', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'formsInput' => [ 'shape' => 'FormInputList', ], 'items' => [ 'shape' => 'DataProductItems', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateDataProductOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'revision', 'owningProjectId', 'name', 'status', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'DataProductId', ], 'revision' => [ 'shape' => 'Revision', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'name' => [ 'shape' => 'DataProductName', ], 'status' => [ 'shape' => 'DataProductStatus', ], 'description' => [ 'shape' => 'DataProductDescription', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'items' => [ 'shape' => 'DataProductItems', ], 'formsOutput' => [ 'shape' => 'FormOutputList', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'firstRevisionCreatedAt' => [ 'shape' => 'CreatedAt', ], 'firstRevisionCreatedBy' => [ 'shape' => 'CreatedBy', ], ], ], 'CreateDataProductRevisionInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', 'name', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'DataProductId', 'location' => 'uri', 'locationName' => 'identifier', ], 'name' => [ 'shape' => 'DataProductName', ], 'description' => [ 'shape' => 'DataProductDescription', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'items' => [ 'shape' => 'DataProductItems', ], 'formsInput' => [ 'shape' => 'FormInputList', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateDataProductRevisionOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'revision', 'owningProjectId', 'name', 'status', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'DataProductId', ], 'revision' => [ 'shape' => 'Revision', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'name' => [ 'shape' => 'DataProductName', ], 'status' => [ 'shape' => 'DataProductStatus', ], 'description' => [ 'shape' => 'DataProductDescription', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'items' => [ 'shape' => 'DataProductItems', ], 'formsOutput' => [ 'shape' => 'FormOutputList', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'firstRevisionCreatedAt' => [ 'shape' => 'CreatedAt', ], 'firstRevisionCreatedBy' => [ 'shape' => 'CreatedBy', ], ], ], 'CreateDataSourceInput' => [ 'type' => 'structure', 'required' => [ 'name', 'domainIdentifier', 'projectIdentifier', 'type', ], 'members' => [ 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'projectIdentifier' => [ 'shape' => 'CreateDataSourceInputProjectIdentifierString', ], 'environmentIdentifier' => [ 'shape' => 'CreateDataSourceInputEnvironmentIdentifierString', ], 'connectionIdentifier' => [ 'shape' => 'CreateDataSourceInputConnectionIdentifierString', ], 'type' => [ 'shape' => 'DataSourceType', ], 'configuration' => [ 'shape' => 'DataSourceConfigurationInput', ], 'recommendation' => [ 'shape' => 'RecommendationConfiguration', ], 'enableSetting' => [ 'shape' => 'EnableSetting', ], 'schedule' => [ 'shape' => 'ScheduleConfiguration', ], 'publishOnImport' => [ 'shape' => 'Boolean', ], 'assetFormsInput' => [ 'shape' => 'FormInputList', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], ], ], 'CreateDataSourceInputConnectionIdentifierString' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'CreateDataSourceInputEnvironmentIdentifierString' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'CreateDataSourceInputProjectIdentifierString' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'CreateDataSourceOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'domainId', 'projectId', ], 'members' => [ 'id' => [ 'shape' => 'DataSourceId', ], 'status' => [ 'shape' => 'DataSourceStatus', ], 'type' => [ 'shape' => 'DataSourceType', ], 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'domainId' => [ 'shape' => 'DomainId', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'connectionId' => [ 'shape' => 'String', ], 'configuration' => [ 'shape' => 'DataSourceConfigurationOutput', ], 'recommendation' => [ 'shape' => 'RecommendationConfiguration', ], 'enableSetting' => [ 'shape' => 'EnableSetting', ], 'publishOnImport' => [ 'shape' => 'Boolean', ], 'assetFormsOutput' => [ 'shape' => 'FormOutputList', ], 'schedule' => [ 'shape' => 'ScheduleConfiguration', ], 'lastRunStatus' => [ 'shape' => 'DataSourceRunStatus', ], 'lastRunAt' => [ 'shape' => 'DateTime', ], 'lastRunErrorMessage' => [ 'shape' => 'DataSourceErrorMessage', ], 'errorMessage' => [ 'shape' => 'DataSourceErrorMessage', ], 'createdAt' => [ 'shape' => 'DateTime', ], 'updatedAt' => [ 'shape' => 'DateTime', ], ], ], 'CreateDomainInput' => [ 'type' => 'structure', 'required' => [ 'name', 'domainExecutionRole', ], 'members' => [ 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'singleSignOn' => [ 'shape' => 'SingleSignOn', ], 'domainExecutionRole' => [ 'shape' => 'RoleArn', ], 'kmsKeyIdentifier' => [ 'shape' => 'KmsKeyArn', ], 'tags' => [ 'shape' => 'Tags', ], 'domainVersion' => [ 'shape' => 'DomainVersion', ], 'serviceRole' => [ 'shape' => 'RoleArn', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], ], ], 'CreateDomainOutput' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'DomainId', ], 'rootDomainUnitId' => [ 'shape' => 'DomainUnitId', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'singleSignOn' => [ 'shape' => 'SingleSignOn', ], 'domainExecutionRole' => [ 'shape' => 'RoleArn', ], 'arn' => [ 'shape' => 'String', ], 'kmsKeyIdentifier' => [ 'shape' => 'KmsKeyArn', ], 'status' => [ 'shape' => 'DomainStatus', ], 'portalUrl' => [ 'shape' => 'String', ], 'tags' => [ 'shape' => 'Tags', ], 'domainVersion' => [ 'shape' => 'DomainVersion', ], 'serviceRole' => [ 'shape' => 'RoleArn', ], ], ], 'CreateDomainUnitInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'name', 'parentDomainUnitIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'name' => [ 'shape' => 'DomainUnitName', ], 'parentDomainUnitIdentifier' => [ 'shape' => 'DomainUnitId', ], 'description' => [ 'shape' => 'DomainUnitDescription', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateDomainUnitOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'domainId', 'name', 'owners', 'ancestorDomainUnitIds', ], 'members' => [ 'id' => [ 'shape' => 'DomainUnitId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'DomainUnitName', ], 'parentDomainUnitId' => [ 'shape' => 'DomainUnitId', ], 'description' => [ 'shape' => 'DomainUnitDescription', ], 'owners' => [ 'shape' => 'DomainUnitOwners', ], 'ancestorDomainUnitIds' => [ 'shape' => 'DomainUnitIds', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], ], ], 'CreateDomainUnitPolicyGrantDetail' => [ 'type' => 'structure', 'members' => [ 'includeChildDomainUnits' => [ 'shape' => 'Boolean', ], ], ], 'CreateEnvironmentActionInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentIdentifier', 'name', 'parameters', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'environmentIdentifier', ], 'name' => [ 'shape' => 'String', ], 'parameters' => [ 'shape' => 'ActionParameters', ], 'description' => [ 'shape' => 'String', ], ], ], 'CreateEnvironmentActionOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'environmentId', 'id', 'name', 'parameters', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'id' => [ 'shape' => 'EnvironmentActionId', ], 'name' => [ 'shape' => 'String', ], 'parameters' => [ 'shape' => 'ActionParameters', ], 'description' => [ 'shape' => 'String', ], ], ], 'CreateEnvironmentBlueprintInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'name', 'provisioningProperties', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'name' => [ 'shape' => 'EnvironmentBlueprintName', ], 'description' => [ 'shape' => 'Description', ], 'provisioningProperties' => [ 'shape' => 'ProvisioningProperties', ], 'userParameters' => [ 'shape' => 'CustomParameterList', ], ], ], 'CreateEnvironmentBlueprintOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'provider', 'provisioningProperties', ], 'members' => [ 'id' => [ 'shape' => 'EnvironmentBlueprintId', ], 'name' => [ 'shape' => 'EnvironmentBlueprintName', ], 'description' => [ 'shape' => 'Description', ], 'provider' => [ 'shape' => 'String', ], 'provisioningProperties' => [ 'shape' => 'ProvisioningProperties', ], 'deploymentProperties' => [ 'shape' => 'DeploymentProperties', ], 'userParameters' => [ 'shape' => 'CustomParameterList', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], ], ], 'CreateEnvironmentInput' => [ 'type' => 'structure', 'required' => [ 'projectIdentifier', 'domainIdentifier', 'name', ], 'members' => [ 'projectIdentifier' => [ 'shape' => 'ProjectId', ], 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'description' => [ 'shape' => 'String', ], 'name' => [ 'shape' => 'String', ], 'environmentProfileIdentifier' => [ 'shape' => 'EnvironmentProfileId', ], 'userParameters' => [ 'shape' => 'EnvironmentParametersList', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'environmentAccountIdentifier' => [ 'shape' => 'String', ], 'environmentAccountRegion' => [ 'shape' => 'String', ], 'environmentBlueprintIdentifier' => [ 'shape' => 'String', ], 'deploymentOrder' => [ 'shape' => 'Integer', ], 'environmentConfigurationId' => [ 'shape' => 'String', ], ], ], 'CreateEnvironmentOutput' => [ 'type' => 'structure', 'required' => [ 'projectId', 'domainId', 'createdBy', 'name', 'provider', ], 'members' => [ 'projectId' => [ 'shape' => 'ProjectId', ], 'id' => [ 'shape' => 'EnvironmentId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'createdBy' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'name' => [ 'shape' => 'EnvironmentName', ], 'description' => [ 'shape' => 'Description', ], 'environmentProfileId' => [ 'shape' => 'EnvironmentProfileId', ], 'awsAccountId' => [ 'shape' => 'AwsAccountId', ], 'awsAccountRegion' => [ 'shape' => 'AwsRegion', ], 'provider' => [ 'shape' => 'String', ], 'provisionedResources' => [ 'shape' => 'ResourceList', ], 'status' => [ 'shape' => 'EnvironmentStatus', ], 'environmentActions' => [ 'shape' => 'EnvironmentActionList', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'userParameters' => [ 'shape' => 'CustomParameterList', ], 'lastDeployment' => [ 'shape' => 'Deployment', ], 'provisioningProperties' => [ 'shape' => 'ProvisioningProperties', ], 'deploymentProperties' => [ 'shape' => 'DeploymentProperties', ], 'environmentBlueprintId' => [ 'shape' => 'EnvironmentBlueprintId', ], 'environmentConfigurationId' => [ 'shape' => 'EnvironmentConfigurationId', ], ], ], 'CreateEnvironmentProfileInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'name', 'environmentBlueprintIdentifier', 'projectIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'name' => [ 'shape' => 'EnvironmentProfileName', ], 'description' => [ 'shape' => 'Description', ], 'environmentBlueprintIdentifier' => [ 'shape' => 'EnvironmentBlueprintId', ], 'projectIdentifier' => [ 'shape' => 'ProjectId', ], 'userParameters' => [ 'shape' => 'EnvironmentParametersList', ], 'awsAccountId' => [ 'shape' => 'AwsAccountId', ], 'awsAccountRegion' => [ 'shape' => 'AwsRegion', ], ], ], 'CreateEnvironmentProfileOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'domainId', 'createdBy', 'name', 'environmentBlueprintId', ], 'members' => [ 'id' => [ 'shape' => 'EnvironmentProfileId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'awsAccountId' => [ 'shape' => 'AwsAccountId', ], 'awsAccountRegion' => [ 'shape' => 'AwsRegion', ], 'createdBy' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'name' => [ 'shape' => 'EnvironmentProfileName', ], 'description' => [ 'shape' => 'Description', ], 'environmentBlueprintId' => [ 'shape' => 'EnvironmentBlueprintId', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'userParameters' => [ 'shape' => 'CustomParameterList', ], ], ], 'CreateEnvironmentProfilePolicyGrantDetail' => [ 'type' => 'structure', 'members' => [ 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], ], ], 'CreateFormTypeInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'name', 'model', 'owningProjectIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'name' => [ 'shape' => 'FormTypeName', ], 'model' => [ 'shape' => 'Model', ], 'owningProjectIdentifier' => [ 'shape' => 'ProjectId', ], 'status' => [ 'shape' => 'FormTypeStatus', ], 'description' => [ 'shape' => 'Description', ], ], ], 'CreateFormTypeOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'name', 'revision', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'FormTypeName', ], 'revision' => [ 'shape' => 'Revision', ], 'description' => [ 'shape' => 'Description', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'originDomainId' => [ 'shape' => 'DomainId', ], 'originProjectId' => [ 'shape' => 'ProjectId', ], ], ], 'CreateFormTypePolicyGrantDetail' => [ 'type' => 'structure', 'members' => [ 'includeChildDomainUnits' => [ 'shape' => 'Boolean', ], ], ], 'CreateGlossaryInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'name', 'owningProjectIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'name' => [ 'shape' => 'GlossaryName', ], 'owningProjectIdentifier' => [ 'shape' => 'ProjectId', ], 'description' => [ 'shape' => 'GlossaryDescription', ], 'status' => [ 'shape' => 'GlossaryStatus', ], 'usageRestrictions' => [ 'shape' => 'GlossaryUsageRestrictions', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateGlossaryOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'name', 'owningProjectId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'GlossaryId', ], 'name' => [ 'shape' => 'GlossaryName', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'description' => [ 'shape' => 'GlossaryDescription', ], 'status' => [ 'shape' => 'GlossaryStatus', ], 'usageRestrictions' => [ 'shape' => 'GlossaryUsageRestrictions', ], ], ], 'CreateGlossaryPolicyGrantDetail' => [ 'type' => 'structure', 'members' => [ 'includeChildDomainUnits' => [ 'shape' => 'Boolean', ], ], ], 'CreateGlossaryTermInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'glossaryIdentifier', 'name', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'glossaryIdentifier' => [ 'shape' => 'GlossaryTermId', ], 'name' => [ 'shape' => 'GlossaryTermName', ], 'status' => [ 'shape' => 'GlossaryTermStatus', ], 'shortDescription' => [ 'shape' => 'ShortDescription', ], 'longDescription' => [ 'shape' => 'LongDescription', ], 'termRelations' => [ 'shape' => 'TermRelations', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateGlossaryTermOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'domainId', 'glossaryId', 'name', 'status', ], 'members' => [ 'id' => [ 'shape' => 'GlossaryTermId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'glossaryId' => [ 'shape' => 'GlossaryId', ], 'name' => [ 'shape' => 'GlossaryTermName', ], 'status' => [ 'shape' => 'GlossaryTermStatus', ], 'shortDescription' => [ 'shape' => 'ShortDescription', ], 'longDescription' => [ 'shape' => 'LongDescription', ], 'termRelations' => [ 'shape' => 'TermRelations', ], 'usageRestrictions' => [ 'shape' => 'GlossaryUsageRestrictions', ], ], ], 'CreateGroupProfileInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'groupIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'groupIdentifier' => [ 'shape' => 'GroupIdentifier', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], ], ], 'CreateGroupProfileOutput' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'GroupProfileId', ], 'status' => [ 'shape' => 'GroupProfileStatus', ], 'groupName' => [ 'shape' => 'GroupProfileName', ], ], ], 'CreateListingChangeSetInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityIdentifier', 'entityType', 'action', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityIdentifier' => [ 'shape' => 'EntityIdentifier', ], 'entityType' => [ 'shape' => 'EntityType', ], 'entityRevision' => [ 'shape' => 'Revision', ], 'action' => [ 'shape' => 'ChangeAction', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateListingChangeSetOutput' => [ 'type' => 'structure', 'required' => [ 'listingId', 'listingRevision', 'status', ], 'members' => [ 'listingId' => [ 'shape' => 'ListingId', ], 'listingRevision' => [ 'shape' => 'Revision', ], 'status' => [ 'shape' => 'ListingStatus', ], ], ], 'CreateProjectFromProjectProfilePolicyGrantDetail' => [ 'type' => 'structure', 'members' => [ 'includeChildDomainUnits' => [ 'shape' => 'Boolean', ], 'projectProfiles' => [ 'shape' => 'ProjectProfileList', ], ], ], 'CreateProjectInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'name', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'name' => [ 'shape' => 'ProjectName', ], 'description' => [ 'shape' => 'Description', ], 'resourceTags' => [ 'shape' => 'CreateProjectInputResourceTagsMap', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], 'projectProfileId' => [ 'shape' => 'ProjectProfileId', ], 'userParameters' => [ 'shape' => 'EnvironmentConfigurationUserParametersList', ], ], ], 'CreateProjectInputResourceTagsMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 25, 'min' => 0, ], 'CreateProjectMembershipInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'projectIdentifier', 'member', 'designation', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'projectIdentifier' => [ 'shape' => 'ProjectId', 'location' => 'uri', 'locationName' => 'projectIdentifier', ], 'member' => [ 'shape' => 'Member', ], 'designation' => [ 'shape' => 'UserDesignation', ], ], ], 'CreateProjectMembershipOutput' => [ 'type' => 'structure', 'members' => [], ], 'CreateProjectOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'name', 'createdBy', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'ProjectId', ], 'name' => [ 'shape' => 'ProjectName', ], 'description' => [ 'shape' => 'Description', ], 'projectStatus' => [ 'shape' => 'ProjectStatus', ], 'failureReasons' => [ 'shape' => 'FailureReasons', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'resourceTags' => [ 'shape' => 'ResourceTags', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], 'projectProfileId' => [ 'shape' => 'ProjectProfileId', ], 'userParameters' => [ 'shape' => 'EnvironmentConfigurationUserParametersList', ], 'environmentDeploymentDetails' => [ 'shape' => 'EnvironmentDeploymentDetails', ], ], ], 'CreateProjectPolicyGrantDetail' => [ 'type' => 'structure', 'members' => [ 'includeChildDomainUnits' => [ 'shape' => 'Boolean', ], ], ], 'CreateProjectProfileInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'name', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'name' => [ 'shape' => 'ProjectProfileName', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'Status', ], 'projectResourceTags' => [ 'shape' => 'ProjectResourceTagParameters', ], 'allowCustomProjectResourceTags' => [ 'shape' => 'Boolean', ], 'projectResourceTagsDescription' => [ 'shape' => 'Description', ], 'environmentConfigurations' => [ 'shape' => 'EnvironmentConfigurationsList', ], 'domainUnitIdentifier' => [ 'shape' => 'DomainUnitId', ], ], ], 'CreateProjectProfileOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'name', 'createdBy', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'ProjectProfileId', ], 'name' => [ 'shape' => 'ProjectProfileName', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'Status', ], 'projectResourceTags' => [ 'shape' => 'ProjectResourceTagParameters', ], 'allowCustomProjectResourceTags' => [ 'shape' => 'Boolean', ], 'projectResourceTagsDescription' => [ 'shape' => 'Description', ], 'environmentConfigurations' => [ 'shape' => 'EnvironmentConfigurationsList', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], ], ], 'CreateRuleInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'name', 'target', 'action', 'scope', 'detail', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'name' => [ 'shape' => 'RuleName', ], 'target' => [ 'shape' => 'RuleTarget', ], 'action' => [ 'shape' => 'RuleAction', ], 'scope' => [ 'shape' => 'RuleScope', ], 'detail' => [ 'shape' => 'RuleDetail', ], 'description' => [ 'shape' => 'Description', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateRuleOutput' => [ 'type' => 'structure', 'required' => [ 'identifier', 'name', 'ruleType', 'target', 'action', 'scope', 'detail', 'createdAt', 'createdBy', ], 'members' => [ 'identifier' => [ 'shape' => 'RuleId', ], 'name' => [ 'shape' => 'RuleName', ], 'ruleType' => [ 'shape' => 'RuleType', ], 'target' => [ 'shape' => 'RuleTarget', ], 'action' => [ 'shape' => 'RuleAction', ], 'scope' => [ 'shape' => 'RuleScope', ], 'detail' => [ 'shape' => 'RuleDetail', ], 'targetType' => [ 'shape' => 'RuleTargetType', ], 'description' => [ 'shape' => 'Description', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], ], ], 'CreateSubscriptionGrantInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentIdentifier', 'grantedEntity', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', ], 'subscriptionTargetIdentifier' => [ 'shape' => 'SubscriptionTargetId', ], 'grantedEntity' => [ 'shape' => 'GrantedEntityInput', ], 'assetTargetNames' => [ 'shape' => 'AssetTargetNames', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], ], ], 'CreateSubscriptionGrantOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'createdAt', 'updatedAt', 'subscriptionTargetId', 'grantedEntity', 'status', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionGrantId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'subscriptionTargetId' => [ 'shape' => 'SubscriptionTargetId', ], 'grantedEntity' => [ 'shape' => 'GrantedEntity', ], 'status' => [ 'shape' => 'SubscriptionGrantOverallStatus', ], 'assets' => [ 'shape' => 'SubscribedAssets', ], 'subscriptionId' => [ 'shape' => 'SubscriptionId', 'deprecated' => true, 'deprecatedMessage' => 'Multiple subscriptions can exist for a single grant', ], ], ], 'CreateSubscriptionRequestInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'subscribedPrincipals', 'subscribedListings', 'requestReason', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'subscribedPrincipals' => [ 'shape' => 'SubscribedPrincipalInputs', ], 'subscribedListings' => [ 'shape' => 'SubscribedListingInputs', ], 'requestReason' => [ 'shape' => 'RequestReason', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'metadataForms' => [ 'shape' => 'MetadataFormInputs', ], 'assetPermissions' => [ 'shape' => 'AssetPermissions', ], 'assetScopes' => [ 'shape' => 'AcceptedAssetScopes', ], ], ], 'CreateSubscriptionRequestOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'status', 'createdAt', 'updatedAt', 'requestReason', 'subscribedPrincipals', 'subscribedListings', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionRequestId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'status' => [ 'shape' => 'SubscriptionRequestStatus', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'requestReason' => [ 'shape' => 'RequestReason', ], 'subscribedPrincipals' => [ 'shape' => 'CreateSubscriptionRequestOutputSubscribedPrincipalsList', ], 'subscribedListings' => [ 'shape' => 'CreateSubscriptionRequestOutputSubscribedListingsList', ], 'reviewerId' => [ 'shape' => 'String', ], 'decisionComment' => [ 'shape' => 'DecisionComment', ], 'existingSubscriptionId' => [ 'shape' => 'SubscriptionId', ], 'metadataForms' => [ 'shape' => 'MetadataForms', ], ], ], 'CreateSubscriptionRequestOutputSubscribedListingsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedListing', ], 'max' => 1, 'min' => 1, ], 'CreateSubscriptionRequestOutputSubscribedPrincipalsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedPrincipal', ], 'max' => 1, 'min' => 1, ], 'CreateSubscriptionTargetInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentIdentifier', 'name', 'type', 'subscriptionTargetConfig', 'authorizedPrincipals', 'manageAccessRole', 'applicableAssetTypes', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'environmentIdentifier', ], 'name' => [ 'shape' => 'SubscriptionTargetName', ], 'type' => [ 'shape' => 'String', ], 'subscriptionTargetConfig' => [ 'shape' => 'SubscriptionTargetForms', ], 'authorizedPrincipals' => [ 'shape' => 'AuthorizedPrincipalIdentifiers', ], 'manageAccessRole' => [ 'shape' => 'IamRoleArn', ], 'applicableAssetTypes' => [ 'shape' => 'ApplicableAssetTypes', ], 'provider' => [ 'shape' => 'String', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'subscriptionGrantCreationMode' => [ 'shape' => 'SubscriptionGrantCreationMode', ], ], ], 'CreateSubscriptionTargetOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'authorizedPrincipals', 'domainId', 'projectId', 'environmentId', 'name', 'type', 'createdBy', 'createdAt', 'applicableAssetTypes', 'subscriptionTargetConfig', 'provider', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionTargetId', ], 'authorizedPrincipals' => [ 'shape' => 'AuthorizedPrincipalIdentifiers', ], 'domainId' => [ 'shape' => 'DomainId', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'name' => [ 'shape' => 'SubscriptionTargetName', ], 'type' => [ 'shape' => 'String', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'manageAccessRole' => [ 'shape' => 'IamRoleArn', ], 'applicableAssetTypes' => [ 'shape' => 'ApplicableAssetTypes', ], 'subscriptionTargetConfig' => [ 'shape' => 'SubscriptionTargetForms', ], 'provider' => [ 'shape' => 'String', ], 'subscriptionGrantCreationMode' => [ 'shape' => 'SubscriptionGrantCreationMode', ], ], ], 'CreateUserProfileInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'userIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'userIdentifier' => [ 'shape' => 'UserIdentifier', ], 'userType' => [ 'shape' => 'UserType', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], ], ], 'CreateUserProfileOutput' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'UserProfileId', ], 'type' => [ 'shape' => 'UserProfileType', ], 'status' => [ 'shape' => 'UserProfileStatus', ], 'details' => [ 'shape' => 'UserProfileDetails', ], ], ], 'CreatedAt' => [ 'type' => 'timestamp', ], 'CreatedBy' => [ 'type' => 'string', ], 'CredentialMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'CredentialMapKeyString', ], 'value' => [ 'shape' => 'CredentialMapValueString', ], 'sensitive' => true, ], 'CredentialMapKeyString' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'CredentialMapValueString' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'CronString' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '.*cron\\((\\b[0-5]?[0-9]\\b) (\\b2[0-3]\\b|\\b[0-1]?[0-9]\\b) ([-?*,/\\dLW]){1,83} ([-*,/\\d]|[a-zA-Z]{3}){1,23} ([-?#*,/\\dL]|[a-zA-Z]{3}){1,13} ([^\\)]+)\\).*', ], 'CustomAccountPoolHandler' => [ 'type' => 'structure', 'required' => [ 'lambdaFunctionArn', ], 'members' => [ 'lambdaFunctionArn' => [ 'shape' => 'LambdaFunctionArn', ], 'lambdaExecutionRoleArn' => [ 'shape' => 'LambdaExecutionRoleArn', ], ], ], 'CustomParameter' => [ 'type' => 'structure', 'required' => [ 'keyName', 'fieldType', ], 'members' => [ 'keyName' => [ 'shape' => 'CustomParameterKeyNameString', ], 'description' => [ 'shape' => 'Description', ], 'fieldType' => [ 'shape' => 'String', ], 'defaultValue' => [ 'shape' => 'String', ], 'isEditable' => [ 'shape' => 'Boolean', ], 'isOptional' => [ 'shape' => 'Boolean', ], 'isUpdateSupported' => [ 'shape' => 'Boolean', ], ], ], 'CustomParameterKeyNameString' => [ 'type' => 'string', 'pattern' => '[a-zA-Z_][a-zA-Z0-9_]*', ], 'CustomParameterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CustomParameter', ], ], 'DataAssetActivityStatus' => [ 'type' => 'string', 'enum' => [ 'FAILED', 'PUBLISHING_FAILED', 'SUCCEEDED_CREATED', 'SUCCEEDED_UPDATED', 'SKIPPED_ALREADY_IMPORTED', 'SKIPPED_ARCHIVED', 'SKIPPED_NO_ACCESS', 'UNCHANGED', ], ], 'DataPointIdentifier' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{0,36}', ], 'DataProductDescription' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, 'sensitive' => true, ], 'DataProductId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'DataProductItem' => [ 'type' => 'structure', 'required' => [ 'itemType', 'identifier', ], 'members' => [ 'itemType' => [ 'shape' => 'DataProductItemType', ], 'identifier' => [ 'shape' => 'EntityIdentifier', ], 'revision' => [ 'shape' => 'Revision', ], 'glossaryTerms' => [ 'shape' => 'ItemGlossaryTerms', ], ], ], 'DataProductItemAdditionalAttributes' => [ 'type' => 'structure', 'members' => [ 'matchRationale' => [ 'shape' => 'MatchRationale', ], ], ], 'DataProductItemType' => [ 'type' => 'string', 'enum' => [ 'ASSET', ], ], 'DataProductItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataProductItem', ], 'min' => 1, ], 'DataProductListing' => [ 'type' => 'structure', 'members' => [ 'dataProductId' => [ 'shape' => 'DataProductId', ], 'dataProductRevision' => [ 'shape' => 'Revision', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'forms' => [ 'shape' => 'Forms', ], 'glossaryTerms' => [ 'shape' => 'DetailedGlossaryTerms', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'items' => [ 'shape' => 'ListingSummaries', ], ], ], 'DataProductListingItem' => [ 'type' => 'structure', 'members' => [ 'listingId' => [ 'shape' => 'ListingId', ], 'listingRevision' => [ 'shape' => 'Revision', ], 'name' => [ 'shape' => 'DataProductName', ], 'entityId' => [ 'shape' => 'DataProductId', ], 'entityRevision' => [ 'shape' => 'Revision', ], 'description' => [ 'shape' => 'Description', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'listingCreatedBy' => [ 'shape' => 'CreatedBy', ], 'listingUpdatedBy' => [ 'shape' => 'UpdatedBy', ], 'glossaryTerms' => [ 'shape' => 'DetailedGlossaryTerms', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'additionalAttributes' => [ 'shape' => 'DataProductListingItemAdditionalAttributes', ], 'items' => [ 'shape' => 'ListingSummaryItems', ], ], ], 'DataProductListingItemAdditionalAttributes' => [ 'type' => 'structure', 'members' => [ 'forms' => [ 'shape' => 'Forms', ], 'matchRationale' => [ 'shape' => 'MatchRationale', ], ], ], 'DataProductName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'sensitive' => true, ], 'DataProductResultItem' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'name', 'owningProjectId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'DataProductId', ], 'name' => [ 'shape' => 'DataProductName', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'description' => [ 'shape' => 'DataProductDescription', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'firstRevisionCreatedAt' => [ 'shape' => 'CreatedAt', ], 'firstRevisionCreatedBy' => [ 'shape' => 'CreatedBy', ], 'additionalAttributes' => [ 'shape' => 'DataProductItemAdditionalAttributes', ], ], ], 'DataProductRevision' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'DataProductId', ], 'revision' => [ 'shape' => 'Revision', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], ], ], 'DataProductRevisions' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataProductRevision', ], ], 'DataProductStatus' => [ 'type' => 'string', 'enum' => [ 'CREATED', 'CREATING', 'CREATE_FAILED', ], ], 'DataSourceConfigurationInput' => [ 'type' => 'structure', 'members' => [ 'glueRunConfiguration' => [ 'shape' => 'GlueRunConfigurationInput', ], 'redshiftRunConfiguration' => [ 'shape' => 'RedshiftRunConfigurationInput', ], 'sageMakerRunConfiguration' => [ 'shape' => 'SageMakerRunConfigurationInput', ], ], 'union' => true, ], 'DataSourceConfigurationOutput' => [ 'type' => 'structure', 'members' => [ 'glueRunConfiguration' => [ 'shape' => 'GlueRunConfigurationOutput', ], 'redshiftRunConfiguration' => [ 'shape' => 'RedshiftRunConfigurationOutput', ], 'sageMakerRunConfiguration' => [ 'shape' => 'SageMakerRunConfigurationOutput', ], ], 'union' => true, ], 'DataSourceErrorMessage' => [ 'type' => 'structure', 'required' => [ 'errorType', ], 'members' => [ 'errorType' => [ 'shape' => 'DataSourceErrorType', ], 'errorDetail' => [ 'shape' => 'String', ], ], ], 'DataSourceErrorType' => [ 'type' => 'string', 'enum' => [ 'ACCESS_DENIED_EXCEPTION', 'CONFLICT_EXCEPTION', 'INTERNAL_SERVER_EXCEPTION', 'RESOURCE_NOT_FOUND_EXCEPTION', 'SERVICE_QUOTA_EXCEEDED_EXCEPTION', 'THROTTLING_EXCEPTION', 'VALIDATION_EXCEPTION', ], ], 'DataSourceId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'DataSourceRunActivities' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataSourceRunActivity', ], ], 'DataSourceRunActivity' => [ 'type' => 'structure', 'required' => [ 'database', 'dataSourceRunId', 'technicalName', 'dataAssetStatus', 'projectId', 'createdAt', 'updatedAt', ], 'members' => [ 'database' => [ 'shape' => 'Name', ], 'dataSourceRunId' => [ 'shape' => 'DataSourceRunId', ], 'technicalName' => [ 'shape' => 'Name', ], 'dataAssetStatus' => [ 'shape' => 'DataAssetActivityStatus', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'dataAssetId' => [ 'shape' => 'String', ], 'technicalDescription' => [ 'shape' => 'Description', ], 'errorMessage' => [ 'shape' => 'DataSourceErrorMessage', ], 'lineageSummary' => [ 'shape' => 'LineageInfo', ], 'createdAt' => [ 'shape' => 'DateTime', ], 'updatedAt' => [ 'shape' => 'DateTime', ], ], ], 'DataSourceRunId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'DataSourceRunLineageSummary' => [ 'type' => 'structure', 'members' => [ 'importStatus' => [ 'shape' => 'LineageImportStatus', ], ], ], 'DataSourceRunStatus' => [ 'type' => 'string', 'enum' => [ 'REQUESTED', 'RUNNING', 'FAILED', 'PARTIALLY_SUCCEEDED', 'SUCCESS', ], ], 'DataSourceRunSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataSourceRunSummary', ], ], 'DataSourceRunSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'dataSourceId', 'type', 'status', 'projectId', 'createdAt', 'updatedAt', ], 'members' => [ 'id' => [ 'shape' => 'DataSourceRunId', ], 'dataSourceId' => [ 'shape' => 'DataSourceId', ], 'type' => [ 'shape' => 'DataSourceRunType', ], 'status' => [ 'shape' => 'DataSourceRunStatus', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'runStatisticsForAssets' => [ 'shape' => 'RunStatisticsForAssets', ], 'errorMessage' => [ 'shape' => 'DataSourceErrorMessage', ], 'createdAt' => [ 'shape' => 'DateTime', ], 'updatedAt' => [ 'shape' => 'DateTime', ], 'startedAt' => [ 'shape' => 'DateTime', ], 'stoppedAt' => [ 'shape' => 'DateTime', ], 'lineageSummary' => [ 'shape' => 'DataSourceRunLineageSummary', ], ], ], 'DataSourceRunType' => [ 'type' => 'string', 'enum' => [ 'PRIORITIZED', 'SCHEDULED', ], ], 'DataSourceStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'FAILED_CREATION', 'READY', 'UPDATING', 'FAILED_UPDATE', 'RUNNING', 'DELETING', 'FAILED_DELETION', ], ], 'DataSourceSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataSourceSummary', ], ], 'DataSourceSummary' => [ 'type' => 'structure', 'required' => [ 'domainId', 'dataSourceId', 'name', 'type', 'status', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'environmentId' => [ 'shape' => 'String', ], 'connectionId' => [ 'shape' => 'String', ], 'dataSourceId' => [ 'shape' => 'DataSourceId', ], 'name' => [ 'shape' => 'Name', ], 'type' => [ 'shape' => 'String', ], 'status' => [ 'shape' => 'DataSourceStatus', ], 'enableSetting' => [ 'shape' => 'EnableSetting', ], 'schedule' => [ 'shape' => 'ScheduleConfiguration', ], 'lastRunStatus' => [ 'shape' => 'DataSourceRunStatus', ], 'lastRunAt' => [ 'shape' => 'DateTime', ], 'lastRunErrorMessage' => [ 'shape' => 'DataSourceErrorMessage', ], 'lastRunAssetCount' => [ 'shape' => 'Integer', ], 'createdAt' => [ 'shape' => 'DateTime', ], 'updatedAt' => [ 'shape' => 'DateTime', ], 'description' => [ 'shape' => 'Description', ], ], ], 'DataSourceType' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'DataZoneEntityType' => [ 'type' => 'string', 'enum' => [ 'DOMAIN_UNIT', ], ], 'DateTime' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'DecisionComment' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, 'sensitive' => true, ], 'DeleteAccountPoolInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'AccountPoolId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteAccountPoolOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteAssetFilterInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'assetIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'assetIdentifier' => [ 'shape' => 'AssetId', 'location' => 'uri', 'locationName' => 'assetIdentifier', ], 'identifier' => [ 'shape' => 'FilterId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteAssetInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'AssetIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteAssetOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteAssetTypeInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'AssetTypeIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteAssetTypeOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteConnectionInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'ConnectionId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteConnectionOutput' => [ 'type' => 'structure', 'members' => [ 'status' => [ 'shape' => 'String', ], ], ], 'DeleteDataExportConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], ], ], 'DeleteDataExportConfigurationOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteDataProductInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'DataProductId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteDataProductOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteDataSourceInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'DataSourceId', 'location' => 'uri', 'locationName' => 'identifier', ], 'clientToken' => [ 'shape' => 'String', 'deprecated' => true, 'deprecatedMessage' => 'This field is no longer required for idempotency.', 'deprecatedSince' => '2024-12-02', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], 'retainPermissionsOnRevokeFailure' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'retainPermissionsOnRevokeFailure', ], ], ], 'DeleteDataSourceOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'domainId', 'projectId', ], 'members' => [ 'id' => [ 'shape' => 'DataSourceId', ], 'status' => [ 'shape' => 'DataSourceStatus', ], 'type' => [ 'shape' => 'DataSourceType', ], 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'domainId' => [ 'shape' => 'DomainId', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'connectionId' => [ 'shape' => 'String', ], 'configuration' => [ 'shape' => 'DataSourceConfigurationOutput', ], 'enableSetting' => [ 'shape' => 'EnableSetting', ], 'publishOnImport' => [ 'shape' => 'Boolean', ], 'assetFormsOutput' => [ 'shape' => 'FormOutputList', ], 'schedule' => [ 'shape' => 'ScheduleConfiguration', ], 'lastRunStatus' => [ 'shape' => 'DataSourceRunStatus', ], 'lastRunAt' => [ 'shape' => 'DateTime', ], 'lastRunErrorMessage' => [ 'shape' => 'DataSourceErrorMessage', ], 'errorMessage' => [ 'shape' => 'DataSourceErrorMessage', ], 'createdAt' => [ 'shape' => 'DateTime', ], 'updatedAt' => [ 'shape' => 'DateTime', ], 'selfGrantStatus' => [ 'shape' => 'SelfGrantStatusOutput', ], 'retainPermissionsOnRevokeFailure' => [ 'shape' => 'Boolean', ], ], ], 'DeleteDomainInput' => [ 'type' => 'structure', 'required' => [ 'identifier', ], 'members' => [ 'identifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'identifier', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], 'skipDeletionCheck' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'skipDeletionCheck', ], ], ], 'DeleteDomainOutput' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'DomainStatus', ], ], ], 'DeleteDomainUnitInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'DomainUnitId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteDomainUnitOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteEnvironmentActionInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'environmentIdentifier', ], 'identifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteEnvironmentBlueprintConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentBlueprintIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentBlueprintIdentifier' => [ 'shape' => 'EnvironmentBlueprintId', 'location' => 'uri', 'locationName' => 'environmentBlueprintIdentifier', ], ], ], 'DeleteEnvironmentBlueprintConfigurationOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteEnvironmentBlueprintInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'EnvironmentBlueprintId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteEnvironmentInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteEnvironmentProfileInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'EnvironmentProfileId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteFormTypeInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'formTypeIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'formTypeIdentifier' => [ 'shape' => 'FormTypeIdentifier', 'location' => 'uri', 'locationName' => 'formTypeIdentifier', ], ], ], 'DeleteFormTypeOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteGlossaryInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'GlossaryId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteGlossaryOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteGlossaryTermInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'GlossaryTermId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteGlossaryTermOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteListingInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'ListingId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteListingOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteProjectInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'ProjectId', 'location' => 'uri', 'locationName' => 'identifier', ], 'skipDeletionCheck' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'skipDeletionCheck', ], ], ], 'DeleteProjectMembershipInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'projectIdentifier', 'member', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'projectIdentifier' => [ 'shape' => 'ProjectId', 'location' => 'uri', 'locationName' => 'projectIdentifier', ], 'member' => [ 'shape' => 'Member', ], ], ], 'DeleteProjectMembershipOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteProjectOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteProjectProfileInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'ProjectProfileId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteProjectProfileOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteRuleInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'RuleId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteRuleOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteSubscriptionGrantInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'SubscriptionGrantId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteSubscriptionGrantOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'createdAt', 'updatedAt', 'subscriptionTargetId', 'grantedEntity', 'status', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionGrantId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'subscriptionTargetId' => [ 'shape' => 'SubscriptionTargetId', ], 'grantedEntity' => [ 'shape' => 'GrantedEntity', ], 'status' => [ 'shape' => 'SubscriptionGrantOverallStatus', ], 'assets' => [ 'shape' => 'SubscribedAssets', ], 'subscriptionId' => [ 'shape' => 'SubscriptionId', 'deprecated' => true, 'deprecatedMessage' => 'Multiple subscriptions can exist for a single grant', ], ], ], 'DeleteSubscriptionRequestInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'SubscriptionRequestId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteSubscriptionTargetInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'environmentIdentifier', ], 'identifier' => [ 'shape' => 'SubscriptionTargetId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'DeleteTimeSeriesDataPointsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityIdentifier', 'entityType', 'formName', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityIdentifier' => [ 'shape' => 'EntityIdentifier', 'location' => 'uri', 'locationName' => 'entityIdentifier', ], 'entityType' => [ 'shape' => 'TimeSeriesEntityType', 'location' => 'uri', 'locationName' => 'entityType', ], 'formName' => [ 'shape' => 'TimeSeriesFormName', 'location' => 'querystring', 'locationName' => 'formName', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], ], ], 'DeleteTimeSeriesDataPointsOutput' => [ 'type' => 'structure', 'members' => [], ], 'Deployment' => [ 'type' => 'structure', 'members' => [ 'deploymentId' => [ 'shape' => 'String', ], 'deploymentType' => [ 'shape' => 'DeploymentType', ], 'deploymentStatus' => [ 'shape' => 'DeploymentStatus', ], 'failureReason' => [ 'shape' => 'EnvironmentError', ], 'messages' => [ 'shape' => 'DeploymentMessagesList', ], 'isDeploymentComplete' => [ 'shape' => 'Boolean', ], ], ], 'DeploymentMessage' => [ 'type' => 'string', ], 'DeploymentMessagesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DeploymentMessage', ], ], 'DeploymentMode' => [ 'type' => 'string', 'enum' => [ 'ON_CREATE', 'ON_DEMAND', ], ], 'DeploymentOrder' => [ 'type' => 'integer', 'box' => true, 'max' => 16, 'min' => 0, ], 'DeploymentProperties' => [ 'type' => 'structure', 'members' => [ 'startTimeoutMinutes' => [ 'shape' => 'DeploymentPropertiesStartTimeoutMinutesInteger', ], 'endTimeoutMinutes' => [ 'shape' => 'DeploymentPropertiesEndTimeoutMinutesInteger', ], ], ], 'DeploymentPropertiesEndTimeoutMinutesInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 225, 'min' => 1, ], 'DeploymentPropertiesStartTimeoutMinutesInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 225, 'min' => 1, ], 'DeploymentStatus' => [ 'type' => 'string', 'enum' => [ 'IN_PROGRESS', 'SUCCESSFUL', 'FAILED', 'PENDING_DEPLOYMENT', ], ], 'DeploymentType' => [ 'type' => 'string', 'enum' => [ 'CREATE', 'UPDATE', 'DELETE', ], ], 'Description' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'sensitive' => true, ], 'DetailedGlossaryTerm' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'GlossaryTermName', ], 'shortDescription' => [ 'shape' => 'ShortDescription', ], ], ], 'DetailedGlossaryTerms' => [ 'type' => 'list', 'member' => [ 'shape' => 'DetailedGlossaryTerm', ], ], 'DisassociateEnvironmentRoleInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentIdentifier', 'environmentRoleArn', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'environmentIdentifier', ], 'environmentRoleArn' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'environmentRoleArn', ], ], ], 'DisassociateEnvironmentRoleOutput' => [ 'type' => 'structure', 'members' => [], ], 'DisassociateGovernedTermsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityIdentifier', 'entityType', 'governedGlossaryTerms', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityIdentifier' => [ 'shape' => 'EntityIdentifier', 'location' => 'uri', 'locationName' => 'entityIdentifier', ], 'entityType' => [ 'shape' => 'GovernedEntityType', 'location' => 'uri', 'locationName' => 'entityType', ], 'governedGlossaryTerms' => [ 'shape' => 'DisassociateGovernedTermsInputGovernedGlossaryTermsList', ], ], ], 'DisassociateGovernedTermsInputGovernedGlossaryTermsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GlossaryTermId', ], 'max' => 5, 'min' => 1, ], 'DisassociateGovernedTermsOutput' => [ 'type' => 'structure', 'members' => [], ], 'DomainDescription' => [ 'type' => 'string', 'sensitive' => true, ], 'DomainId' => [ 'type' => 'string', 'pattern' => 'dzd[-_][a-zA-Z0-9_-]{1,36}', ], 'DomainName' => [ 'type' => 'string', 'sensitive' => true, ], 'DomainStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'AVAILABLE', 'CREATION_FAILED', 'DELETING', 'DELETED', 'DELETION_FAILED', ], ], 'DomainSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'DomainSummary', ], ], 'DomainSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'arn', 'managedAccountId', 'status', 'createdAt', ], 'members' => [ 'id' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'DomainName', ], 'description' => [ 'shape' => 'DomainDescription', ], 'arn' => [ 'shape' => 'String', ], 'managedAccountId' => [ 'shape' => 'String', ], 'status' => [ 'shape' => 'DomainStatus', ], 'portalUrl' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'lastUpdatedAt' => [ 'shape' => 'UpdatedAt', ], 'domainVersion' => [ 'shape' => 'DomainVersion', ], ], ], 'DomainUnitDescription' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'sensitive' => true, ], 'DomainUnitDesignation' => [ 'type' => 'string', 'enum' => [ 'OWNER', ], ], 'DomainUnitFilterForProject' => [ 'type' => 'structure', 'required' => [ 'domainUnit', ], 'members' => [ 'domainUnit' => [ 'shape' => 'DomainUnitId', ], 'includeChildDomainUnits' => [ 'shape' => 'Boolean', 'box' => true, ], ], ], 'DomainUnitGrantFilter' => [ 'type' => 'structure', 'members' => [ 'allDomainUnitsGrantFilter' => [ 'shape' => 'AllDomainUnitsGrantFilter', ], ], 'union' => true, ], 'DomainUnitGroupProperties' => [ 'type' => 'structure', 'members' => [ 'groupId' => [ 'shape' => 'String', ], ], ], 'DomainUnitId' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[a-z0-9_\\-]+', ], 'DomainUnitIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'DomainUnitId', ], ], 'DomainUnitName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[\\w -]+', 'sensitive' => true, ], 'DomainUnitOwnerProperties' => [ 'type' => 'structure', 'members' => [ 'user' => [ 'shape' => 'DomainUnitUserProperties', ], 'group' => [ 'shape' => 'DomainUnitGroupProperties', ], ], 'union' => true, ], 'DomainUnitOwners' => [ 'type' => 'list', 'member' => [ 'shape' => 'DomainUnitOwnerProperties', ], 'max' => 20, 'min' => 0, ], 'DomainUnitPolicyGrantPrincipal' => [ 'type' => 'structure', 'required' => [ 'domainUnitDesignation', ], 'members' => [ 'domainUnitDesignation' => [ 'shape' => 'DomainUnitDesignation', ], 'domainUnitIdentifier' => [ 'shape' => 'DomainUnitId', ], 'domainUnitGrantFilter' => [ 'shape' => 'DomainUnitGrantFilter', ], ], ], 'DomainUnitSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'DomainUnitSummary', ], ], 'DomainUnitSummary' => [ 'type' => 'structure', 'required' => [ 'name', 'id', ], 'members' => [ 'name' => [ 'shape' => 'String', ], 'id' => [ 'shape' => 'DomainUnitId', ], ], ], 'DomainUnitTarget' => [ 'type' => 'structure', 'required' => [ 'domainUnitId', ], 'members' => [ 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], 'includeChildDomainUnits' => [ 'shape' => 'Boolean', ], ], ], 'DomainUnitUserProperties' => [ 'type' => 'structure', 'members' => [ 'userId' => [ 'shape' => 'String', ], ], ], 'DomainVersion' => [ 'type' => 'string', 'enum' => [ 'V1', 'V2', ], ], 'EdgeDirection' => [ 'type' => 'string', 'enum' => [ 'UPSTREAM', 'DOWNSTREAM', ], ], 'EditedValue' => [ 'type' => 'string', 'max' => 5000, 'min' => 1, 'sensitive' => true, ], 'EnableSetting' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'EnabledRegionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RegionName', ], 'min' => 0, ], 'EncryptionConfiguration' => [ 'type' => 'structure', 'members' => [ 'kmsKeyArn' => [ 'shape' => 'String', ], 'sseAlgorithm' => [ 'shape' => 'String', ], ], ], 'EntityId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'EntityIdentifier' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'EntityOwners' => [ 'type' => 'list', 'member' => [ 'shape' => 'OwnerPropertiesOutput', ], ], 'EntityType' => [ 'type' => 'string', 'enum' => [ 'ASSET', 'DATA_PRODUCT', ], ], 'EnvironmentActionId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'EnvironmentActionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConfigurableEnvironmentAction', ], ], 'EnvironmentActionSummary' => [ 'type' => 'structure', 'required' => [ 'domainId', 'environmentId', 'id', 'name', 'parameters', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'id' => [ 'shape' => 'EnvironmentActionId', ], 'name' => [ 'shape' => 'String', ], 'parameters' => [ 'shape' => 'ActionParameters', ], 'description' => [ 'shape' => 'String', ], ], ], 'EnvironmentBlueprintConfigurationItem' => [ 'type' => 'structure', 'required' => [ 'domainId', 'environmentBlueprintId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'environmentBlueprintId' => [ 'shape' => 'EnvironmentBlueprintId', ], 'provisioningRoleArn' => [ 'shape' => 'RoleArn', ], 'environmentRolePermissionBoundary' => [ 'shape' => 'PolicyArn', ], 'manageAccessRoleArn' => [ 'shape' => 'RoleArn', ], 'enabledRegions' => [ 'shape' => 'EnabledRegionList', ], 'regionalParameters' => [ 'shape' => 'RegionalParameterMap', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'provisioningConfigurations' => [ 'shape' => 'ProvisioningConfigurationList', ], ], ], 'EnvironmentBlueprintConfigurations' => [ 'type' => 'list', 'member' => [ 'shape' => 'EnvironmentBlueprintConfigurationItem', ], ], 'EnvironmentBlueprintId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'EnvironmentBlueprintName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[\\w -]+', ], 'EnvironmentBlueprintSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'EnvironmentBlueprintSummary', ], ], 'EnvironmentBlueprintSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'provider', 'provisioningProperties', ], 'members' => [ 'id' => [ 'shape' => 'EnvironmentBlueprintId', ], 'name' => [ 'shape' => 'EnvironmentBlueprintName', ], 'description' => [ 'shape' => 'Description', ], 'provider' => [ 'shape' => 'String', ], 'provisioningProperties' => [ 'shape' => 'ProvisioningProperties', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], ], ], 'EnvironmentConfiguration' => [ 'type' => 'structure', 'required' => [ 'name', 'environmentBlueprintId', ], 'members' => [ 'name' => [ 'shape' => 'EnvironmentConfigurationName', ], 'id' => [ 'shape' => 'EnvironmentConfigurationId', ], 'environmentBlueprintId' => [ 'shape' => 'EnvironmentBlueprintId', ], 'description' => [ 'shape' => 'Description', ], 'deploymentMode' => [ 'shape' => 'DeploymentMode', ], 'configurationParameters' => [ 'shape' => 'EnvironmentConfigurationParametersDetails', ], 'awsAccount' => [ 'shape' => 'AwsAccount', ], 'accountPools' => [ 'shape' => 'AccountPoolList', ], 'awsRegion' => [ 'shape' => 'Region', ], 'deploymentOrder' => [ 'shape' => 'DeploymentOrder', ], ], ], 'EnvironmentConfigurationId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', 'sensitive' => true, ], 'EnvironmentConfigurationName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[\\w -]+', 'sensitive' => true, ], 'EnvironmentConfigurationParameter' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'EnvironmentConfigurationParameterName', ], 'value' => [ 'shape' => 'String', ], 'isEditable' => [ 'shape' => 'Boolean', ], ], ], 'EnvironmentConfigurationParameterName' => [ 'type' => 'string', 'pattern' => '[a-zA-Z_][a-zA-Z0-9_]*', ], 'EnvironmentConfigurationParametersDetails' => [ 'type' => 'structure', 'members' => [ 'ssmPath' => [ 'shape' => 'ParameterStorePath', ], 'parameterOverrides' => [ 'shape' => 'EnvironmentConfigurationParametersList', ], 'resolvedParameters' => [ 'shape' => 'EnvironmentConfigurationParametersList', ], ], ], 'EnvironmentConfigurationParametersList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EnvironmentConfigurationParameter', ], ], 'EnvironmentConfigurationUserParameter' => [ 'type' => 'structure', 'members' => [ 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'environmentResolvedAccount' => [ 'shape' => 'EnvironmentResolvedAccount', ], 'environmentConfigurationName' => [ 'shape' => 'EnvironmentConfigurationName', ], 'environmentParameters' => [ 'shape' => 'EnvironmentParametersList', ], ], ], 'EnvironmentConfigurationUserParametersList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EnvironmentConfigurationUserParameter', ], ], 'EnvironmentConfigurationsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EnvironmentConfiguration', ], ], 'EnvironmentDeploymentDetails' => [ 'type' => 'structure', 'members' => [ 'overallDeploymentStatus' => [ 'shape' => 'OverallDeploymentStatus', ], 'environmentFailureReasons' => [ 'shape' => 'EnvironmentFailureReasons', ], ], ], 'EnvironmentError' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'code' => [ 'shape' => 'String', ], 'message' => [ 'shape' => 'String', ], ], ], 'EnvironmentFailureReasons' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'EnvironmentFailureReasonsList', ], ], 'EnvironmentFailureReasonsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EnvironmentError', ], ], 'EnvironmentId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'EnvironmentName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[\\w -]+', 'sensitive' => true, ], 'EnvironmentParameter' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'EnvironmentParametersList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EnvironmentParameter', ], ], 'EnvironmentProfileId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{0,36}', ], 'EnvironmentProfileName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[\\w -]+', 'sensitive' => true, ], 'EnvironmentProfileSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'EnvironmentProfileSummary', ], ], 'EnvironmentProfileSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'domainId', 'createdBy', 'name', 'environmentBlueprintId', ], 'members' => [ 'id' => [ 'shape' => 'EnvironmentProfileId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'awsAccountId' => [ 'shape' => 'AwsAccountId', ], 'awsAccountRegion' => [ 'shape' => 'AwsRegion', ], 'createdBy' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'name' => [ 'shape' => 'EnvironmentProfileName', ], 'description' => [ 'shape' => 'Description', ], 'environmentBlueprintId' => [ 'shape' => 'EnvironmentBlueprintId', ], 'projectId' => [ 'shape' => 'ProjectId', ], ], ], 'EnvironmentResolvedAccount' => [ 'type' => 'structure', 'required' => [ 'awsAccountId', 'regionName', ], 'members' => [ 'awsAccountId' => [ 'shape' => 'AwsAccountId', ], 'regionName' => [ 'shape' => 'AwsRegion', ], 'sourceAccountPoolId' => [ 'shape' => 'AccountPoolId', ], ], ], 'EnvironmentStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'CREATING', 'UPDATING', 'DELETING', 'CREATE_FAILED', 'UPDATE_FAILED', 'DELETE_FAILED', 'VALIDATION_FAILED', 'SUSPENDED', 'DISABLED', 'EXPIRED', 'DELETED', 'INACCESSIBLE', ], ], 'EnvironmentSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'EnvironmentSummary', ], ], 'EnvironmentSummary' => [ 'type' => 'structure', 'required' => [ 'projectId', 'domainId', 'createdBy', 'name', 'provider', ], 'members' => [ 'projectId' => [ 'shape' => 'ProjectId', ], 'id' => [ 'shape' => 'EnvironmentId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'createdBy' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'name' => [ 'shape' => 'EnvironmentName', ], 'description' => [ 'shape' => 'Description', ], 'environmentProfileId' => [ 'shape' => 'EnvironmentProfileId', ], 'awsAccountId' => [ 'shape' => 'AwsAccountId', ], 'awsAccountRegion' => [ 'shape' => 'AwsRegion', ], 'provider' => [ 'shape' => 'String', ], 'status' => [ 'shape' => 'EnvironmentStatus', ], 'environmentConfigurationId' => [ 'shape' => 'EnvironmentConfigurationId', ], ], ], 'EqualToExpression' => [ 'type' => 'structure', 'required' => [ 'columnName', 'value', ], 'members' => [ 'columnName' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'ErrorMessage' => [ 'type' => 'string', ], 'EventSummary' => [ 'type' => 'structure', 'members' => [ 'openLineageRunEventSummary' => [ 'shape' => 'OpenLineageRunEventSummary', ], ], 'union' => true, ], 'ExternalIdentifier' => [ 'type' => 'string', 'max' => 600, 'min' => 1, ], 'FailedQueryProcessingErrorMessages' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], 'max' => 10, 'min' => 0, ], 'FailureCause' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], ], 'FailureReasons' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProjectDeletionError', ], ], 'Filter' => [ 'type' => 'structure', 'required' => [ 'attribute', ], 'members' => [ 'attribute' => [ 'shape' => 'Attribute', ], 'value' => [ 'shape' => 'FilterValueString', ], 'intValue' => [ 'shape' => 'Long', ], 'operator' => [ 'shape' => 'FilterOperator', ], ], ], 'FilterClause' => [ 'type' => 'structure', 'members' => [ 'filter' => [ 'shape' => 'Filter', ], 'and' => [ 'shape' => 'FilterList', ], 'or' => [ 'shape' => 'FilterList', ], ], 'union' => true, ], 'FilterExpression' => [ 'type' => 'structure', 'required' => [ 'type', 'expression', ], 'members' => [ 'type' => [ 'shape' => 'FilterExpressionType', ], 'expression' => [ 'shape' => 'FilterExpressionExpressionString', ], ], ], 'FilterExpressionExpressionString' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'FilterExpressionType' => [ 'type' => 'string', 'enum' => [ 'INCLUDE', 'EXCLUDE', ], ], 'FilterExpressions' => [ 'type' => 'list', 'member' => [ 'shape' => 'FilterExpression', ], ], 'FilterId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'FilterIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'FilterId', ], ], 'FilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FilterClause', ], 'max' => 100, 'min' => 1, ], 'FilterName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[\\w -]+', 'sensitive' => true, ], 'FilterOperator' => [ 'type' => 'string', 'enum' => [ 'EQ', 'LE', 'LT', 'GE', 'GT', 'TEXT_SEARCH', ], ], 'FilterStatus' => [ 'type' => 'string', 'enum' => [ 'VALID', 'INVALID', ], ], 'FilterValueString' => [ 'type' => 'string', 'max' => 128, 'min' => 0, ], 'FirstName' => [ 'type' => 'string', 'sensitive' => true, ], 'Float' => [ 'type' => 'float', 'box' => true, ], 'FormEntryInput' => [ 'type' => 'structure', 'required' => [ 'typeIdentifier', 'typeRevision', ], 'members' => [ 'typeIdentifier' => [ 'shape' => 'FormTypeIdentifier', ], 'typeRevision' => [ 'shape' => 'Revision', ], 'required' => [ 'shape' => 'Boolean', ], ], ], 'FormEntryOutput' => [ 'type' => 'structure', 'required' => [ 'typeName', 'typeRevision', ], 'members' => [ 'typeName' => [ 'shape' => 'FormTypeName', ], 'typeRevision' => [ 'shape' => 'Revision', ], 'required' => [ 'shape' => 'Boolean', ], ], ], 'FormInput' => [ 'type' => 'structure', 'required' => [ 'formName', ], 'members' => [ 'formName' => [ 'shape' => 'FormName', ], 'typeIdentifier' => [ 'shape' => 'FormTypeIdentifier', ], 'typeRevision' => [ 'shape' => 'RevisionInput', ], 'content' => [ 'shape' => 'FormInputContentString', ], ], 'sensitive' => true, ], 'FormInputContentString' => [ 'type' => 'string', 'max' => 300000, 'min' => 0, ], 'FormInputList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FormInput', ], 'max' => 10, 'min' => 0, 'sensitive' => true, ], 'FormName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '(?![0-9_])\\w+$|^_\\w*[a-zA-Z0-9]\\w*', ], 'FormOutput' => [ 'type' => 'structure', 'required' => [ 'formName', ], 'members' => [ 'formName' => [ 'shape' => 'FormName', ], 'typeName' => [ 'shape' => 'FormTypeName', ], 'typeRevision' => [ 'shape' => 'Revision', ], 'content' => [ 'shape' => 'String', ], ], ], 'FormOutputList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FormOutput', ], 'max' => 10, 'min' => 0, ], 'FormTypeData' => [ 'type' => 'structure', 'required' => [ 'domainId', 'name', 'revision', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'FormTypeName', ], 'revision' => [ 'shape' => 'Revision', ], 'model' => [ 'shape' => 'Model', ], 'status' => [ 'shape' => 'FormTypeStatus', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'originDomainId' => [ 'shape' => 'DomainId', ], 'originProjectId' => [ 'shape' => 'ProjectId', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'description' => [ 'shape' => 'Description', ], 'imports' => [ 'shape' => 'ImportList', ], ], ], 'FormTypeIdentifier' => [ 'type' => 'string', 'max' => 385, 'min' => 1, 'pattern' => '(?!\\.)[\\w\\.]*\\w', ], 'FormTypeName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '(amazon.datazone.)?(?![0-9_])\\w+$|^_\\w*[a-zA-Z0-9]\\w*', 'sensitive' => true, ], 'FormTypeStatus' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'Forms' => [ 'type' => 'string', ], 'FormsInputMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'FormName', ], 'value' => [ 'shape' => 'FormEntryInput', ], 'max' => 10, 'min' => 0, ], 'FormsOutputMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'FormName', ], 'value' => [ 'shape' => 'FormEntryOutput', ], 'max' => 10, 'min' => 0, ], 'GetAccountPoolInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'AccountPoolId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetAccountPoolOutput' => [ 'type' => 'structure', 'required' => [ 'accountSource', 'createdBy', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'AccountPoolName', ], 'id' => [ 'shape' => 'AccountPoolId', ], 'description' => [ 'shape' => 'Description', ], 'resolutionStrategy' => [ 'shape' => 'ResolutionStrategy', ], 'accountSource' => [ 'shape' => 'AccountSource', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], ], ], 'GetAssetFilterInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'assetIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'assetIdentifier' => [ 'shape' => 'AssetId', 'location' => 'uri', 'locationName' => 'assetIdentifier', ], 'identifier' => [ 'shape' => 'FilterId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetAssetFilterOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'domainId', 'assetId', 'name', 'configuration', ], 'members' => [ 'id' => [ 'shape' => 'FilterId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'assetId' => [ 'shape' => 'AssetId', ], 'name' => [ 'shape' => 'FilterName', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'FilterStatus', ], 'configuration' => [ 'shape' => 'AssetFilterConfiguration', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'errorMessage' => [ 'shape' => 'String', ], 'effectiveColumnNames' => [ 'shape' => 'ColumnNameList', ], 'effectiveRowFilter' => [ 'shape' => 'String', ], ], ], 'GetAssetInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'AssetIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], 'revision' => [ 'shape' => 'Revision', 'location' => 'querystring', 'locationName' => 'revision', ], ], ], 'GetAssetOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'typeIdentifier', 'typeRevision', 'revision', 'owningProjectId', 'domainId', 'formsOutput', ], 'members' => [ 'id' => [ 'shape' => 'AssetId', ], 'name' => [ 'shape' => 'AssetName', ], 'typeIdentifier' => [ 'shape' => 'AssetTypeIdentifier', ], 'typeRevision' => [ 'shape' => 'Revision', ], 'externalIdentifier' => [ 'shape' => 'ExternalIdentifier', ], 'revision' => [ 'shape' => 'Revision', ], 'description' => [ 'shape' => 'Description', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'firstRevisionCreatedAt' => [ 'shape' => 'CreatedAt', ], 'firstRevisionCreatedBy' => [ 'shape' => 'CreatedBy', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'governedGlossaryTerms' => [ 'shape' => 'GetAssetOutputGovernedGlossaryTermsList', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'listing' => [ 'shape' => 'AssetListingDetails', ], 'formsOutput' => [ 'shape' => 'FormOutputList', ], 'readOnlyFormsOutput' => [ 'shape' => 'FormOutputList', ], 'latestTimeSeriesDataPointFormsOutput' => [ 'shape' => 'TimeSeriesDataPointSummaryFormOutputList', ], ], ], 'GetAssetOutputGovernedGlossaryTermsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GlossaryTermId', ], 'max' => 20, 'min' => 0, ], 'GetAssetTypeInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'AssetTypeIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], 'revision' => [ 'shape' => 'Revision', 'location' => 'querystring', 'locationName' => 'revision', ], ], ], 'GetAssetTypeOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'name', 'revision', 'formsOutput', 'owningProjectId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'TypeName', ], 'revision' => [ 'shape' => 'Revision', ], 'description' => [ 'shape' => 'Description', ], 'formsOutput' => [ 'shape' => 'FormsOutputMap', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'originDomainId' => [ 'shape' => 'DomainId', ], 'originProjectId' => [ 'shape' => 'ProjectId', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], ], ], 'GetConnectionInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'ConnectionId', 'location' => 'uri', 'locationName' => 'identifier', ], 'withSecret' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'withSecret', ], ], ], 'GetConnectionOutput' => [ 'type' => 'structure', 'required' => [ 'connectionId', 'domainId', 'domainUnitId', 'name', 'physicalEndpoints', 'type', ], 'members' => [ 'connectionCredentials' => [ 'shape' => 'ConnectionCredentials', ], 'connectionId' => [ 'shape' => 'ConnectionId', ], 'description' => [ 'shape' => 'Description', ], 'domainId' => [ 'shape' => 'DomainId', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'environmentUserRole' => [ 'shape' => 'String', ], 'name' => [ 'shape' => 'ConnectionName', ], 'physicalEndpoints' => [ 'shape' => 'PhysicalEndpoints', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'props' => [ 'shape' => 'ConnectionPropertiesOutput', ], 'type' => [ 'shape' => 'ConnectionType', ], 'scope' => [ 'shape' => 'ConnectionScope', ], ], ], 'GetDataExportConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], ], ], 'GetDataExportConfigurationOutput' => [ 'type' => 'structure', 'members' => [ 'isExportEnabled' => [ 'shape' => 'Boolean', ], 'status' => [ 'shape' => 'ConfigurationStatus', ], 'encryptionConfiguration' => [ 'shape' => 'EncryptionConfiguration', ], 's3TableBucketArn' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], ], ], 'GetDataProductInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'DataProductId', 'location' => 'uri', 'locationName' => 'identifier', ], 'revision' => [ 'shape' => 'Revision', 'location' => 'querystring', 'locationName' => 'revision', ], ], ], 'GetDataProductOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'revision', 'owningProjectId', 'name', 'status', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'DataProductId', ], 'revision' => [ 'shape' => 'Revision', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'name' => [ 'shape' => 'DataProductName', ], 'status' => [ 'shape' => 'DataProductStatus', ], 'description' => [ 'shape' => 'DataProductDescription', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'items' => [ 'shape' => 'DataProductItems', ], 'formsOutput' => [ 'shape' => 'FormOutputList', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'firstRevisionCreatedAt' => [ 'shape' => 'CreatedAt', ], 'firstRevisionCreatedBy' => [ 'shape' => 'CreatedBy', ], ], ], 'GetDataSourceInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'DataSourceId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetDataSourceOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'domainId', 'projectId', ], 'members' => [ 'id' => [ 'shape' => 'DataSourceId', ], 'status' => [ 'shape' => 'DataSourceStatus', ], 'type' => [ 'shape' => 'DataSourceType', ], 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'domainId' => [ 'shape' => 'DomainId', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'connectionId' => [ 'shape' => 'String', ], 'configuration' => [ 'shape' => 'DataSourceConfigurationOutput', ], 'recommendation' => [ 'shape' => 'RecommendationConfiguration', ], 'enableSetting' => [ 'shape' => 'EnableSetting', ], 'publishOnImport' => [ 'shape' => 'Boolean', ], 'assetFormsOutput' => [ 'shape' => 'FormOutputList', ], 'schedule' => [ 'shape' => 'ScheduleConfiguration', ], 'lastRunStatus' => [ 'shape' => 'DataSourceRunStatus', ], 'lastRunAt' => [ 'shape' => 'DateTime', ], 'lastRunErrorMessage' => [ 'shape' => 'DataSourceErrorMessage', ], 'lastRunAssetCount' => [ 'shape' => 'Integer', ], 'errorMessage' => [ 'shape' => 'DataSourceErrorMessage', ], 'createdAt' => [ 'shape' => 'DateTime', ], 'updatedAt' => [ 'shape' => 'DateTime', ], 'selfGrantStatus' => [ 'shape' => 'SelfGrantStatusOutput', ], ], ], 'GetDataSourceRunInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'DataSourceRunId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetDataSourceRunOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'dataSourceId', 'id', 'projectId', 'status', 'type', 'createdAt', 'updatedAt', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'dataSourceId' => [ 'shape' => 'DataSourceId', ], 'id' => [ 'shape' => 'DataSourceRunId', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'status' => [ 'shape' => 'DataSourceRunStatus', ], 'type' => [ 'shape' => 'DataSourceRunType', ], 'dataSourceConfigurationSnapshot' => [ 'shape' => 'String', ], 'runStatisticsForAssets' => [ 'shape' => 'RunStatisticsForAssets', ], 'lineageSummary' => [ 'shape' => 'DataSourceRunLineageSummary', ], 'errorMessage' => [ 'shape' => 'DataSourceErrorMessage', ], 'createdAt' => [ 'shape' => 'DateTime', ], 'updatedAt' => [ 'shape' => 'DateTime', ], 'startedAt' => [ 'shape' => 'DateTime', ], 'stoppedAt' => [ 'shape' => 'DateTime', ], ], ], 'GetDomainInput' => [ 'type' => 'structure', 'required' => [ 'identifier', ], 'members' => [ 'identifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetDomainOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'domainExecutionRole', 'status', ], 'members' => [ 'id' => [ 'shape' => 'DomainId', ], 'rootDomainUnitId' => [ 'shape' => 'DomainUnitId', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'singleSignOn' => [ 'shape' => 'SingleSignOn', ], 'domainExecutionRole' => [ 'shape' => 'RoleArn', ], 'arn' => [ 'shape' => 'String', ], 'kmsKeyIdentifier' => [ 'shape' => 'KmsKeyArn', ], 'status' => [ 'shape' => 'DomainStatus', ], 'portalUrl' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'lastUpdatedAt' => [ 'shape' => 'UpdatedAt', ], 'tags' => [ 'shape' => 'Tags', ], 'domainVersion' => [ 'shape' => 'DomainVersion', ], 'serviceRole' => [ 'shape' => 'RoleArn', ], ], ], 'GetDomainUnitInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'DomainUnitId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetDomainUnitOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'domainId', 'name', 'owners', ], 'members' => [ 'id' => [ 'shape' => 'DomainUnitId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'DomainUnitName', ], 'parentDomainUnitId' => [ 'shape' => 'DomainUnitId', ], 'description' => [ 'shape' => 'DomainUnitDescription', ], 'owners' => [ 'shape' => 'DomainUnitOwners', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'lastUpdatedAt' => [ 'shape' => 'UpdatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'lastUpdatedBy' => [ 'shape' => 'UpdatedBy', ], ], ], 'GetEnvironmentActionInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'environmentIdentifier', ], 'identifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetEnvironmentActionOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'environmentId', 'id', 'name', 'parameters', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'id' => [ 'shape' => 'EnvironmentActionId', ], 'name' => [ 'shape' => 'String', ], 'parameters' => [ 'shape' => 'ActionParameters', ], 'description' => [ 'shape' => 'String', ], ], ], 'GetEnvironmentBlueprintConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentBlueprintIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentBlueprintIdentifier' => [ 'shape' => 'EnvironmentBlueprintId', 'location' => 'uri', 'locationName' => 'environmentBlueprintIdentifier', ], ], ], 'GetEnvironmentBlueprintConfigurationOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'environmentBlueprintId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'environmentBlueprintId' => [ 'shape' => 'EnvironmentBlueprintId', ], 'provisioningRoleArn' => [ 'shape' => 'RoleArn', ], 'environmentRolePermissionBoundary' => [ 'shape' => 'PolicyArn', ], 'manageAccessRoleArn' => [ 'shape' => 'RoleArn', ], 'enabledRegions' => [ 'shape' => 'EnabledRegionList', ], 'regionalParameters' => [ 'shape' => 'RegionalParameterMap', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'provisioningConfigurations' => [ 'shape' => 'ProvisioningConfigurationList', ], ], ], 'GetEnvironmentBlueprintInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'EnvironmentBlueprintId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetEnvironmentBlueprintOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'provider', 'provisioningProperties', ], 'members' => [ 'id' => [ 'shape' => 'EnvironmentBlueprintId', ], 'name' => [ 'shape' => 'EnvironmentBlueprintName', ], 'description' => [ 'shape' => 'Description', ], 'provider' => [ 'shape' => 'String', ], 'provisioningProperties' => [ 'shape' => 'ProvisioningProperties', ], 'deploymentProperties' => [ 'shape' => 'DeploymentProperties', ], 'userParameters' => [ 'shape' => 'CustomParameterList', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], ], ], 'GetEnvironmentCredentialsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'environmentIdentifier', ], ], ], 'GetEnvironmentCredentialsOutput' => [ 'type' => 'structure', 'members' => [ 'accessKeyId' => [ 'shape' => 'String', ], 'secretAccessKey' => [ 'shape' => 'String', ], 'sessionToken' => [ 'shape' => 'String', ], 'expiration' => [ 'shape' => 'SyntheticTimestamp_date_time', ], ], 'sensitive' => true, ], 'GetEnvironmentInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetEnvironmentOutput' => [ 'type' => 'structure', 'required' => [ 'projectId', 'domainId', 'createdBy', 'name', 'provider', ], 'members' => [ 'projectId' => [ 'shape' => 'ProjectId', ], 'id' => [ 'shape' => 'EnvironmentId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'createdBy' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'name' => [ 'shape' => 'EnvironmentName', ], 'description' => [ 'shape' => 'Description', ], 'environmentProfileId' => [ 'shape' => 'EnvironmentProfileId', ], 'awsAccountId' => [ 'shape' => 'AwsAccountId', ], 'awsAccountRegion' => [ 'shape' => 'AwsRegion', ], 'provider' => [ 'shape' => 'String', ], 'provisionedResources' => [ 'shape' => 'ResourceList', ], 'status' => [ 'shape' => 'EnvironmentStatus', ], 'environmentActions' => [ 'shape' => 'EnvironmentActionList', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'userParameters' => [ 'shape' => 'CustomParameterList', ], 'lastDeployment' => [ 'shape' => 'Deployment', ], 'provisioningProperties' => [ 'shape' => 'ProvisioningProperties', ], 'deploymentProperties' => [ 'shape' => 'DeploymentProperties', ], 'environmentBlueprintId' => [ 'shape' => 'EnvironmentBlueprintId', ], 'environmentConfigurationId' => [ 'shape' => 'EnvironmentConfigurationId', ], ], ], 'GetEnvironmentProfileInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'EnvironmentProfileId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetEnvironmentProfileOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'domainId', 'createdBy', 'name', 'environmentBlueprintId', ], 'members' => [ 'id' => [ 'shape' => 'EnvironmentProfileId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'awsAccountId' => [ 'shape' => 'AwsAccountId', ], 'awsAccountRegion' => [ 'shape' => 'AwsRegion', ], 'createdBy' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'name' => [ 'shape' => 'EnvironmentProfileName', ], 'description' => [ 'shape' => 'Description', ], 'environmentBlueprintId' => [ 'shape' => 'EnvironmentBlueprintId', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'userParameters' => [ 'shape' => 'CustomParameterList', ], ], ], 'GetFormTypeInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'formTypeIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'formTypeIdentifier' => [ 'shape' => 'FormTypeIdentifier', 'location' => 'uri', 'locationName' => 'formTypeIdentifier', ], 'revision' => [ 'shape' => 'Revision', 'location' => 'querystring', 'locationName' => 'revision', ], ], ], 'GetFormTypeOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'name', 'revision', 'model', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'FormTypeName', ], 'revision' => [ 'shape' => 'Revision', ], 'model' => [ 'shape' => 'Model', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'originDomainId' => [ 'shape' => 'DomainId', ], 'originProjectId' => [ 'shape' => 'ProjectId', ], 'status' => [ 'shape' => 'FormTypeStatus', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'description' => [ 'shape' => 'Description', ], 'imports' => [ 'shape' => 'ImportList', ], ], ], 'GetGlossaryInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'GlossaryId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetGlossaryOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'owningProjectId', 'name', 'status', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'GlossaryId', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'name' => [ 'shape' => 'GlossaryName', ], 'description' => [ 'shape' => 'GlossaryDescription', ], 'status' => [ 'shape' => 'GlossaryStatus', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'usageRestrictions' => [ 'shape' => 'GlossaryUsageRestrictions', ], ], ], 'GetGlossaryTermInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'GlossaryTermId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetGlossaryTermOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'glossaryId', 'id', 'name', 'status', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'glossaryId' => [ 'shape' => 'GlossaryId', ], 'id' => [ 'shape' => 'GlossaryTermId', ], 'name' => [ 'shape' => 'GlossaryTermName', ], 'shortDescription' => [ 'shape' => 'ShortDescription', ], 'longDescription' => [ 'shape' => 'LongDescription', ], 'termRelations' => [ 'shape' => 'TermRelations', ], 'status' => [ 'shape' => 'GlossaryTermStatus', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'usageRestrictions' => [ 'shape' => 'GlossaryUsageRestrictions', ], ], ], 'GetGroupProfileInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'groupIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'groupIdentifier' => [ 'shape' => 'GroupIdentifier', 'location' => 'uri', 'locationName' => 'groupIdentifier', ], ], ], 'GetGroupProfileOutput' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'GroupProfileId', ], 'status' => [ 'shape' => 'GroupProfileStatus', ], 'groupName' => [ 'shape' => 'GroupProfileName', ], ], ], 'GetIamPortalLoginUrlInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], ], ], 'GetIamPortalLoginUrlOutput' => [ 'type' => 'structure', 'required' => [ 'userProfileId', ], 'members' => [ 'authCodeUrl' => [ 'shape' => 'String', ], 'userProfileId' => [ 'shape' => 'String', ], ], ], 'GetJobRunInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'RunIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetJobRunOutput' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'String', ], 'jobId' => [ 'shape' => 'String', ], 'jobType' => [ 'shape' => 'JobType', ], 'runMode' => [ 'shape' => 'JobRunMode', ], 'details' => [ 'shape' => 'JobRunDetails', ], 'status' => [ 'shape' => 'JobRunStatus', ], 'error' => [ 'shape' => 'JobRunError', ], 'createdBy' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'startTime' => [ 'shape' => 'Timestamp', ], 'endTime' => [ 'shape' => 'Timestamp', ], ], ], 'GetLineageEventInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'LineageEventIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetLineageEventOutput' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', 'location' => 'header', 'locationName' => 'Domain-Id', ], 'id' => [ 'shape' => 'LineageEventIdentifier', 'location' => 'header', 'locationName' => 'Id', ], 'event' => [ 'shape' => 'LineageEvent', ], 'createdBy' => [ 'shape' => 'CreatedBy', 'location' => 'header', 'locationName' => 'Created-By', ], 'processingStatus' => [ 'shape' => 'LineageEventProcessingStatus', 'location' => 'header', 'locationName' => 'Processing-Status', ], 'eventTime' => [ 'shape' => 'Timestamp', 'location' => 'header', 'locationName' => 'Event-Time', ], 'createdAt' => [ 'shape' => 'CreatedAt', 'location' => 'header', 'locationName' => 'Created-At', ], ], 'payload' => 'event', ], 'GetLineageNodeInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'LineageNodeIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], 'eventTimestamp' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'timestamp', ], ], ], 'GetLineageNodeOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'typeName', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'id' => [ 'shape' => 'LineageNodeId', ], 'typeName' => [ 'shape' => 'String', ], 'typeRevision' => [ 'shape' => 'Revision', ], 'sourceIdentifier' => [ 'shape' => 'String', ], 'eventTimestamp' => [ 'shape' => 'Timestamp', ], 'formsOutput' => [ 'shape' => 'FormOutputList', ], 'upstreamNodes' => [ 'shape' => 'LineageNodeReferenceList', ], 'downstreamNodes' => [ 'shape' => 'LineageNodeReferenceList', ], ], ], 'GetListingInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'ListingId', 'location' => 'uri', 'locationName' => 'identifier', ], 'listingRevision' => [ 'shape' => 'Revision', 'location' => 'querystring', 'locationName' => 'listingRevision', ], ], ], 'GetListingOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'listingRevision', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'ListingId', ], 'listingRevision' => [ 'shape' => 'Revision', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'item' => [ 'shape' => 'ListingItem', ], 'name' => [ 'shape' => 'ListingName', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'ListingStatus', ], ], ], 'GetMetadataGenerationRunInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'MetadataGenerationRunIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], 'type' => [ 'shape' => 'MetadataGenerationRunType', 'location' => 'querystring', 'locationName' => 'type', ], ], ], 'GetMetadataGenerationRunOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'owningProjectId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'MetadataGenerationRunIdentifier', ], 'target' => [ 'shape' => 'MetadataGenerationRunTarget', ], 'status' => [ 'shape' => 'MetadataGenerationRunStatus', ], 'type' => [ 'shape' => 'MetadataGenerationRunType', 'deprecated' => true, 'deprecatedMessage' => 'This field is going to be deprecated, please use the \'types\' field to provide the MetadataGenerationRun types', 'deprecatedSince' => '2025-11-21', ], 'types' => [ 'shape' => 'MetadataGenerationRunTypes', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'typeStats' => [ 'shape' => 'MetadataGenerationRunTypeStats', ], ], ], 'GetProjectInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'ProjectId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetProjectOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'name', 'createdBy', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'ProjectId', ], 'name' => [ 'shape' => 'ProjectName', ], 'description' => [ 'shape' => 'Description', ], 'projectStatus' => [ 'shape' => 'ProjectStatus', ], 'failureReasons' => [ 'shape' => 'FailureReasons', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'resourceTags' => [ 'shape' => 'ResourceTags', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], 'projectProfileId' => [ 'shape' => 'ProjectProfileId', ], 'userParameters' => [ 'shape' => 'EnvironmentConfigurationUserParametersList', ], 'environmentDeploymentDetails' => [ 'shape' => 'EnvironmentDeploymentDetails', ], ], ], 'GetProjectProfileInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'ProjectProfileId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetProjectProfileOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'name', 'createdBy', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'ProjectProfileId', ], 'name' => [ 'shape' => 'ProjectProfileName', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'Status', ], 'projectResourceTags' => [ 'shape' => 'ProjectResourceTagParameters', ], 'allowCustomProjectResourceTags' => [ 'shape' => 'Boolean', ], 'projectResourceTagsDescription' => [ 'shape' => 'Description', ], 'environmentConfigurations' => [ 'shape' => 'EnvironmentConfigurationsList', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], ], ], 'GetRuleInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'RuleId', 'location' => 'uri', 'locationName' => 'identifier', ], 'revision' => [ 'shape' => 'Revision', 'location' => 'querystring', 'locationName' => 'revision', ], ], ], 'GetRuleOutput' => [ 'type' => 'structure', 'required' => [ 'identifier', 'revision', 'name', 'ruleType', 'target', 'action', 'scope', 'detail', 'createdAt', 'updatedAt', 'createdBy', 'lastUpdatedBy', ], 'members' => [ 'identifier' => [ 'shape' => 'RuleId', ], 'revision' => [ 'shape' => 'Revision', ], 'name' => [ 'shape' => 'RuleName', ], 'ruleType' => [ 'shape' => 'RuleType', ], 'target' => [ 'shape' => 'RuleTarget', ], 'action' => [ 'shape' => 'RuleAction', ], 'scope' => [ 'shape' => 'RuleScope', ], 'detail' => [ 'shape' => 'RuleDetail', ], 'targetType' => [ 'shape' => 'RuleTargetType', ], 'description' => [ 'shape' => 'Description', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'lastUpdatedBy' => [ 'shape' => 'UpdatedBy', ], ], ], 'GetSubscriptionGrantInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'SubscriptionGrantId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetSubscriptionGrantOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'createdAt', 'updatedAt', 'subscriptionTargetId', 'grantedEntity', 'status', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionGrantId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'subscriptionTargetId' => [ 'shape' => 'SubscriptionTargetId', ], 'grantedEntity' => [ 'shape' => 'GrantedEntity', ], 'status' => [ 'shape' => 'SubscriptionGrantOverallStatus', ], 'assets' => [ 'shape' => 'SubscribedAssets', ], 'subscriptionId' => [ 'shape' => 'SubscriptionId', 'deprecated' => true, 'deprecatedMessage' => 'Multiple subscriptions can exist for a single grant', ], ], ], 'GetSubscriptionInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'SubscriptionId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetSubscriptionOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'status', 'createdAt', 'updatedAt', 'subscribedPrincipal', 'subscribedListing', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'status' => [ 'shape' => 'SubscriptionStatus', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'subscribedPrincipal' => [ 'shape' => 'SubscribedPrincipal', ], 'subscribedListing' => [ 'shape' => 'SubscribedListing', ], 'subscriptionRequestId' => [ 'shape' => 'SubscriptionRequestId', ], 'retainPermissions' => [ 'shape' => 'Boolean', ], ], ], 'GetSubscriptionRequestDetailsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'SubscriptionRequestId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetSubscriptionRequestDetailsOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'status', 'createdAt', 'updatedAt', 'requestReason', 'subscribedPrincipals', 'subscribedListings', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionRequestId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'status' => [ 'shape' => 'SubscriptionRequestStatus', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'requestReason' => [ 'shape' => 'RequestReason', ], 'subscribedPrincipals' => [ 'shape' => 'GetSubscriptionRequestDetailsOutputSubscribedPrincipalsList', ], 'subscribedListings' => [ 'shape' => 'GetSubscriptionRequestDetailsOutputSubscribedListingsList', ], 'reviewerId' => [ 'shape' => 'String', ], 'decisionComment' => [ 'shape' => 'DecisionComment', ], 'existingSubscriptionId' => [ 'shape' => 'SubscriptionId', ], 'metadataForms' => [ 'shape' => 'MetadataForms', ], ], ], 'GetSubscriptionRequestDetailsOutputSubscribedListingsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedListing', ], 'max' => 1, 'min' => 1, ], 'GetSubscriptionRequestDetailsOutputSubscribedPrincipalsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedPrincipal', ], 'max' => 1, 'min' => 1, ], 'GetSubscriptionTargetInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'environmentIdentifier', ], 'identifier' => [ 'shape' => 'SubscriptionTargetId', 'location' => 'uri', 'locationName' => 'identifier', ], ], ], 'GetSubscriptionTargetOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'authorizedPrincipals', 'domainId', 'projectId', 'environmentId', 'name', 'type', 'createdBy', 'createdAt', 'applicableAssetTypes', 'subscriptionTargetConfig', 'provider', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionTargetId', ], 'authorizedPrincipals' => [ 'shape' => 'AuthorizedPrincipalIdentifiers', ], 'domainId' => [ 'shape' => 'DomainId', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'name' => [ 'shape' => 'SubscriptionTargetName', ], 'type' => [ 'shape' => 'String', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'manageAccessRole' => [ 'shape' => 'IamRoleArn', ], 'applicableAssetTypes' => [ 'shape' => 'ApplicableAssetTypes', ], 'subscriptionTargetConfig' => [ 'shape' => 'SubscriptionTargetForms', ], 'provider' => [ 'shape' => 'String', ], 'subscriptionGrantCreationMode' => [ 'shape' => 'SubscriptionGrantCreationMode', ], ], ], 'GetTimeSeriesDataPointInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityIdentifier', 'entityType', 'identifier', 'formName', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityIdentifier' => [ 'shape' => 'EntityIdentifier', 'location' => 'uri', 'locationName' => 'entityIdentifier', ], 'entityType' => [ 'shape' => 'TimeSeriesEntityType', 'location' => 'uri', 'locationName' => 'entityType', ], 'identifier' => [ 'shape' => 'TimeSeriesDataPointIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], 'formName' => [ 'shape' => 'TimeSeriesFormName', 'location' => 'querystring', 'locationName' => 'formName', ], ], ], 'GetTimeSeriesDataPointOutput' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'entityId' => [ 'shape' => 'EntityId', ], 'entityType' => [ 'shape' => 'TimeSeriesEntityType', ], 'formName' => [ 'shape' => 'TimeSeriesFormName', ], 'form' => [ 'shape' => 'TimeSeriesDataPointFormOutput', ], ], ], 'GetUserProfileInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'userIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'userIdentifier' => [ 'shape' => 'UserIdentifier', 'location' => 'uri', 'locationName' => 'userIdentifier', ], 'type' => [ 'shape' => 'UserProfileType', 'location' => 'querystring', 'locationName' => 'type', ], ], ], 'GetUserProfileOutput' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'UserProfileId', ], 'type' => [ 'shape' => 'UserProfileType', ], 'status' => [ 'shape' => 'UserProfileStatus', ], 'details' => [ 'shape' => 'UserProfileDetails', ], ], ], 'GlobalParameterMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'GlossaryDescription' => [ 'type' => 'string', 'max' => 4096, 'min' => 0, 'sensitive' => true, ], 'GlossaryId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'GlossaryItem' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'name', 'owningProjectId', 'status', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'GlossaryId', ], 'name' => [ 'shape' => 'GlossaryName', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'description' => [ 'shape' => 'GlossaryDescription', ], 'status' => [ 'shape' => 'GlossaryStatus', ], 'usageRestrictions' => [ 'shape' => 'GlossaryUsageRestrictions', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'additionalAttributes' => [ 'shape' => 'GlossaryItemAdditionalAttributes', ], ], ], 'GlossaryItemAdditionalAttributes' => [ 'type' => 'structure', 'members' => [ 'matchRationale' => [ 'shape' => 'MatchRationale', ], ], ], 'GlossaryName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'sensitive' => true, ], 'GlossaryStatus' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', ], ], 'GlossaryTermEnforcementDetail' => [ 'type' => 'structure', 'members' => [ 'requiredGlossaryTermIds' => [ 'shape' => 'GlossaryTermIdentifiers', ], ], ], 'GlossaryTermId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'GlossaryTermIdentifiers' => [ 'type' => 'list', 'member' => [ 'shape' => 'GlossaryTermId', ], 'max' => 5, 'min' => 1, ], 'GlossaryTermItem' => [ 'type' => 'structure', 'required' => [ 'domainId', 'glossaryId', 'id', 'name', 'status', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'glossaryId' => [ 'shape' => 'GlossaryId', ], 'id' => [ 'shape' => 'GlossaryTermId', ], 'name' => [ 'shape' => 'GlossaryTermName', ], 'shortDescription' => [ 'shape' => 'ShortDescription', ], 'usageRestrictions' => [ 'shape' => 'GlossaryUsageRestrictions', ], 'longDescription' => [ 'shape' => 'LongDescription', ], 'termRelations' => [ 'shape' => 'TermRelations', ], 'status' => [ 'shape' => 'GlossaryTermStatus', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'additionalAttributes' => [ 'shape' => 'GlossaryTermItemAdditionalAttributes', ], ], ], 'GlossaryTermItemAdditionalAttributes' => [ 'type' => 'structure', 'members' => [ 'matchRationale' => [ 'shape' => 'MatchRationale', ], ], ], 'GlossaryTermName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'sensitive' => true, ], 'GlossaryTermStatus' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'GlossaryTerms' => [ 'type' => 'list', 'member' => [ 'shape' => 'GlossaryTermId', ], 'max' => 20, 'min' => 1, ], 'GlossaryUsageRestriction' => [ 'type' => 'string', 'enum' => [ 'ASSET_GOVERNED_TERMS', ], ], 'GlossaryUsageRestrictions' => [ 'type' => 'list', 'member' => [ 'shape' => 'GlossaryUsageRestriction', ], 'max' => 1, 'min' => 1, ], 'GlueConnection' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'GlueConnectionDescriptionString', ], 'connectionType' => [ 'shape' => 'ConnectionType', ], 'matchCriteria' => [ 'shape' => 'MatchCriteria', ], 'connectionProperties' => [ 'shape' => 'ConnectionProperties', ], 'sparkProperties' => [ 'shape' => 'PropertyMap', ], 'athenaProperties' => [ 'shape' => 'PropertyMap', ], 'pythonProperties' => [ 'shape' => 'PropertyMap', ], 'physicalConnectionRequirements' => [ 'shape' => 'PhysicalConnectionRequirements', ], 'creationTime' => [ 'shape' => 'Timestamp', ], 'lastUpdatedTime' => [ 'shape' => 'Timestamp', ], 'lastUpdatedBy' => [ 'shape' => 'String', ], 'status' => [ 'shape' => 'ConnectionStatus', ], 'statusReason' => [ 'shape' => 'GlueConnectionStatusReasonString', ], 'lastConnectionValidationTime' => [ 'shape' => 'Timestamp', ], 'authenticationConfiguration' => [ 'shape' => 'AuthenticationConfiguration', ], 'connectionSchemaVersion' => [ 'shape' => 'GlueConnectionConnectionSchemaVersionInteger', ], 'compatibleComputeEnvironments' => [ 'shape' => 'ComputeEnvironmentsList', ], ], ], 'GlueConnectionConnectionSchemaVersionInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 2, 'min' => 1, ], 'GlueConnectionDescriptionString' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, ], 'GlueConnectionInput' => [ 'type' => 'structure', 'members' => [ 'connectionProperties' => [ 'shape' => 'ConnectionProperties', ], 'physicalConnectionRequirements' => [ 'shape' => 'PhysicalConnectionRequirements', ], 'name' => [ 'shape' => 'GlueConnectionInputNameString', ], 'description' => [ 'shape' => 'String', ], 'connectionType' => [ 'shape' => 'GlueConnectionType', ], 'matchCriteria' => [ 'shape' => 'GlueConnectionInputMatchCriteriaString', ], 'validateCredentials' => [ 'shape' => 'Boolean', ], 'validateForComputeEnvironments' => [ 'shape' => 'ComputeEnvironmentsList', ], 'sparkProperties' => [ 'shape' => 'PropertyMap', ], 'athenaProperties' => [ 'shape' => 'PropertyMap', ], 'pythonProperties' => [ 'shape' => 'PropertyMap', ], 'authenticationConfiguration' => [ 'shape' => 'AuthenticationConfigurationInput', ], ], ], 'GlueConnectionInputMatchCriteriaString' => [ 'type' => 'string', 'max' => 10, 'min' => 0, ], 'GlueConnectionInputNameString' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'GlueConnectionPatch' => [ 'type' => 'structure', 'members' => [ 'description' => [ 'shape' => 'String', ], 'connectionProperties' => [ 'shape' => 'ConnectionProperties', ], 'authenticationConfiguration' => [ 'shape' => 'AuthenticationConfigurationPatch', ], ], ], 'GlueConnectionStatusReasonString' => [ 'type' => 'string', 'max' => 16384, 'min' => 1, ], 'GlueConnectionType' => [ 'type' => 'string', 'enum' => [ 'SNOWFLAKE', 'BIGQUERY', 'DOCUMENTDB', 'DYNAMODB', 'MYSQL', 'OPENSEARCH', 'ORACLE', 'POSTGRESQL', 'REDSHIFT', 'SAPHANA', 'SQLSERVER', 'TERADATA', 'VERTICA', ], ], 'GlueOAuth2Credentials' => [ 'type' => 'structure', 'members' => [ 'userManagedClientApplicationClientSecret' => [ 'shape' => 'GlueOAuth2CredentialsUserManagedClientApplicationClientSecretString', ], 'accessToken' => [ 'shape' => 'GlueOAuth2CredentialsAccessTokenString', ], 'refreshToken' => [ 'shape' => 'GlueOAuth2CredentialsRefreshTokenString', ], 'jwtToken' => [ 'shape' => 'GlueOAuth2CredentialsJwtTokenString', ], ], 'sensitive' => true, ], 'GlueOAuth2CredentialsAccessTokenString' => [ 'type' => 'string', 'max' => 4096, 'min' => 0, 'pattern' => '[\\x20-\\x7E]*', ], 'GlueOAuth2CredentialsJwtTokenString' => [ 'type' => 'string', 'max' => 8000, 'min' => 0, 'pattern' => '([a-zA-Z0-9_=]+)\\.([a-zA-Z0-9_=]+)\\.([a-zA-Z0-9_\\-\\+\\/=]*)', ], 'GlueOAuth2CredentialsRefreshTokenString' => [ 'type' => 'string', 'max' => 4096, 'min' => 0, 'pattern' => '[\\x20-\\x7E]*', ], 'GlueOAuth2CredentialsUserManagedClientApplicationClientSecretString' => [ 'type' => 'string', 'max' => 512, 'min' => 0, 'pattern' => '[\\x20-\\x7E]*', ], 'GluePropertiesInput' => [ 'type' => 'structure', 'members' => [ 'glueConnectionInput' => [ 'shape' => 'GlueConnectionInput', ], ], ], 'GluePropertiesOutput' => [ 'type' => 'structure', 'members' => [ 'status' => [ 'shape' => 'ConnectionStatus', ], 'errorMessage' => [ 'shape' => 'String', ], ], ], 'GluePropertiesPatch' => [ 'type' => 'structure', 'members' => [ 'glueConnectionInput' => [ 'shape' => 'GlueConnectionPatch', ], ], ], 'GlueRunConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'relationalFilterConfigurations', ], 'members' => [ 'dataAccessRole' => [ 'shape' => 'GlueRunConfigurationInputDataAccessRoleString', ], 'relationalFilterConfigurations' => [ 'shape' => 'RelationalFilterConfigurations', ], 'autoImportDataQualityResult' => [ 'shape' => 'Boolean', ], 'catalogName' => [ 'shape' => 'GlueRunConfigurationInputCatalogNameString', ], ], ], 'GlueRunConfigurationInputCatalogNameString' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'GlueRunConfigurationInputDataAccessRoleString' => [ 'type' => 'string', 'pattern' => 'arn:aws[^:]*:iam::\\d{12}:(role|role/service-role)/[\\w+=,.@-]{1,128}', ], 'GlueRunConfigurationOutput' => [ 'type' => 'structure', 'required' => [ 'relationalFilterConfigurations', ], 'members' => [ 'accountId' => [ 'shape' => 'GlueRunConfigurationOutputAccountIdString', ], 'region' => [ 'shape' => 'GlueRunConfigurationOutputRegionString', ], 'dataAccessRole' => [ 'shape' => 'GlueRunConfigurationOutputDataAccessRoleString', ], 'relationalFilterConfigurations' => [ 'shape' => 'RelationalFilterConfigurations', ], 'autoImportDataQualityResult' => [ 'shape' => 'Boolean', ], 'catalogName' => [ 'shape' => 'GlueRunConfigurationOutputCatalogNameString', ], ], ], 'GlueRunConfigurationOutputAccountIdString' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '\\d{12}', ], 'GlueRunConfigurationOutputCatalogNameString' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'GlueRunConfigurationOutputDataAccessRoleString' => [ 'type' => 'string', 'pattern' => 'arn:aws[^:]*:iam::\\d{12}:(role|role/service-role)/[\\w+=,.@-]{1,128}', ], 'GlueRunConfigurationOutputRegionString' => [ 'type' => 'string', 'max' => 16, 'min' => 4, 'pattern' => '.*[a-z]{2}-?(iso|gov)?-{1}[a-z]*-{1}[0-9].*', ], 'GlueSelfGrantStatusOutput' => [ 'type' => 'structure', 'required' => [ 'selfGrantStatusDetails', ], 'members' => [ 'selfGrantStatusDetails' => [ 'shape' => 'SelfGrantStatusDetails', ], ], ], 'GovernanceType' => [ 'type' => 'string', 'enum' => [ 'AWS_MANAGED', 'USER_MANAGED', ], ], 'GovernedEntityType' => [ 'type' => 'string', 'enum' => [ 'ASSET', ], ], 'GrantIdentifier' => [ 'type' => 'string', 'pattern' => '[A-Za-z0-9+/]{10}', ], 'GrantedEntity' => [ 'type' => 'structure', 'members' => [ 'listing' => [ 'shape' => 'ListingRevision', ], ], 'union' => true, ], 'GrantedEntityInput' => [ 'type' => 'structure', 'members' => [ 'listing' => [ 'shape' => 'ListingRevisionInput', ], ], 'union' => true, ], 'GreaterThanExpression' => [ 'type' => 'structure', 'required' => [ 'columnName', 'value', ], 'members' => [ 'columnName' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'GreaterThanOrEqualToExpression' => [ 'type' => 'structure', 'required' => [ 'columnName', 'value', ], 'members' => [ 'columnName' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'GroupDetails' => [ 'type' => 'structure', 'required' => [ 'groupId', ], 'members' => [ 'groupId' => [ 'shape' => 'String', ], ], ], 'GroupIdentifier' => [ 'type' => 'string', 'pattern' => '.*(^([0-9a-f]{10}-|)[A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12}$|[\\p{L}\\p{M}\\p{S}\\p{N}\\p{P}\\t\\n\\r ]+).*', ], 'GroupPolicyGrantPrincipal' => [ 'type' => 'structure', 'members' => [ 'groupIdentifier' => [ 'shape' => 'GroupIdentifier', ], ], 'union' => true, ], 'GroupProfileId' => [ 'type' => 'string', 'pattern' => '([0-9a-f]{10}-|)[A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12}', ], 'GroupProfileName' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '[a-zA-Z_0-9+=,.@-]+', 'sensitive' => true, ], 'GroupProfileStatus' => [ 'type' => 'string', 'enum' => [ 'ASSIGNED', 'NOT_ASSIGNED', ], ], 'GroupProfileSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'GroupProfileSummary', ], ], 'GroupProfileSummary' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'GroupProfileId', ], 'status' => [ 'shape' => 'GroupProfileStatus', ], 'groupName' => [ 'shape' => 'GroupProfileName', ], ], ], 'GroupSearchText' => [ 'type' => 'string', 'max' => 1024, 'min' => 0, 'sensitive' => true, ], 'GroupSearchType' => [ 'type' => 'string', 'enum' => [ 'SSO_GROUP', 'DATAZONE_SSO_GROUP', ], ], 'HyperPodOrchestrator' => [ 'type' => 'string', 'enum' => [ 'EKS', 'SLURM', ], ], 'HyperPodPropertiesInput' => [ 'type' => 'structure', 'required' => [ 'clusterName', ], 'members' => [ 'clusterName' => [ 'shape' => 'HyperPodPropertiesInputClusterNameString', ], ], ], 'HyperPodPropertiesInputClusterNameString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'HyperPodPropertiesOutput' => [ 'type' => 'structure', 'required' => [ 'clusterName', ], 'members' => [ 'clusterName' => [ 'shape' => 'String', ], 'clusterArn' => [ 'shape' => 'String', ], 'orchestrator' => [ 'shape' => 'HyperPodOrchestrator', ], ], ], 'IamPrincipalArn' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => 'arn:aws[^:]*:iam::\\d{12}:(role|user)(/[\\w+=,.@-]*)*/[\\w+=,.@-]+', ], 'IamPropertiesInput' => [ 'type' => 'structure', 'members' => [ 'glueLineageSyncEnabled' => [ 'shape' => 'Boolean', ], ], ], 'IamPropertiesOutput' => [ 'type' => 'structure', 'members' => [ 'environmentId' => [ 'shape' => 'String', ], 'glueLineageSyncEnabled' => [ 'shape' => 'Boolean', ], ], ], 'IamPropertiesPatch' => [ 'type' => 'structure', 'members' => [ 'glueLineageSyncEnabled' => [ 'shape' => 'Boolean', ], ], ], 'IamRoleArn' => [ 'type' => 'string', 'pattern' => 'arn:aws(|-cn|-us-gov):iam::\\d{12}:(role|role/service-role)/[\\w+=,.@-]*', ], 'IamUserProfileDetails' => [ 'type' => 'structure', 'members' => [ 'arn' => [ 'shape' => 'String', ], 'principalId' => [ 'shape' => 'String', ], ], ], 'Import' => [ 'type' => 'structure', 'required' => [ 'name', 'revision', ], 'members' => [ 'name' => [ 'shape' => 'FormTypeName', ], 'revision' => [ 'shape' => 'Revision', ], ], ], 'ImportList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Import', ], 'max' => 10, 'min' => 1, ], 'InExpression' => [ 'type' => 'structure', 'required' => [ 'columnName', 'values', ], 'members' => [ 'columnName' => [ 'shape' => 'String', ], 'values' => [ 'shape' => 'StringList', ], ], ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'InternalServerException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, 'retryable' => [ 'throttling' => false, ], ], 'InventorySearchScope' => [ 'type' => 'string', 'enum' => [ 'ASSET', 'GLOSSARY', 'GLOSSARY_TERM', 'DATA_PRODUCT', ], ], 'IsNotNullExpression' => [ 'type' => 'structure', 'required' => [ 'columnName', ], 'members' => [ 'columnName' => [ 'shape' => 'String', ], ], ], 'IsNullExpression' => [ 'type' => 'structure', 'required' => [ 'columnName', ], 'members' => [ 'columnName' => [ 'shape' => 'String', ], ], ], 'ItemGlossaryTerms' => [ 'type' => 'list', 'member' => [ 'shape' => 'GlossaryTermId', ], 'max' => 2, 'min' => 1, ], 'JobRunDetails' => [ 'type' => 'structure', 'members' => [ 'lineageRunDetails' => [ 'shape' => 'LineageRunDetails', ], ], 'union' => true, ], 'JobRunError' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], ], 'JobRunMode' => [ 'type' => 'string', 'enum' => [ 'SCHEDULED', 'ON_DEMAND', ], ], 'JobRunStatus' => [ 'type' => 'string', 'enum' => [ 'SCHEDULED', 'IN_PROGRESS', 'SUCCESS', 'PARTIALLY_SUCCEEDED', 'FAILED', 'ABORTED', 'TIMED_OUT', 'CANCELED', ], ], 'JobRunSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'JobRunSummary', ], ], 'JobRunSummary' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'jobId' => [ 'shape' => 'String', ], 'jobType' => [ 'shape' => 'JobType', ], 'runId' => [ 'shape' => 'String', ], 'runMode' => [ 'shape' => 'JobRunMode', ], 'status' => [ 'shape' => 'JobRunStatus', ], 'error' => [ 'shape' => 'JobRunError', ], 'createdBy' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'startTime' => [ 'shape' => 'Timestamp', ], 'endTime' => [ 'shape' => 'Timestamp', ], ], ], 'JobType' => [ 'type' => 'string', 'enum' => [ 'LINEAGE', ], ], 'KmsKeyArn' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => 'arn:aws(|-cn|-us-gov):kms:[a-zA-Z0-9-]*:[0-9]{12}:key/[a-zA-Z0-9-]{36}', ], 'LakeFormationConfiguration' => [ 'type' => 'structure', 'members' => [ 'locationRegistrationRole' => [ 'shape' => 'RoleArn', ], 'locationRegistrationExcludeS3Locations' => [ 'shape' => 'S3LocationList', ], ], ], 'LambdaExecutionRoleArn' => [ 'type' => 'string', 'pattern' => 'arn:aws[^:]*:iam::\\d{12}:(role|role/service-role)/[\\w+=,.@-]*', ], 'LambdaFunctionArn' => [ 'type' => 'string', 'pattern' => 'arn:(?:aws|aws-cn|aws-us-gov):lambda:(?:[a-z]{2}(?:-gov)?-[a-z]+-\\d{1,}):(\\d{12}):function:[a-zA-Z0-9-_]+(?::[a-zA-Z0-9-_]+)?(?:\\$[\\w-]+)?', ], 'LastName' => [ 'type' => 'string', 'sensitive' => true, ], 'LessThanExpression' => [ 'type' => 'structure', 'required' => [ 'columnName', 'value', ], 'members' => [ 'columnName' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'LessThanOrEqualToExpression' => [ 'type' => 'structure', 'required' => [ 'columnName', 'value', ], 'members' => [ 'columnName' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'LikeExpression' => [ 'type' => 'structure', 'required' => [ 'columnName', 'value', ], 'members' => [ 'columnName' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'LineageEvent' => [ 'type' => 'blob', 'max' => 300000, 'min' => 0, 'sensitive' => true, ], 'LineageEventErrorMessage' => [ 'type' => 'string', ], 'LineageEventIdentifier' => [ 'type' => 'string', 'pattern' => '[a-z0-9]{14}', ], 'LineageEventProcessingStatus' => [ 'type' => 'string', 'enum' => [ 'REQUESTED', 'PROCESSING', 'SUCCESS', 'FAILED', ], ], 'LineageEventSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'LineageEventSummary', ], ], 'LineageEventSummary' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'LineageEventIdentifier', ], 'domainId' => [ 'shape' => 'DomainId', ], 'processingStatus' => [ 'shape' => 'LineageEventProcessingStatus', ], 'eventTime' => [ 'shape' => 'Timestamp', ], 'eventSummary' => [ 'shape' => 'EventSummary', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], ], ], 'LineageImportStatus' => [ 'type' => 'string', 'enum' => [ 'IN_PROGRESS', 'SUCCESS', 'FAILED', 'PARTIALLY_SUCCEEDED', ], ], 'LineageInfo' => [ 'type' => 'structure', 'members' => [ 'eventId' => [ 'shape' => 'String', ], 'eventStatus' => [ 'shape' => 'LineageEventProcessingStatus', ], 'errorMessage' => [ 'shape' => 'LineageEventErrorMessage', ], ], ], 'LineageNodeId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'LineageNodeIdentifier' => [ 'type' => 'string', 'max' => 2086, 'min' => 1, ], 'LineageNodeReference' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'LineageNodeId', ], 'eventTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'LineageNodeReferenceList' => [ 'type' => 'list', 'member' => [ 'shape' => 'LineageNodeReference', ], 'max' => 100, 'min' => 0, ], 'LineageNodeSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'LineageNodeSummary', ], ], 'LineageNodeSummary' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'typeName', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'id' => [ 'shape' => 'LineageNodeId', ], 'typeName' => [ 'shape' => 'String', ], 'typeRevision' => [ 'shape' => 'Revision', ], 'sourceIdentifier' => [ 'shape' => 'String', ], 'eventTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'LineageNodeTypeItem' => [ 'type' => 'structure', 'required' => [ 'domainId', 'revision', 'formsOutput', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'revision' => [ 'shape' => 'Revision', ], 'formsOutput' => [ 'shape' => 'FormsOutputMap', ], ], ], 'LineageRunDetails' => [ 'type' => 'structure', 'members' => [ 'sqlQueryRunDetails' => [ 'shape' => 'LineageSqlQueryRunDetails', ], ], ], 'LineageSqlQueryRunDetails' => [ 'type' => 'structure', 'members' => [ 'queryStartTime' => [ 'shape' => 'Timestamp', ], 'queryEndTime' => [ 'shape' => 'Timestamp', ], 'totalQueriesProcessed' => [ 'shape' => 'Integer', ], 'numQueriesFailed' => [ 'shape' => 'Integer', ], 'errorMessages' => [ 'shape' => 'FailedQueryProcessingErrorMessages', ], ], ], 'LineageSyncSchedule' => [ 'type' => 'structure', 'members' => [ 'schedule' => [ 'shape' => 'LineageSyncScheduleScheduleString', ], ], ], 'LineageSyncScheduleScheduleString' => [ 'type' => 'string', 'pattern' => 'cron\\((\\b[0-5]?[0-9]\\b) (\\b2[0-3]\\b|\\b[0-1]?[0-9]\\b) ([-?*,/\\dLW]){1,83} ([-*,/\\d]|[a-zA-Z]{3}){1,23} ([-?#*,/\\dL]|[a-zA-Z]{3}){1,13} ([^\\)]+)\\)', ], 'ListAccountPoolsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'name' => [ 'shape' => 'AccountPoolName', 'location' => 'querystring', 'locationName' => 'name', ], 'sortBy' => [ 'shape' => 'SortFieldAccountPool', 'location' => 'querystring', 'locationName' => 'sortBy', ], 'sortOrder' => [ 'shape' => 'SortOrder', 'location' => 'querystring', 'locationName' => 'sortOrder', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListAccountPoolsOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'AccountPoolSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListAccountsInAccountPoolInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'AccountPoolId', 'location' => 'uri', 'locationName' => 'identifier', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListAccountsInAccountPoolOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'AccountInfoList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListAssetFiltersInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'assetIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'assetIdentifier' => [ 'shape' => 'AssetId', 'location' => 'uri', 'locationName' => 'assetIdentifier', ], 'status' => [ 'shape' => 'FilterStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListAssetFiltersOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'AssetFilters', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListAssetRevisionsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'AssetIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListAssetRevisionsOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'AssetRevisions', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListConnectionsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'sortBy' => [ 'shape' => 'SortFieldConnection', 'location' => 'querystring', 'locationName' => 'sortBy', ], 'sortOrder' => [ 'shape' => 'SortOrder', 'location' => 'querystring', 'locationName' => 'sortOrder', ], 'name' => [ 'shape' => 'ConnectionName', 'location' => 'querystring', 'locationName' => 'name', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', 'location' => 'querystring', 'locationName' => 'environmentIdentifier', ], 'projectIdentifier' => [ 'shape' => 'ProjectId', 'location' => 'querystring', 'locationName' => 'projectIdentifier', ], 'type' => [ 'shape' => 'ConnectionType', 'location' => 'querystring', 'locationName' => 'type', ], 'scope' => [ 'shape' => 'ConnectionScope', 'location' => 'querystring', 'locationName' => 'scope', ], ], ], 'ListConnectionsOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'ConnectionSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListDataProductRevisionsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'DataProductId', 'location' => 'uri', 'locationName' => 'identifier', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListDataProductRevisionsOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'DataProductRevisions', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListDataSourceRunActivitiesInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'DataSourceRunId', 'location' => 'uri', 'locationName' => 'identifier', ], 'status' => [ 'shape' => 'DataAssetActivityStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListDataSourceRunActivitiesOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'DataSourceRunActivities', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListDataSourceRunsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'dataSourceIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'dataSourceIdentifier' => [ 'shape' => 'DataSourceId', 'location' => 'uri', 'locationName' => 'dataSourceIdentifier', ], 'status' => [ 'shape' => 'DataSourceRunStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListDataSourceRunsOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'DataSourceRunSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListDataSourcesInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'projectIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'projectIdentifier' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'projectIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'environmentIdentifier', ], 'connectionIdentifier' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'connectionIdentifier', ], 'type' => [ 'shape' => 'DataSourceType', 'location' => 'querystring', 'locationName' => 'type', ], 'status' => [ 'shape' => 'DataSourceStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'name' => [ 'shape' => 'Name', 'location' => 'querystring', 'locationName' => 'name', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListDataSourcesOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'DataSourceSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListDomainUnitsForParentInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'parentDomainUnitIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'parentDomainUnitIdentifier' => [ 'shape' => 'DomainUnitId', 'location' => 'querystring', 'locationName' => 'parentDomainUnitIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResultsForListDomains', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListDomainUnitsForParentOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'DomainUnitSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListDomainsInput' => [ 'type' => 'structure', 'members' => [ 'status' => [ 'shape' => 'DomainStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'maxResults' => [ 'shape' => 'MaxResultsForListDomains', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListDomainsOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'DomainSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListEntityOwnersInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityType', 'entityIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityType' => [ 'shape' => 'DataZoneEntityType', 'location' => 'uri', 'locationName' => 'entityType', ], 'entityIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'entityIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResultsForListDomains', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListEntityOwnersOutput' => [ 'type' => 'structure', 'required' => [ 'owners', ], 'members' => [ 'owners' => [ 'shape' => 'EntityOwners', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListEnvironmentActionSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'EnvironmentActionSummary', ], ], 'ListEnvironmentActionsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'environmentIdentifier', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListEnvironmentActionsOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'ListEnvironmentActionSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListEnvironmentBlueprintConfigurationsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListEnvironmentBlueprintConfigurationsOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'EnvironmentBlueprintConfigurations', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListEnvironmentBlueprintsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'name' => [ 'shape' => 'EnvironmentBlueprintName', 'location' => 'querystring', 'locationName' => 'name', ], 'managed' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'managed', ], ], ], 'ListEnvironmentBlueprintsOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'EnvironmentBlueprintSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListEnvironmentProfilesInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'awsAccountId' => [ 'shape' => 'AwsAccountId', 'location' => 'querystring', 'locationName' => 'awsAccountId', ], 'awsAccountRegion' => [ 'shape' => 'AwsRegion', 'location' => 'querystring', 'locationName' => 'awsAccountRegion', ], 'environmentBlueprintIdentifier' => [ 'shape' => 'EnvironmentBlueprintId', 'location' => 'querystring', 'locationName' => 'environmentBlueprintIdentifier', ], 'projectIdentifier' => [ 'shape' => 'ProjectId', 'location' => 'querystring', 'locationName' => 'projectIdentifier', ], 'name' => [ 'shape' => 'EnvironmentProfileName', 'location' => 'querystring', 'locationName' => 'name', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListEnvironmentProfilesOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'EnvironmentProfileSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListEnvironmentsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'projectIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'awsAccountId' => [ 'shape' => 'AwsAccountId', 'location' => 'querystring', 'locationName' => 'awsAccountId', ], 'status' => [ 'shape' => 'EnvironmentStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'awsAccountRegion' => [ 'shape' => 'AwsRegion', 'location' => 'querystring', 'locationName' => 'awsAccountRegion', ], 'projectIdentifier' => [ 'shape' => 'ProjectId', 'location' => 'querystring', 'locationName' => 'projectIdentifier', ], 'environmentProfileIdentifier' => [ 'shape' => 'EnvironmentProfileId', 'location' => 'querystring', 'locationName' => 'environmentProfileIdentifier', ], 'environmentBlueprintIdentifier' => [ 'shape' => 'EnvironmentBlueprintId', 'location' => 'querystring', 'locationName' => 'environmentBlueprintIdentifier', ], 'provider' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'provider', ], 'name' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'name', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListEnvironmentsOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'EnvironmentSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListJobRunsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'jobIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'jobIdentifier' => [ 'shape' => 'ListJobRunsInputJobIdentifierString', 'location' => 'uri', 'locationName' => 'jobIdentifier', ], 'status' => [ 'shape' => 'JobRunStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'sortOrder' => [ 'shape' => 'SortOrder', 'location' => 'querystring', 'locationName' => 'sortOrder', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListJobRunsInputJobIdentifierString' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'ListJobRunsOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'JobRunSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListLineageEventsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'timestampAfter' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'timestampAfter', ], 'timestampBefore' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'timestampBefore', ], 'processingStatus' => [ 'shape' => 'LineageEventProcessingStatus', 'location' => 'querystring', 'locationName' => 'processingStatus', ], 'sortOrder' => [ 'shape' => 'SortOrder', 'location' => 'querystring', 'locationName' => 'sortOrder', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListLineageEventsOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'LineageEventSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListLineageNodeHistoryInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'identifier' => [ 'shape' => 'LineageNodeIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], 'direction' => [ 'shape' => 'EdgeDirection', 'location' => 'querystring', 'locationName' => 'direction', ], 'eventTimestampGTE' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'timestampGTE', ], 'eventTimestampLTE' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'timestampLTE', ], 'sortOrder' => [ 'shape' => 'SortOrder', 'location' => 'querystring', 'locationName' => 'sortOrder', ], ], ], 'ListLineageNodeHistoryOutput' => [ 'type' => 'structure', 'members' => [ 'nodes' => [ 'shape' => 'LineageNodeSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListMetadataGenerationRunsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'status' => [ 'shape' => 'MetadataGenerationRunStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'type' => [ 'shape' => 'MetadataGenerationRunType', 'location' => 'querystring', 'locationName' => 'type', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'targetIdentifier' => [ 'shape' => 'EntityId', 'location' => 'querystring', 'locationName' => 'targetIdentifier', ], ], ], 'ListMetadataGenerationRunsOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'MetadataGenerationRuns', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListNotificationsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'type', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'type' => [ 'shape' => 'NotificationType', 'location' => 'querystring', 'locationName' => 'type', ], 'afterTimestamp' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'afterTimestamp', ], 'beforeTimestamp' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'beforeTimestamp', ], 'subjects' => [ 'shape' => 'NotificationSubjects', 'location' => 'querystring', 'locationName' => 'subjects', ], 'taskStatus' => [ 'shape' => 'TaskStatus', 'location' => 'querystring', 'locationName' => 'taskStatus', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListNotificationsOutput' => [ 'type' => 'structure', 'members' => [ 'notifications' => [ 'shape' => 'NotificationsList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListPolicyGrantsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityType', 'entityIdentifier', 'policyType', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityType' => [ 'shape' => 'TargetEntityType', 'location' => 'uri', 'locationName' => 'entityType', ], 'entityIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'entityIdentifier', ], 'policyType' => [ 'shape' => 'ManagedPolicyType', 'location' => 'querystring', 'locationName' => 'policyType', ], 'maxResults' => [ 'shape' => 'MaxResultsForListDomains', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListPolicyGrantsOutput' => [ 'type' => 'structure', 'required' => [ 'grantList', ], 'members' => [ 'grantList' => [ 'shape' => 'PolicyGrantList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListProjectMembershipsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'projectIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'projectIdentifier' => [ 'shape' => 'ProjectId', 'location' => 'uri', 'locationName' => 'projectIdentifier', ], 'sortBy' => [ 'shape' => 'SortFieldProject', 'location' => 'querystring', 'locationName' => 'sortBy', ], 'sortOrder' => [ 'shape' => 'SortOrder', 'location' => 'querystring', 'locationName' => 'sortOrder', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListProjectMembershipsOutput' => [ 'type' => 'structure', 'required' => [ 'members', ], 'members' => [ 'members' => [ 'shape' => 'ProjectMembers', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListProjectProfilesInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'name' => [ 'shape' => 'ProjectProfileName', 'location' => 'querystring', 'locationName' => 'name', ], 'sortBy' => [ 'shape' => 'SortFieldProject', 'location' => 'querystring', 'locationName' => 'sortBy', ], 'sortOrder' => [ 'shape' => 'SortOrder', 'location' => 'querystring', 'locationName' => 'sortOrder', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListProjectProfilesOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'ProjectProfileSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListProjectsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'userIdentifier' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'userIdentifier', ], 'groupIdentifier' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'groupIdentifier', ], 'name' => [ 'shape' => 'ProjectName', 'location' => 'querystring', 'locationName' => 'name', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListProjectsOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'ProjectSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListRulesInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'targetType', 'targetIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'targetType' => [ 'shape' => 'RuleTargetType', 'location' => 'uri', 'locationName' => 'targetType', ], 'targetIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'targetIdentifier', ], 'ruleType' => [ 'shape' => 'RuleType', 'location' => 'querystring', 'locationName' => 'ruleType', ], 'action' => [ 'shape' => 'RuleAction', 'location' => 'querystring', 'locationName' => 'ruleAction', ], 'projectIds' => [ 'shape' => 'ProjectIds', 'location' => 'querystring', 'locationName' => 'projectIds', ], 'assetTypes' => [ 'shape' => 'AssetTypeIdentifiers', 'location' => 'querystring', 'locationName' => 'assetTypes', ], 'dataProduct' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'dataProduct', ], 'includeCascaded' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'includeCascaded', ], 'maxResults' => [ 'shape' => 'ListRulesInputMaxResultsInteger', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListRulesInputMaxResultsInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 50, 'min' => 25, ], 'ListRulesOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'RuleSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListSubscriptionGrantsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentId' => [ 'shape' => 'EnvironmentId', 'location' => 'querystring', 'locationName' => 'environmentId', ], 'subscriptionTargetId' => [ 'shape' => 'SubscriptionTargetId', 'location' => 'querystring', 'locationName' => 'subscriptionTargetId', ], 'subscribedListingId' => [ 'shape' => 'ListingId', 'location' => 'querystring', 'locationName' => 'subscribedListingId', ], 'subscriptionId' => [ 'shape' => 'SubscriptionId', 'location' => 'querystring', 'locationName' => 'subscriptionId', ], 'owningProjectId' => [ 'shape' => 'ProjectId', 'location' => 'querystring', 'locationName' => 'owningProjectId', ], 'owningIamPrincipalArn' => [ 'shape' => 'IamPrincipalArn', 'location' => 'querystring', 'locationName' => 'owningIamPrincipalArn', ], 'owningUserId' => [ 'shape' => 'UserProfileId', 'location' => 'querystring', 'locationName' => 'owningUserId', ], 'owningGroupId' => [ 'shape' => 'GroupProfileId', 'location' => 'querystring', 'locationName' => 'owningGroupId', ], 'sortBy' => [ 'shape' => 'SortKey', 'deprecated' => true, 'deprecatedMessage' => 'Results are always sorted by updatedAt', 'deprecatedSince' => 'Jan 31 2026', 'location' => 'querystring', 'locationName' => 'sortBy', ], 'sortOrder' => [ 'shape' => 'SortOrder', 'location' => 'querystring', 'locationName' => 'sortOrder', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListSubscriptionGrantsOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'SubscriptionGrants', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListSubscriptionRequestsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'status' => [ 'shape' => 'SubscriptionRequestStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'subscribedListingId' => [ 'shape' => 'ListingId', 'location' => 'querystring', 'locationName' => 'subscribedListingId', ], 'owningProjectId' => [ 'shape' => 'ProjectId', 'location' => 'querystring', 'locationName' => 'owningProjectId', ], 'owningIamPrincipalArn' => [ 'shape' => 'IamPrincipalArn', 'location' => 'querystring', 'locationName' => 'owningIamPrincipalArn', ], 'approverProjectId' => [ 'shape' => 'ProjectId', 'location' => 'querystring', 'locationName' => 'approverProjectId', ], 'owningUserId' => [ 'shape' => 'UserProfileId', 'location' => 'querystring', 'locationName' => 'owningUserId', ], 'owningGroupId' => [ 'shape' => 'GroupProfileId', 'location' => 'querystring', 'locationName' => 'owningGroupId', ], 'sortBy' => [ 'shape' => 'SortKey', 'deprecated' => true, 'deprecatedMessage' => 'Results are always sorted by updatedAt', 'deprecatedSince' => 'Jan 31 2026', 'location' => 'querystring', 'locationName' => 'sortBy', ], 'sortOrder' => [ 'shape' => 'SortOrder', 'location' => 'querystring', 'locationName' => 'sortOrder', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListSubscriptionRequestsOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'SubscriptionRequests', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListSubscriptionTargetsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'environmentIdentifier', ], 'sortBy' => [ 'shape' => 'SortKey', 'location' => 'querystring', 'locationName' => 'sortBy', ], 'sortOrder' => [ 'shape' => 'SortOrder', 'location' => 'querystring', 'locationName' => 'sortOrder', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListSubscriptionTargetsOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'SubscriptionTargets', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListSubscriptionsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'subscriptionRequestIdentifier' => [ 'shape' => 'SubscriptionRequestId', 'location' => 'querystring', 'locationName' => 'subscriptionRequestIdentifier', ], 'status' => [ 'shape' => 'SubscriptionStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'subscribedListingId' => [ 'shape' => 'ListingId', 'location' => 'querystring', 'locationName' => 'subscribedListingId', ], 'owningProjectId' => [ 'shape' => 'ProjectId', 'location' => 'querystring', 'locationName' => 'owningProjectId', ], 'owningIamPrincipalArn' => [ 'shape' => 'IamPrincipalArn', 'location' => 'querystring', 'locationName' => 'owningIamPrincipalArn', ], 'owningUserId' => [ 'shape' => 'UserProfileId', 'location' => 'querystring', 'locationName' => 'owningUserId', ], 'owningGroupId' => [ 'shape' => 'GroupProfileId', 'location' => 'querystring', 'locationName' => 'owningGroupId', ], 'approverProjectId' => [ 'shape' => 'ProjectId', 'location' => 'querystring', 'locationName' => 'approverProjectId', ], 'sortBy' => [ 'shape' => 'SortKey', 'deprecated' => true, 'deprecatedMessage' => 'Results are always sorted by updatedAt', 'deprecatedSince' => 'Jan 31 2026', 'location' => 'querystring', 'locationName' => 'sortBy', ], 'sortOrder' => [ 'shape' => 'SortOrder', 'location' => 'querystring', 'locationName' => 'sortOrder', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListSubscriptionsOutput' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'Subscriptions', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'Tags', ], ], ], 'ListTimeSeriesDataPointsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityIdentifier', 'entityType', 'formName', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityIdentifier' => [ 'shape' => 'EntityIdentifier', 'location' => 'uri', 'locationName' => 'entityIdentifier', ], 'entityType' => [ 'shape' => 'TimeSeriesEntityType', 'location' => 'uri', 'locationName' => 'entityType', ], 'formName' => [ 'shape' => 'TimeSeriesFormName', 'location' => 'querystring', 'locationName' => 'formName', ], 'startedAt' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'startedAt', ], 'endedAt' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'endedAt', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListTimeSeriesDataPointsOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'TimeSeriesDataPointSummaryFormOutputList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListingId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'ListingItem' => [ 'type' => 'structure', 'members' => [ 'assetListing' => [ 'shape' => 'AssetListing', ], 'dataProductListing' => [ 'shape' => 'DataProductListing', ], ], 'union' => true, ], 'ListingName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'ListingRevision' => [ 'type' => 'structure', 'required' => [ 'id', 'revision', ], 'members' => [ 'id' => [ 'shape' => 'ListingId', ], 'revision' => [ 'shape' => 'Revision', ], ], ], 'ListingRevisionInput' => [ 'type' => 'structure', 'required' => [ 'identifier', 'revision', ], 'members' => [ 'identifier' => [ 'shape' => 'ListingId', ], 'revision' => [ 'shape' => 'Revision', ], ], ], 'ListingStatus' => [ 'type' => 'string', 'enum' => [ 'CREATING', 'ACTIVE', 'INACTIVE', ], ], 'ListingSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListingSummary', ], ], 'ListingSummary' => [ 'type' => 'structure', 'members' => [ 'listingId' => [ 'shape' => 'ListingId', ], 'listingRevision' => [ 'shape' => 'Revision', ], 'glossaryTerms' => [ 'shape' => 'DetailedGlossaryTerms', ], ], ], 'ListingSummaryItem' => [ 'type' => 'structure', 'members' => [ 'listingId' => [ 'shape' => 'ListingId', ], 'listingRevision' => [ 'shape' => 'Revision', ], 'glossaryTerms' => [ 'shape' => 'DetailedGlossaryTerms', ], ], ], 'ListingSummaryItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListingSummaryItem', ], ], 'Long' => [ 'type' => 'long', 'box' => true, ], 'LongDescription' => [ 'type' => 'string', 'max' => 4096, 'min' => 0, 'sensitive' => true, ], 'ManagedEndpointCredentials' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'ManagedEndpointCredentialsIdString', ], 'token' => [ 'shape' => 'String', ], ], 'sensitive' => true, ], 'ManagedEndpointCredentialsIdString' => [ 'type' => 'string', 'max' => 64, 'min' => 0, ], 'ManagedPolicyType' => [ 'type' => 'string', 'enum' => [ 'CREATE_DOMAIN_UNIT', 'OVERRIDE_DOMAIN_UNIT_OWNERS', 'ADD_TO_PROJECT_MEMBER_POOL', 'OVERRIDE_PROJECT_OWNERS', 'CREATE_GLOSSARY', 'CREATE_FORM_TYPE', 'CREATE_ASSET_TYPE', 'CREATE_PROJECT', 'CREATE_ENVIRONMENT_PROFILE', 'DELEGATE_CREATE_ENVIRONMENT_PROFILE', 'CREATE_ENVIRONMENT', 'CREATE_ENVIRONMENT_FROM_BLUEPRINT', 'CREATE_PROJECT_FROM_PROJECT_PROFILE', 'USE_ASSET_TYPE', ], ], 'MatchCriteria' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], 'max' => 10, 'min' => 0, ], 'MatchOffset' => [ 'type' => 'structure', 'members' => [ 'startOffset' => [ 'shape' => 'Integer', ], 'endOffset' => [ 'shape' => 'Integer', ], ], ], 'MatchOffsets' => [ 'type' => 'list', 'member' => [ 'shape' => 'MatchOffset', ], ], 'MatchRationale' => [ 'type' => 'list', 'member' => [ 'shape' => 'MatchRationaleItem', ], ], 'MatchRationaleItem' => [ 'type' => 'structure', 'members' => [ 'textMatches' => [ 'shape' => 'TextMatches', ], ], 'union' => true, ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 50, 'min' => 1, ], 'MaxResultsForListDomains' => [ 'type' => 'integer', 'box' => true, 'max' => 25, 'min' => 1, ], 'Member' => [ 'type' => 'structure', 'members' => [ 'userIdentifier' => [ 'shape' => 'String', ], 'groupIdentifier' => [ 'shape' => 'String', ], ], 'union' => true, ], 'MemberDetails' => [ 'type' => 'structure', 'members' => [ 'user' => [ 'shape' => 'UserDetails', ], 'group' => [ 'shape' => 'GroupDetails', ], ], 'union' => true, ], 'Message' => [ 'type' => 'string', 'max' => 16384, 'min' => 0, 'sensitive' => true, ], 'MetadataFormEnforcementDetail' => [ 'type' => 'structure', 'members' => [ 'requiredMetadataForms' => [ 'shape' => 'RequiredMetadataFormList', ], ], ], 'MetadataFormInputs' => [ 'type' => 'list', 'member' => [ 'shape' => 'FormInput', ], ], 'MetadataFormReference' => [ 'type' => 'structure', 'required' => [ 'typeIdentifier', 'typeRevision', ], 'members' => [ 'typeIdentifier' => [ 'shape' => 'FormTypeIdentifier', ], 'typeRevision' => [ 'shape' => 'Revision', ], ], ], 'MetadataFormSummary' => [ 'type' => 'structure', 'required' => [ 'typeName', 'typeRevision', ], 'members' => [ 'formName' => [ 'shape' => 'FormName', ], 'typeName' => [ 'shape' => 'FormTypeName', ], 'typeRevision' => [ 'shape' => 'Revision', ], ], ], 'MetadataForms' => [ 'type' => 'list', 'member' => [ 'shape' => 'FormOutput', ], ], 'MetadataFormsSummary' => [ 'type' => 'list', 'member' => [ 'shape' => 'MetadataFormSummary', ], ], 'MetadataGenerationRunIdentifier' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'MetadataGenerationRunItem' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'owningProjectId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'MetadataGenerationRunIdentifier', ], 'target' => [ 'shape' => 'MetadataGenerationRunTarget', ], 'status' => [ 'shape' => 'MetadataGenerationRunStatus', ], 'type' => [ 'shape' => 'MetadataGenerationRunType', 'deprecated' => true, 'deprecatedMessage' => 'This field is going to be deprecated, please use the \'types\' field to provide the MetadataGenerationRun types', 'deprecatedSince' => '2025-11-21', ], 'types' => [ 'shape' => 'MetadataGenerationRunTypes', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], ], ], 'MetadataGenerationRunStatus' => [ 'type' => 'string', 'enum' => [ 'SUBMITTED', 'IN_PROGRESS', 'CANCELED', 'SUCCEEDED', 'FAILED', 'PARTIALLY_SUCCEEDED', ], ], 'MetadataGenerationRunTarget' => [ 'type' => 'structure', 'required' => [ 'type', 'identifier', ], 'members' => [ 'type' => [ 'shape' => 'MetadataGenerationTargetType', ], 'identifier' => [ 'shape' => 'String', ], 'revision' => [ 'shape' => 'Revision', ], ], ], 'MetadataGenerationRunType' => [ 'type' => 'string', 'enum' => [ 'BUSINESS_DESCRIPTIONS', 'BUSINESS_NAMES', 'BUSINESS_GLOSSARY_ASSOCIATIONS', ], ], 'MetadataGenerationRunTypeStat' => [ 'type' => 'structure', 'required' => [ 'type', 'status', ], 'members' => [ 'type' => [ 'shape' => 'MetadataGenerationRunType', ], 'status' => [ 'shape' => 'MetadataGenerationRunStatus', ], 'errorMessage' => [ 'shape' => 'String', ], ], ], 'MetadataGenerationRunTypeStats' => [ 'type' => 'list', 'member' => [ 'shape' => 'MetadataGenerationRunTypeStat', ], ], 'MetadataGenerationRunTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'MetadataGenerationRunType', ], 'max' => 2, 'min' => 1, ], 'MetadataGenerationRuns' => [ 'type' => 'list', 'member' => [ 'shape' => 'MetadataGenerationRunItem', ], ], 'MetadataGenerationTargetType' => [ 'type' => 'string', 'enum' => [ 'ASSET', ], ], 'MetadataMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'MlflowPropertiesInput' => [ 'type' => 'structure', 'members' => [ 'trackingServerArn' => [ 'shape' => 'String', ], ], ], 'MlflowPropertiesOutput' => [ 'type' => 'structure', 'members' => [ 'trackingServerArn' => [ 'shape' => 'String', ], ], ], 'MlflowPropertiesPatch' => [ 'type' => 'structure', 'members' => [ 'trackingServerArn' => [ 'shape' => 'String', ], ], ], 'Model' => [ 'type' => 'structure', 'members' => [ 'smithy' => [ 'shape' => 'Smithy', ], ], 'sensitive' => true, 'union' => true, ], 'Name' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'sensitive' => true, ], 'NameIdentifier' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'String', ], 'namespace' => [ 'shape' => 'String', ], ], ], 'NameIdentifiers' => [ 'type' => 'list', 'member' => [ 'shape' => 'NameIdentifier', ], ], 'NotEqualToExpression' => [ 'type' => 'structure', 'required' => [ 'columnName', 'value', ], 'members' => [ 'columnName' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'NotInExpression' => [ 'type' => 'structure', 'required' => [ 'columnName', 'values', ], 'members' => [ 'columnName' => [ 'shape' => 'String', ], 'values' => [ 'shape' => 'StringList', ], ], ], 'NotLikeExpression' => [ 'type' => 'structure', 'required' => [ 'columnName', 'value', ], 'members' => [ 'columnName' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], ], 'NotificationOutput' => [ 'type' => 'structure', 'required' => [ 'identifier', 'domainIdentifier', 'type', 'topic', 'title', 'message', 'actionLink', 'creationTimestamp', 'lastUpdatedTimestamp', ], 'members' => [ 'identifier' => [ 'shape' => 'TaskId', ], 'domainIdentifier' => [ 'shape' => 'DomainId', ], 'type' => [ 'shape' => 'NotificationType', ], 'topic' => [ 'shape' => 'Topic', ], 'title' => [ 'shape' => 'Title', ], 'message' => [ 'shape' => 'Message', ], 'status' => [ 'shape' => 'TaskStatus', ], 'actionLink' => [ 'shape' => 'ActionLink', ], 'creationTimestamp' => [ 'shape' => 'Timestamp', ], 'lastUpdatedTimestamp' => [ 'shape' => 'Timestamp', ], 'metadata' => [ 'shape' => 'MetadataMap', ], ], ], 'NotificationResource' => [ 'type' => 'structure', 'required' => [ 'type', 'id', ], 'members' => [ 'type' => [ 'shape' => 'NotificationResourceType', ], 'id' => [ 'shape' => 'String', ], 'name' => [ 'shape' => 'String', ], ], ], 'NotificationResourceType' => [ 'type' => 'string', 'enum' => [ 'PROJECT', ], ], 'NotificationRole' => [ 'type' => 'string', 'enum' => [ 'PROJECT_OWNER', 'PROJECT_CONTRIBUTOR', 'PROJECT_VIEWER', 'DOMAIN_OWNER', 'PROJECT_SUBSCRIBER', ], ], 'NotificationSubjects' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'NotificationType' => [ 'type' => 'string', 'enum' => [ 'TASK', 'EVENT', ], ], 'NotificationsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NotificationOutput', ], ], 'OAuth2ClientApplication' => [ 'type' => 'structure', 'members' => [ 'userManagedClientApplicationClientId' => [ 'shape' => 'OAuth2ClientApplicationUserManagedClientApplicationClientIdString', ], 'aWSManagedClientApplicationReference' => [ 'shape' => 'OAuth2ClientApplicationAWSManagedClientApplicationReferenceString', ], ], ], 'OAuth2ClientApplicationAWSManagedClientApplicationReferenceString' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '\\S+', ], 'OAuth2ClientApplicationUserManagedClientApplicationClientIdString' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '\\S+', ], 'OAuth2GrantType' => [ 'type' => 'string', 'enum' => [ 'AUTHORIZATION_CODE', 'CLIENT_CREDENTIALS', 'JWT_BEARER', ], ], 'OAuth2Properties' => [ 'type' => 'structure', 'members' => [ 'oAuth2GrantType' => [ 'shape' => 'OAuth2GrantType', ], 'oAuth2ClientApplication' => [ 'shape' => 'OAuth2ClientApplication', ], 'tokenUrl' => [ 'shape' => 'OAuth2PropertiesTokenUrlString', ], 'tokenUrlParametersMap' => [ 'shape' => 'TokenUrlParametersMap', ], 'authorizationCodeProperties' => [ 'shape' => 'AuthorizationCodeProperties', ], 'oAuth2Credentials' => [ 'shape' => 'GlueOAuth2Credentials', ], ], ], 'OAuth2PropertiesTokenUrlString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]', ], 'OpenLineageRunEventSummary' => [ 'type' => 'structure', 'members' => [ 'eventType' => [ 'shape' => 'OpenLineageRunState', ], 'runId' => [ 'shape' => 'String', ], 'job' => [ 'shape' => 'NameIdentifier', ], 'inputs' => [ 'shape' => 'NameIdentifiers', ], 'outputs' => [ 'shape' => 'NameIdentifiers', ], ], ], 'OpenLineageRunState' => [ 'type' => 'string', 'enum' => [ 'START', 'RUNNING', 'COMPLETE', 'ABORT', 'FAIL', 'OTHER', ], ], 'OverallDeploymentStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING_DEPLOYMENT', 'IN_PROGRESS', 'SUCCESSFUL', 'FAILED_VALIDATION', 'FAILED_DEPLOYMENT', ], ], 'OverrideDomainUnitOwnersPolicyGrantDetail' => [ 'type' => 'structure', 'members' => [ 'includeChildDomainUnits' => [ 'shape' => 'Boolean', ], ], ], 'OverrideProjectOwnersPolicyGrantDetail' => [ 'type' => 'structure', 'members' => [ 'includeChildDomainUnits' => [ 'shape' => 'Boolean', ], ], ], 'OwnerGroupProperties' => [ 'type' => 'structure', 'required' => [ 'groupIdentifier', ], 'members' => [ 'groupIdentifier' => [ 'shape' => 'GroupIdentifier', ], ], ], 'OwnerGroupPropertiesOutput' => [ 'type' => 'structure', 'members' => [ 'groupId' => [ 'shape' => 'String', ], ], ], 'OwnerProperties' => [ 'type' => 'structure', 'members' => [ 'user' => [ 'shape' => 'OwnerUserProperties', ], 'group' => [ 'shape' => 'OwnerGroupProperties', ], ], 'union' => true, ], 'OwnerPropertiesOutput' => [ 'type' => 'structure', 'members' => [ 'user' => [ 'shape' => 'OwnerUserPropertiesOutput', ], 'group' => [ 'shape' => 'OwnerGroupPropertiesOutput', ], ], 'union' => true, ], 'OwnerUserProperties' => [ 'type' => 'structure', 'required' => [ 'userIdentifier', ], 'members' => [ 'userIdentifier' => [ 'shape' => 'UserIdentifier', ], ], ], 'OwnerUserPropertiesOutput' => [ 'type' => 'structure', 'members' => [ 'userId' => [ 'shape' => 'String', ], ], ], 'PaginationToken' => [ 'type' => 'string', 'max' => 8192, 'min' => 1, ], 'ParameterStorePath' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'Password' => [ 'type' => 'string', 'max' => 64, 'min' => 0, 'sensitive' => true, ], 'Permissions' => [ 'type' => 'structure', 'members' => [ 's3' => [ 'shape' => 'S3Permissions', ], ], 'union' => true, ], 'PhysicalConnectionRequirements' => [ 'type' => 'structure', 'members' => [ 'subnetId' => [ 'shape' => 'SubnetId', ], 'subnetIdList' => [ 'shape' => 'SubnetIdList', ], 'securityGroupIdList' => [ 'shape' => 'SecurityGroupIdList', ], 'availabilityZone' => [ 'shape' => 'PhysicalConnectionRequirementsAvailabilityZoneString', ], ], ], 'PhysicalConnectionRequirementsAvailabilityZoneString' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'PhysicalEndpoint' => [ 'type' => 'structure', 'members' => [ 'awsLocation' => [ 'shape' => 'AwsLocation', ], 'glueConnectionName' => [ 'shape' => 'String', ], 'glueConnection' => [ 'shape' => 'GlueConnection', ], 'enableTrustedIdentityPropagation' => [ 'shape' => 'Boolean', ], 'host' => [ 'shape' => 'String', ], 'port' => [ 'shape' => 'Integer', ], 'protocol' => [ 'shape' => 'Protocol', ], 'stage' => [ 'shape' => 'String', ], ], ], 'PhysicalEndpoints' => [ 'type' => 'list', 'member' => [ 'shape' => 'PhysicalEndpoint', ], ], 'PolicyArn' => [ 'type' => 'string', 'pattern' => 'arn:aws[^:]*:iam::(aws|\\d{12}):policy/[\\w+=,.@-]*', ], 'PolicyGrantDetail' => [ 'type' => 'structure', 'members' => [ 'createDomainUnit' => [ 'shape' => 'CreateDomainUnitPolicyGrantDetail', ], 'overrideDomainUnitOwners' => [ 'shape' => 'OverrideDomainUnitOwnersPolicyGrantDetail', ], 'addToProjectMemberPool' => [ 'shape' => 'AddToProjectMemberPoolPolicyGrantDetail', ], 'overrideProjectOwners' => [ 'shape' => 'OverrideProjectOwnersPolicyGrantDetail', ], 'createGlossary' => [ 'shape' => 'CreateGlossaryPolicyGrantDetail', ], 'createFormType' => [ 'shape' => 'CreateFormTypePolicyGrantDetail', ], 'createAssetType' => [ 'shape' => 'CreateAssetTypePolicyGrantDetail', ], 'createProject' => [ 'shape' => 'CreateProjectPolicyGrantDetail', ], 'createEnvironmentProfile' => [ 'shape' => 'CreateEnvironmentProfilePolicyGrantDetail', ], 'delegateCreateEnvironmentProfile' => [ 'shape' => 'Unit', ], 'createEnvironment' => [ 'shape' => 'Unit', ], 'createEnvironmentFromBlueprint' => [ 'shape' => 'Unit', ], 'createProjectFromProjectProfile' => [ 'shape' => 'CreateProjectFromProjectProfilePolicyGrantDetail', ], 'useAssetType' => [ 'shape' => 'UseAssetTypePolicyGrantDetail', ], ], 'union' => true, ], 'PolicyGrantList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PolicyGrantMember', ], ], 'PolicyGrantMember' => [ 'type' => 'structure', 'members' => [ 'principal' => [ 'shape' => 'PolicyGrantPrincipal', ], 'detail' => [ 'shape' => 'PolicyGrantDetail', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'grantId' => [ 'shape' => 'GrantIdentifier', ], ], ], 'PolicyGrantPrincipal' => [ 'type' => 'structure', 'members' => [ 'user' => [ 'shape' => 'UserPolicyGrantPrincipal', ], 'group' => [ 'shape' => 'GroupPolicyGrantPrincipal', ], 'project' => [ 'shape' => 'ProjectPolicyGrantPrincipal', ], 'domainUnit' => [ 'shape' => 'DomainUnitPolicyGrantPrincipal', ], ], 'union' => true, ], 'PostLineageEventInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'event', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'event' => [ 'shape' => 'LineageEvent', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'header', 'locationName' => 'Client-Token', ], ], 'payload' => 'event', ], 'PostLineageEventOutput' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'LineageEventIdentifier', ], 'domainId' => [ 'shape' => 'DomainId', ], ], ], 'PostTimeSeriesDataPointsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityIdentifier', 'entityType', 'forms', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityIdentifier' => [ 'shape' => 'EntityIdentifier', 'location' => 'uri', 'locationName' => 'entityIdentifier', ], 'entityType' => [ 'shape' => 'TimeSeriesEntityType', 'location' => 'uri', 'locationName' => 'entityType', ], 'forms' => [ 'shape' => 'TimeSeriesDataPointFormInputList', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'PostTimeSeriesDataPointsOutput' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'entityId' => [ 'shape' => 'EntityId', ], 'entityType' => [ 'shape' => 'TimeSeriesEntityType', ], 'forms' => [ 'shape' => 'TimeSeriesDataPointFormOutputList', ], ], ], 'PredictionChoices' => [ 'type' => 'list', 'member' => [ 'shape' => 'Integer', ], ], 'PredictionConfiguration' => [ 'type' => 'structure', 'members' => [ 'businessNameGeneration' => [ 'shape' => 'BusinessNameGenerationConfiguration', ], ], ], 'ProjectDeletionError' => [ 'type' => 'structure', 'members' => [ 'code' => [ 'shape' => 'String', ], 'message' => [ 'shape' => 'String', ], ], ], 'ProjectDesignation' => [ 'type' => 'string', 'enum' => [ 'OWNER', 'CONTRIBUTOR', 'PROJECT_CATALOG_STEWARD', ], ], 'ProjectGrantFilter' => [ 'type' => 'structure', 'members' => [ 'domainUnitFilter' => [ 'shape' => 'DomainUnitFilterForProject', ], ], 'union' => true, ], 'ProjectId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'ProjectIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProjectId', ], ], 'ProjectMember' => [ 'type' => 'structure', 'required' => [ 'memberDetails', 'designation', ], 'members' => [ 'memberDetails' => [ 'shape' => 'MemberDetails', ], 'designation' => [ 'shape' => 'UserDesignation', ], ], ], 'ProjectMembers' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProjectMember', ], ], 'ProjectName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[\\w -]+', 'sensitive' => true, ], 'ProjectPolicyGrantPrincipal' => [ 'type' => 'structure', 'required' => [ 'projectDesignation', ], 'members' => [ 'projectDesignation' => [ 'shape' => 'ProjectDesignation', ], 'projectIdentifier' => [ 'shape' => 'ProjectId', ], 'projectGrantFilter' => [ 'shape' => 'ProjectGrantFilter', ], ], ], 'ProjectProfileId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'ProjectProfileList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'ProjectProfileName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[\\w -]+', 'sensitive' => true, ], 'ProjectProfileSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProjectProfileSummary', ], ], 'ProjectProfileSummary' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'name', 'createdBy', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'ProjectProfileId', ], 'name' => [ 'shape' => 'ProjectProfileName', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'Status', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], ], ], 'ProjectResourceTagParameters' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResourceTagParameter', ], 'max' => 25, 'min' => 0, ], 'ProjectStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'DELETING', 'DELETE_FAILED', 'UPDATING', 'UPDATE_FAILED', 'MOVING', ], ], 'ProjectSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProjectSummary', ], ], 'ProjectSummary' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'name', 'createdBy', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'ProjectId', ], 'name' => [ 'shape' => 'ProjectName', ], 'description' => [ 'shape' => 'Description', ], 'projectStatus' => [ 'shape' => 'ProjectStatus', ], 'failureReasons' => [ 'shape' => 'FailureReasons', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], ], ], 'ProjectsForRule' => [ 'type' => 'structure', 'required' => [ 'selectionMode', ], 'members' => [ 'selectionMode' => [ 'shape' => 'RuleScopeSelectionMode', ], 'specificProjects' => [ 'shape' => 'RuleProjectIdentifierList', ], ], ], 'PropertyMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'PropertyMapKeyString', ], 'value' => [ 'shape' => 'PropertyMapValueString', ], ], 'PropertyMapKeyString' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'PropertyMapValueString' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'Protocol' => [ 'type' => 'string', 'enum' => [ 'ATHENA', 'GLUE_INTERACTIVE_SESSION', 'HTTPS', 'JDBC', 'LIVY', 'ODBC', 'PRISM', ], ], 'ProvisioningConfiguration' => [ 'type' => 'structure', 'members' => [ 'lakeFormationConfiguration' => [ 'shape' => 'LakeFormationConfiguration', ], ], 'union' => true, ], 'ProvisioningConfigurationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProvisioningConfiguration', ], ], 'ProvisioningProperties' => [ 'type' => 'structure', 'members' => [ 'cloudFormation' => [ 'shape' => 'CloudFormationProperties', ], ], 'union' => true, ], 'PutDataExportConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'enableExport', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'enableExport' => [ 'shape' => 'Boolean', ], 'encryptionConfiguration' => [ 'shape' => 'EncryptionConfiguration', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'PutDataExportConfigurationOutput' => [ 'type' => 'structure', 'members' => [], ], 'PutEnvironmentBlueprintConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentBlueprintIdentifier', 'enabledRegions', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentBlueprintIdentifier' => [ 'shape' => 'EnvironmentBlueprintId', 'location' => 'uri', 'locationName' => 'environmentBlueprintIdentifier', ], 'provisioningRoleArn' => [ 'shape' => 'RoleArn', ], 'manageAccessRoleArn' => [ 'shape' => 'RoleArn', ], 'environmentRolePermissionBoundary' => [ 'shape' => 'PolicyArn', ], 'enabledRegions' => [ 'shape' => 'EnabledRegionList', ], 'regionalParameters' => [ 'shape' => 'RegionalParameterMap', ], 'globalParameters' => [ 'shape' => 'GlobalParameterMap', ], 'provisioningConfigurations' => [ 'shape' => 'ProvisioningConfigurationList', ], ], ], 'PutEnvironmentBlueprintConfigurationOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'environmentBlueprintId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'environmentBlueprintId' => [ 'shape' => 'EnvironmentBlueprintId', ], 'provisioningRoleArn' => [ 'shape' => 'RoleArn', ], 'environmentRolePermissionBoundary' => [ 'shape' => 'PolicyArn', ], 'manageAccessRoleArn' => [ 'shape' => 'RoleArn', ], 'enabledRegions' => [ 'shape' => 'EnabledRegionList', ], 'regionalParameters' => [ 'shape' => 'RegionalParameterMap', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'provisioningConfigurations' => [ 'shape' => 'ProvisioningConfigurationList', ], ], ], 'RecommendationConfiguration' => [ 'type' => 'structure', 'members' => [ 'enableBusinessNameGeneration' => [ 'shape' => 'Boolean', ], ], ], 'RedshiftClusterStorage' => [ 'type' => 'structure', 'required' => [ 'clusterName', ], 'members' => [ 'clusterName' => [ 'shape' => 'RedshiftClusterStorageClusterNameString', ], ], ], 'RedshiftClusterStorageClusterNameString' => [ 'type' => 'string', 'max' => 63, 'min' => 1, 'pattern' => '[0-9a-z].[a-z0-9\\-]*', ], 'RedshiftCredentialConfiguration' => [ 'type' => 'structure', 'required' => [ 'secretManagerArn', ], 'members' => [ 'secretManagerArn' => [ 'shape' => 'RedshiftCredentialConfigurationSecretManagerArnString', ], ], ], 'RedshiftCredentialConfigurationSecretManagerArnString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => 'arn:aws[^:]*:secretsmanager:[a-z]{2}-?(iso|gov)?-{1}[a-z]*-{1}[0-9]:\\d{12}:secret:.*', ], 'RedshiftCredentials' => [ 'type' => 'structure', 'members' => [ 'secretArn' => [ 'shape' => 'RedshiftCredentialsSecretArnString', ], 'usernamePassword' => [ 'shape' => 'UsernamePassword', ], ], 'sensitive' => true, 'union' => true, ], 'RedshiftCredentialsSecretArnString' => [ 'type' => 'string', 'pattern' => 'arn:aws[^:]*:secretsmanager:[a-z]{2}-?(iso|gov)?-{1}[a-z]*-{1}[0-9]:\\d{12}:secret:.*', ], 'RedshiftLineageSyncConfigurationInput' => [ 'type' => 'structure', 'members' => [ 'enabled' => [ 'shape' => 'Boolean', ], 'schedule' => [ 'shape' => 'LineageSyncSchedule', ], ], ], 'RedshiftLineageSyncConfigurationOutput' => [ 'type' => 'structure', 'members' => [ 'lineageJobId' => [ 'shape' => 'String', ], 'enabled' => [ 'shape' => 'Boolean', ], 'schedule' => [ 'shape' => 'LineageSyncSchedule', ], ], ], 'RedshiftPropertiesInput' => [ 'type' => 'structure', 'members' => [ 'storage' => [ 'shape' => 'RedshiftStorageProperties', ], 'databaseName' => [ 'shape' => 'RedshiftPropertiesInputDatabaseNameString', ], 'host' => [ 'shape' => 'RedshiftPropertiesInputHostString', ], 'port' => [ 'shape' => 'Integer', ], 'credentials' => [ 'shape' => 'RedshiftCredentials', ], 'lineageSync' => [ 'shape' => 'RedshiftLineageSyncConfigurationInput', ], ], ], 'RedshiftPropertiesInputDatabaseNameString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'RedshiftPropertiesInputHostString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'RedshiftPropertiesOutput' => [ 'type' => 'structure', 'members' => [ 'storage' => [ 'shape' => 'RedshiftStorageProperties', ], 'credentials' => [ 'shape' => 'RedshiftCredentials', ], 'isProvisionedSecret' => [ 'shape' => 'Boolean', ], 'jdbcIamUrl' => [ 'shape' => 'String', ], 'jdbcUrl' => [ 'shape' => 'String', ], 'redshiftTempDir' => [ 'shape' => 'String', ], 'lineageSync' => [ 'shape' => 'RedshiftLineageSyncConfigurationOutput', ], 'status' => [ 'shape' => 'ConnectionStatus', ], 'databaseName' => [ 'shape' => 'String', ], ], ], 'RedshiftPropertiesPatch' => [ 'type' => 'structure', 'members' => [ 'storage' => [ 'shape' => 'RedshiftStorageProperties', ], 'databaseName' => [ 'shape' => 'RedshiftPropertiesPatchDatabaseNameString', ], 'host' => [ 'shape' => 'RedshiftPropertiesPatchHostString', ], 'port' => [ 'shape' => 'Integer', ], 'credentials' => [ 'shape' => 'RedshiftCredentials', ], 'lineageSync' => [ 'shape' => 'RedshiftLineageSyncConfigurationInput', ], ], ], 'RedshiftPropertiesPatchDatabaseNameString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'RedshiftPropertiesPatchHostString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'RedshiftRunConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'relationalFilterConfigurations', ], 'members' => [ 'dataAccessRole' => [ 'shape' => 'RedshiftRunConfigurationInputDataAccessRoleString', ], 'relationalFilterConfigurations' => [ 'shape' => 'RelationalFilterConfigurations', ], 'redshiftCredentialConfiguration' => [ 'shape' => 'RedshiftCredentialConfiguration', ], 'redshiftStorage' => [ 'shape' => 'RedshiftStorage', ], ], ], 'RedshiftRunConfigurationInputDataAccessRoleString' => [ 'type' => 'string', 'pattern' => 'arn:aws[^:]*:iam::\\d{12}:(role|role/service-role)/[\\w+=,.@-]{1,128}', ], 'RedshiftRunConfigurationOutput' => [ 'type' => 'structure', 'required' => [ 'relationalFilterConfigurations', 'redshiftStorage', ], 'members' => [ 'accountId' => [ 'shape' => 'RedshiftRunConfigurationOutputAccountIdString', ], 'region' => [ 'shape' => 'RedshiftRunConfigurationOutputRegionString', ], 'dataAccessRole' => [ 'shape' => 'RedshiftRunConfigurationOutputDataAccessRoleString', ], 'relationalFilterConfigurations' => [ 'shape' => 'RelationalFilterConfigurations', ], 'redshiftCredentialConfiguration' => [ 'shape' => 'RedshiftCredentialConfiguration', ], 'redshiftStorage' => [ 'shape' => 'RedshiftStorage', ], ], ], 'RedshiftRunConfigurationOutputAccountIdString' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '\\d{12}', ], 'RedshiftRunConfigurationOutputDataAccessRoleString' => [ 'type' => 'string', 'pattern' => 'arn:aws[^:]*:iam::\\d{12}:(role|role/service-role)/[\\w+=,.@-]{1,128}', ], 'RedshiftRunConfigurationOutputRegionString' => [ 'type' => 'string', 'max' => 16, 'min' => 4, 'pattern' => '.*[a-z]{2}-?(iso|gov)?-{1}[a-z]*-{1}[0-9].*', ], 'RedshiftSelfGrantStatusOutput' => [ 'type' => 'structure', 'required' => [ 'selfGrantStatusDetails', ], 'members' => [ 'selfGrantStatusDetails' => [ 'shape' => 'SelfGrantStatusDetails', ], ], ], 'RedshiftServerlessStorage' => [ 'type' => 'structure', 'required' => [ 'workgroupName', ], 'members' => [ 'workgroupName' => [ 'shape' => 'RedshiftServerlessStorageWorkgroupNameString', ], ], ], 'RedshiftServerlessStorageWorkgroupNameString' => [ 'type' => 'string', 'max' => 64, 'min' => 3, 'pattern' => '[a-z0-9-]+', ], 'RedshiftStorage' => [ 'type' => 'structure', 'members' => [ 'redshiftClusterSource' => [ 'shape' => 'RedshiftClusterStorage', ], 'redshiftServerlessSource' => [ 'shape' => 'RedshiftServerlessStorage', ], ], 'union' => true, ], 'RedshiftStorageProperties' => [ 'type' => 'structure', 'members' => [ 'clusterName' => [ 'shape' => 'RedshiftStoragePropertiesClusterNameString', ], 'workgroupName' => [ 'shape' => 'RedshiftStoragePropertiesWorkgroupNameString', ], ], 'union' => true, ], 'RedshiftStoragePropertiesClusterNameString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'RedshiftStoragePropertiesWorkgroupNameString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'Region' => [ 'type' => 'structure', 'members' => [ 'regionName' => [ 'shape' => 'RegionName', ], 'regionNamePath' => [ 'shape' => 'ParameterStorePath', ], ], 'union' => true, ], 'RegionName' => [ 'type' => 'string', 'max' => 16, 'min' => 4, 'pattern' => '[a-z]{2}-?(iso|gov)?-{1}[a-z]*-{1}[0-9]', ], 'RegionalParameter' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'RegionalParameterMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'RegionName', ], 'value' => [ 'shape' => 'RegionalParameter', ], ], 'RejectChoice' => [ 'type' => 'structure', 'required' => [ 'predictionTarget', ], 'members' => [ 'predictionTarget' => [ 'shape' => 'String', ], 'predictionChoices' => [ 'shape' => 'PredictionChoices', ], ], ], 'RejectChoices' => [ 'type' => 'list', 'member' => [ 'shape' => 'RejectChoice', ], ], 'RejectPredictionsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'AssetIdentifier', 'location' => 'uri', 'locationName' => 'identifier', ], 'revision' => [ 'shape' => 'Revision', 'location' => 'querystring', 'locationName' => 'revision', ], 'rejectRule' => [ 'shape' => 'RejectRule', ], 'rejectChoices' => [ 'shape' => 'RejectChoices', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'RejectPredictionsOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'assetId', 'assetRevision', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'assetId' => [ 'shape' => 'AssetId', ], 'assetRevision' => [ 'shape' => 'Revision', ], ], ], 'RejectRule' => [ 'type' => 'structure', 'members' => [ 'rule' => [ 'shape' => 'RejectRuleBehavior', ], 'threshold' => [ 'shape' => 'Float', ], ], ], 'RejectRuleBehavior' => [ 'type' => 'string', 'enum' => [ 'ALL', 'NONE', ], ], 'RejectSubscriptionRequestInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'SubscriptionRequestId', 'location' => 'uri', 'locationName' => 'identifier', ], 'decisionComment' => [ 'shape' => 'DecisionComment', ], ], ], 'RejectSubscriptionRequestOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'status', 'createdAt', 'updatedAt', 'requestReason', 'subscribedPrincipals', 'subscribedListings', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionRequestId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'status' => [ 'shape' => 'SubscriptionRequestStatus', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'requestReason' => [ 'shape' => 'RequestReason', ], 'subscribedPrincipals' => [ 'shape' => 'RejectSubscriptionRequestOutputSubscribedPrincipalsList', ], 'subscribedListings' => [ 'shape' => 'RejectSubscriptionRequestOutputSubscribedListingsList', ], 'reviewerId' => [ 'shape' => 'String', ], 'decisionComment' => [ 'shape' => 'DecisionComment', ], 'existingSubscriptionId' => [ 'shape' => 'SubscriptionId', ], 'metadataForms' => [ 'shape' => 'MetadataForms', ], ], ], 'RejectSubscriptionRequestOutputSubscribedListingsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedListing', ], 'max' => 1, 'min' => 1, ], 'RejectSubscriptionRequestOutputSubscribedPrincipalsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedPrincipal', ], 'max' => 1, 'min' => 1, ], 'RelationalFilterConfiguration' => [ 'type' => 'structure', 'required' => [ 'databaseName', ], 'members' => [ 'databaseName' => [ 'shape' => 'RelationalFilterConfigurationDatabaseNameString', ], 'schemaName' => [ 'shape' => 'RelationalFilterConfigurationSchemaNameString', ], 'filterExpressions' => [ 'shape' => 'FilterExpressions', ], ], ], 'RelationalFilterConfigurationDatabaseNameString' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'RelationalFilterConfigurationSchemaNameString' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'RelationalFilterConfigurations' => [ 'type' => 'list', 'member' => [ 'shape' => 'RelationalFilterConfiguration', ], ], 'RemoveEntityOwnerInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityType', 'entityIdentifier', 'owner', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityType' => [ 'shape' => 'DataZoneEntityType', 'location' => 'uri', 'locationName' => 'entityType', ], 'entityIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'entityIdentifier', ], 'owner' => [ 'shape' => 'OwnerProperties', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'RemoveEntityOwnerOutput' => [ 'type' => 'structure', 'members' => [], ], 'RemovePolicyGrantInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'entityType', 'entityIdentifier', 'policyType', 'principal', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'entityType' => [ 'shape' => 'TargetEntityType', 'location' => 'uri', 'locationName' => 'entityType', ], 'entityIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'entityIdentifier', ], 'policyType' => [ 'shape' => 'ManagedPolicyType', ], 'principal' => [ 'shape' => 'PolicyGrantPrincipal', ], 'grantIdentifier' => [ 'shape' => 'GrantIdentifier', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'RemovePolicyGrantOutput' => [ 'type' => 'structure', 'members' => [], ], 'RequestReason' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, 'sensitive' => true, ], 'RequiredMetadataFormList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MetadataFormReference', ], 'max' => 5, 'min' => 1, ], 'ResolutionStrategy' => [ 'type' => 'string', 'enum' => [ 'MANUAL', ], ], 'Resource' => [ 'type' => 'structure', 'required' => [ 'value', 'type', ], 'members' => [ 'provider' => [ 'shape' => 'String', ], 'name' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], 'type' => [ 'shape' => 'String', ], ], ], 'ResourceList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Resource', ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'ResourceTag' => [ 'type' => 'structure', 'required' => [ 'key', 'value', 'source', ], 'members' => [ 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'source' => [ 'shape' => 'ResourceTagSource', ], ], ], 'ResourceTagParameter' => [ 'type' => 'structure', 'required' => [ 'key', 'value', 'isValueEditable', ], 'members' => [ 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'isValueEditable' => [ 'shape' => 'Boolean', ], ], ], 'ResourceTagSource' => [ 'type' => 'string', 'enum' => [ 'PROJECT', 'PROJECT_PROFILE', ], ], 'ResourceTags' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResourceTag', ], 'max' => 25, 'min' => 0, ], 'Revision' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'RevisionInput' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-zA-Z0-9_-]+', ], 'RevokeSubscriptionInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'SubscriptionId', 'location' => 'uri', 'locationName' => 'identifier', ], 'retainPermissions' => [ 'shape' => 'Boolean', ], ], ], 'RevokeSubscriptionOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'status', 'createdAt', 'updatedAt', 'subscribedPrincipal', 'subscribedListing', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'status' => [ 'shape' => 'SubscriptionStatus', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'subscribedPrincipal' => [ 'shape' => 'SubscribedPrincipal', ], 'subscribedListing' => [ 'shape' => 'SubscribedListing', ], 'subscriptionRequestId' => [ 'shape' => 'SubscriptionRequestId', ], 'retainPermissions' => [ 'shape' => 'Boolean', ], ], ], 'RoleArn' => [ 'type' => 'string', 'pattern' => 'arn:aws[^:]*:iam::\\d{12}:(role|role/service-role)/[\\w+=,.@-]*', ], 'RowFilter' => [ 'type' => 'structure', 'members' => [ 'expression' => [ 'shape' => 'RowFilterExpression', ], 'and' => [ 'shape' => 'RowFilterList', ], 'or' => [ 'shape' => 'RowFilterList', ], ], 'union' => true, ], 'RowFilterConfiguration' => [ 'type' => 'structure', 'required' => [ 'rowFilter', ], 'members' => [ 'rowFilter' => [ 'shape' => 'RowFilter', ], 'sensitive' => [ 'shape' => 'Boolean', ], ], ], 'RowFilterExpression' => [ 'type' => 'structure', 'members' => [ 'equalTo' => [ 'shape' => 'EqualToExpression', ], 'notEqualTo' => [ 'shape' => 'NotEqualToExpression', ], 'greaterThan' => [ 'shape' => 'GreaterThanExpression', ], 'lessThan' => [ 'shape' => 'LessThanExpression', ], 'greaterThanOrEqualTo' => [ 'shape' => 'GreaterThanOrEqualToExpression', ], 'lessThanOrEqualTo' => [ 'shape' => 'LessThanOrEqualToExpression', ], 'isNull' => [ 'shape' => 'IsNullExpression', ], 'isNotNull' => [ 'shape' => 'IsNotNullExpression', ], 'in' => [ 'shape' => 'InExpression', ], 'notIn' => [ 'shape' => 'NotInExpression', ], 'like' => [ 'shape' => 'LikeExpression', ], 'notLike' => [ 'shape' => 'NotLikeExpression', ], ], 'union' => true, ], 'RowFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RowFilter', ], ], 'RuleAction' => [ 'type' => 'string', 'enum' => [ 'CREATE_LISTING_CHANGE_SET', 'CREATE_SUBSCRIPTION_REQUEST', ], ], 'RuleAssetTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssetTypeIdentifier', ], 'min' => 1, ], 'RuleDetail' => [ 'type' => 'structure', 'members' => [ 'metadataFormEnforcementDetail' => [ 'shape' => 'MetadataFormEnforcementDetail', ], 'glossaryTermEnforcementDetail' => [ 'shape' => 'GlossaryTermEnforcementDetail', ], ], 'union' => true, ], 'RuleId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'RuleName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[\\w -]+', 'sensitive' => true, ], 'RuleProjectIdentifierList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProjectId', ], 'min' => 1, ], 'RuleScope' => [ 'type' => 'structure', 'members' => [ 'assetType' => [ 'shape' => 'AssetTypesForRule', ], 'dataProduct' => [ 'shape' => 'Boolean', ], 'project' => [ 'shape' => 'ProjectsForRule', ], ], ], 'RuleScopeSelectionMode' => [ 'type' => 'string', 'enum' => [ 'ALL', 'SPECIFIC', ], ], 'RuleSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'RuleSummary', ], ], 'RuleSummary' => [ 'type' => 'structure', 'members' => [ 'identifier' => [ 'shape' => 'RuleId', ], 'revision' => [ 'shape' => 'Revision', ], 'ruleType' => [ 'shape' => 'RuleType', ], 'name' => [ 'shape' => 'RuleName', ], 'targetType' => [ 'shape' => 'RuleTargetType', ], 'target' => [ 'shape' => 'RuleTarget', ], 'action' => [ 'shape' => 'RuleAction', ], 'scope' => [ 'shape' => 'RuleScope', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'lastUpdatedBy' => [ 'shape' => 'UpdatedBy', ], ], ], 'RuleTarget' => [ 'type' => 'structure', 'members' => [ 'domainUnitTarget' => [ 'shape' => 'DomainUnitTarget', ], ], 'union' => true, ], 'RuleTargetType' => [ 'type' => 'string', 'enum' => [ 'DOMAIN_UNIT', ], ], 'RuleType' => [ 'type' => 'string', 'enum' => [ 'METADATA_FORM_ENFORCEMENT', 'GLOSSARY_TERM_ENFORCEMENT', ], ], 'RunIdentifier' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'RunStatisticsForAssets' => [ 'type' => 'structure', 'members' => [ 'added' => [ 'shape' => 'Integer', ], 'updated' => [ 'shape' => 'Integer', ], 'unchanged' => [ 'shape' => 'Integer', ], 'skipped' => [ 'shape' => 'Integer', ], 'failed' => [ 'shape' => 'Integer', ], ], ], 'S3AccessGrantLocationId' => [ 'type' => 'string', 'max' => 64, 'min' => 0, 'pattern' => '[a-zA-Z0-9\\-]+', ], 'S3Location' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => 's3://.+', ], 'S3LocationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'S3Location', ], 'max' => 20, 'min' => 0, ], 'S3Permission' => [ 'type' => 'string', 'enum' => [ 'READ', 'WRITE', ], ], 'S3Permissions' => [ 'type' => 'list', 'member' => [ 'shape' => 'S3Permission', ], ], 'S3PropertiesInput' => [ 'type' => 'structure', 'required' => [ 's3Uri', ], 'members' => [ 's3Uri' => [ 'shape' => 'S3Uri', ], 's3AccessGrantLocationId' => [ 'shape' => 'S3AccessGrantLocationId', ], ], ], 'S3PropertiesOutput' => [ 'type' => 'structure', 'required' => [ 's3Uri', ], 'members' => [ 's3Uri' => [ 'shape' => 'S3Uri', ], 's3AccessGrantLocationId' => [ 'shape' => 'S3AccessGrantLocationId', ], 'status' => [ 'shape' => 'ConnectionStatus', ], 'errorMessage' => [ 'shape' => 'String', ], ], ], 'S3PropertiesPatch' => [ 'type' => 'structure', 'required' => [ 's3Uri', ], 'members' => [ 's3Uri' => [ 'shape' => 'S3Uri', ], 's3AccessGrantLocationId' => [ 'shape' => 'S3AccessGrantLocationId', ], ], ], 'S3Uri' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 's3://.+', ], 'SageMakerAssetType' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'SageMakerResourceArn' => [ 'type' => 'string', 'pattern' => 'arn:aws[^:]*:sagemaker:[a-z]{2}-?(iso|gov)?-{1}[a-z]*-{1}[0-9]:\\d{12}:[\\w+=,.@-]{1,128}/[\\w+=,.@-]{1,256}', ], 'SageMakerRunConfigurationInput' => [ 'type' => 'structure', 'required' => [ 'trackingAssets', ], 'members' => [ 'trackingAssets' => [ 'shape' => 'TrackingAssets', ], ], ], 'SageMakerRunConfigurationOutput' => [ 'type' => 'structure', 'required' => [ 'trackingAssets', ], 'members' => [ 'accountId' => [ 'shape' => 'SageMakerRunConfigurationOutputAccountIdString', ], 'region' => [ 'shape' => 'SageMakerRunConfigurationOutputRegionString', ], 'trackingAssets' => [ 'shape' => 'TrackingAssets', ], ], ], 'SageMakerRunConfigurationOutputAccountIdString' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '\\d{12}', ], 'SageMakerRunConfigurationOutputRegionString' => [ 'type' => 'string', 'max' => 16, 'min' => 4, 'pattern' => '.*[a-z]{2}-?(iso|gov)?-{1}[a-z]*-{1}[0-9].*', ], 'ScheduleConfiguration' => [ 'type' => 'structure', 'members' => [ 'timezone' => [ 'shape' => 'Timezone', ], 'schedule' => [ 'shape' => 'CronString', ], ], 'sensitive' => true, ], 'SearchGroupProfilesInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'groupType', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'groupType' => [ 'shape' => 'GroupSearchType', ], 'searchText' => [ 'shape' => 'GroupSearchText', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'SearchGroupProfilesOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'GroupProfileSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'SearchInItem' => [ 'type' => 'structure', 'required' => [ 'attribute', ], 'members' => [ 'attribute' => [ 'shape' => 'Attribute', ], ], ], 'SearchInList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SearchInItem', ], 'max' => 10, 'min' => 1, ], 'SearchInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'searchScope', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'owningProjectIdentifier' => [ 'shape' => 'ProjectId', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], 'searchScope' => [ 'shape' => 'InventorySearchScope', ], 'searchText' => [ 'shape' => 'SearchText', ], 'searchIn' => [ 'shape' => 'SearchInList', ], 'filters' => [ 'shape' => 'FilterClause', ], 'sort' => [ 'shape' => 'SearchSort', ], 'additionalAttributes' => [ 'shape' => 'SearchOutputAdditionalAttributes', ], ], ], 'SearchInventoryResultItem' => [ 'type' => 'structure', 'members' => [ 'glossaryItem' => [ 'shape' => 'GlossaryItem', ], 'glossaryTermItem' => [ 'shape' => 'GlossaryTermItem', ], 'assetItem' => [ 'shape' => 'AssetItem', ], 'dataProductItem' => [ 'shape' => 'DataProductResultItem', ], ], 'union' => true, ], 'SearchInventoryResultItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'SearchInventoryResultItem', ], ], 'SearchListingsInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'searchText' => [ 'shape' => 'SearchListingsInputSearchTextString', ], 'searchIn' => [ 'shape' => 'SearchInList', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], 'filters' => [ 'shape' => 'FilterClause', ], 'aggregations' => [ 'shape' => 'AggregationList', ], 'sort' => [ 'shape' => 'SearchSort', ], 'additionalAttributes' => [ 'shape' => 'SearchOutputAdditionalAttributes', ], ], ], 'SearchListingsInputSearchTextString' => [ 'type' => 'string', 'max' => 512, 'min' => 0, ], 'SearchListingsOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'SearchResultItems', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], 'totalMatchCount' => [ 'shape' => 'Integer', ], 'aggregates' => [ 'shape' => 'AggregationOutputList', ], ], ], 'SearchOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'SearchInventoryResultItems', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], 'totalMatchCount' => [ 'shape' => 'Integer', ], ], ], 'SearchOutputAdditionalAttribute' => [ 'type' => 'string', 'enum' => [ 'FORMS', 'TIME_SERIES_DATA_POINT_FORMS', 'TEXT_MATCH_RATIONALE', ], ], 'SearchOutputAdditionalAttributes' => [ 'type' => 'list', 'member' => [ 'shape' => 'SearchOutputAdditionalAttribute', ], ], 'SearchResultItem' => [ 'type' => 'structure', 'members' => [ 'assetListing' => [ 'shape' => 'AssetListingItem', ], 'dataProductListing' => [ 'shape' => 'DataProductListingItem', ], ], 'union' => true, ], 'SearchResultItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'SearchResultItem', ], ], 'SearchSort' => [ 'type' => 'structure', 'required' => [ 'attribute', ], 'members' => [ 'attribute' => [ 'shape' => 'Attribute', ], 'order' => [ 'shape' => 'SortOrder', ], ], ], 'SearchText' => [ 'type' => 'string', 'max' => 512, 'min' => 1, ], 'SearchTypesInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'searchScope', 'managed', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], 'searchScope' => [ 'shape' => 'TypesSearchScope', ], 'searchText' => [ 'shape' => 'SearchText', ], 'searchIn' => [ 'shape' => 'SearchInList', ], 'filters' => [ 'shape' => 'FilterClause', ], 'sort' => [ 'shape' => 'SearchSort', ], 'managed' => [ 'shape' => 'Boolean', ], ], ], 'SearchTypesOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'SearchTypesResultItems', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], 'totalMatchCount' => [ 'shape' => 'Integer', ], ], ], 'SearchTypesResultItem' => [ 'type' => 'structure', 'members' => [ 'assetTypeItem' => [ 'shape' => 'AssetTypeItem', ], 'formTypeItem' => [ 'shape' => 'FormTypeData', ], 'lineageNodeTypeItem' => [ 'shape' => 'LineageNodeTypeItem', ], ], 'union' => true, ], 'SearchTypesResultItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'SearchTypesResultItem', ], ], 'SearchUserProfilesInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'userType', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'userType' => [ 'shape' => 'UserSearchType', ], 'searchText' => [ 'shape' => 'UserSearchText', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'SearchUserProfilesOutput' => [ 'type' => 'structure', 'members' => [ 'items' => [ 'shape' => 'UserProfileSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'SecurityGroupIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityGroupIdListMemberString', ], 'max' => 50, 'min' => 0, ], 'SecurityGroupIdListMemberString' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'SelfGrantStatus' => [ 'type' => 'string', 'enum' => [ 'GRANT_PENDING', 'REVOKE_PENDING', 'GRANT_IN_PROGRESS', 'REVOKE_IN_PROGRESS', 'GRANTED', 'GRANT_FAILED', 'REVOKE_FAILED', ], ], 'SelfGrantStatusDetail' => [ 'type' => 'structure', 'required' => [ 'databaseName', 'status', ], 'members' => [ 'databaseName' => [ 'shape' => 'SelfGrantStatusDetailDatabaseNameString', ], 'schemaName' => [ 'shape' => 'SelfGrantStatusDetailSchemaNameString', ], 'status' => [ 'shape' => 'SelfGrantStatus', ], 'failureCause' => [ 'shape' => 'String', ], ], ], 'SelfGrantStatusDetailDatabaseNameString' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'SelfGrantStatusDetailSchemaNameString' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'SelfGrantStatusDetails' => [ 'type' => 'list', 'member' => [ 'shape' => 'SelfGrantStatusDetail', ], ], 'SelfGrantStatusOutput' => [ 'type' => 'structure', 'members' => [ 'glueSelfGrantStatus' => [ 'shape' => 'GlueSelfGrantStatusOutput', ], 'redshiftSelfGrantStatus' => [ 'shape' => 'RedshiftSelfGrantStatusOutput', ], ], 'union' => true, ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'ShortDescription' => [ 'type' => 'string', 'max' => 1024, 'min' => 0, 'sensitive' => true, ], 'SingleSignOn' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'AuthType', ], 'userAssignment' => [ 'shape' => 'UserAssignment', ], 'idcInstanceArn' => [ 'shape' => 'SingleSignOnIdcInstanceArnString', ], ], ], 'SingleSignOnIdcInstanceArnString' => [ 'type' => 'string', 'pattern' => '.*arn:(aws|aws-us-gov|aws-cn|aws-iso|aws-iso-b):sso:::instance/(sso)?ins-[a-zA-Z0-9-.]{16}.*', ], 'Smithy' => [ 'type' => 'string', 'max' => 100000, 'min' => 1, ], 'SortFieldAccountPool' => [ 'type' => 'string', 'enum' => [ 'NAME', ], ], 'SortFieldConnection' => [ 'type' => 'string', 'enum' => [ 'NAME', ], ], 'SortFieldProject' => [ 'type' => 'string', 'enum' => [ 'NAME', ], ], 'SortKey' => [ 'type' => 'string', 'enum' => [ 'CREATED_AT', 'UPDATED_AT', ], ], 'SortOrder' => [ 'type' => 'string', 'enum' => [ 'ASCENDING', 'DESCENDING', ], ], 'SparkEmrPropertiesInput' => [ 'type' => 'structure', 'members' => [ 'computeArn' => [ 'shape' => 'SparkEmrPropertiesInputComputeArnString', ], 'instanceProfileArn' => [ 'shape' => 'SparkEmrPropertiesInputInstanceProfileArnString', ], 'javaVirtualEnv' => [ 'shape' => 'SparkEmrPropertiesInputJavaVirtualEnvString', ], 'logUri' => [ 'shape' => 'SparkEmrPropertiesInputLogUriString', ], 'pythonVirtualEnv' => [ 'shape' => 'SparkEmrPropertiesInputPythonVirtualEnvString', ], 'runtimeRole' => [ 'shape' => 'SparkEmrPropertiesInputRuntimeRoleString', ], 'trustedCertificatesS3Uri' => [ 'shape' => 'SparkEmrPropertiesInputTrustedCertificatesS3UriString', ], 'managedEndpointArn' => [ 'shape' => 'SparkEmrPropertiesInputManagedEndpointArnString', ], ], ], 'SparkEmrPropertiesInputComputeArnString' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws(-(cn|us-gov|iso(-[bef])?))?:(elasticmapreduce|emr-serverless|emr-containers):.*', ], 'SparkEmrPropertiesInputInstanceProfileArnString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkEmrPropertiesInputJavaVirtualEnvString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkEmrPropertiesInputLogUriString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkEmrPropertiesInputManagedEndpointArnString' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, ], 'SparkEmrPropertiesInputPythonVirtualEnvString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkEmrPropertiesInputRuntimeRoleString' => [ 'type' => 'string', 'pattern' => 'arn:aws[^:]*:iam::\\d{12}:(role|role/service-role)/[\\w+=,.@-]*', ], 'SparkEmrPropertiesInputTrustedCertificatesS3UriString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkEmrPropertiesOutput' => [ 'type' => 'structure', 'members' => [ 'computeArn' => [ 'shape' => 'String', ], 'credentials' => [ 'shape' => 'UsernamePassword', ], 'credentialsExpiration' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'governanceType' => [ 'shape' => 'GovernanceType', ], 'instanceProfileArn' => [ 'shape' => 'String', ], 'javaVirtualEnv' => [ 'shape' => 'String', ], 'livyEndpoint' => [ 'shape' => 'String', ], 'logUri' => [ 'shape' => 'String', ], 'pythonVirtualEnv' => [ 'shape' => 'String', ], 'runtimeRole' => [ 'shape' => 'String', ], 'trustedCertificatesS3Uri' => [ 'shape' => 'String', ], 'certificateData' => [ 'shape' => 'String', ], 'managedEndpointArn' => [ 'shape' => 'SparkEmrPropertiesOutputManagedEndpointArnString', ], 'managedEndpointCredentials' => [ 'shape' => 'ManagedEndpointCredentials', ], ], ], 'SparkEmrPropertiesOutputManagedEndpointArnString' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, ], 'SparkEmrPropertiesPatch' => [ 'type' => 'structure', 'members' => [ 'computeArn' => [ 'shape' => 'SparkEmrPropertiesPatchComputeArnString', ], 'instanceProfileArn' => [ 'shape' => 'SparkEmrPropertiesPatchInstanceProfileArnString', ], 'javaVirtualEnv' => [ 'shape' => 'SparkEmrPropertiesPatchJavaVirtualEnvString', ], 'logUri' => [ 'shape' => 'SparkEmrPropertiesPatchLogUriString', ], 'pythonVirtualEnv' => [ 'shape' => 'SparkEmrPropertiesPatchPythonVirtualEnvString', ], 'runtimeRole' => [ 'shape' => 'SparkEmrPropertiesPatchRuntimeRoleString', ], 'trustedCertificatesS3Uri' => [ 'shape' => 'SparkEmrPropertiesPatchTrustedCertificatesS3UriString', ], 'managedEndpointArn' => [ 'shape' => 'SparkEmrPropertiesPatchManagedEndpointArnString', ], ], ], 'SparkEmrPropertiesPatchComputeArnString' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:aws(-(cn|us-gov|iso(-[bef])?))?:(elasticmapreduce|emr-serverless|emr-containers):.*', ], 'SparkEmrPropertiesPatchInstanceProfileArnString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkEmrPropertiesPatchJavaVirtualEnvString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkEmrPropertiesPatchLogUriString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkEmrPropertiesPatchManagedEndpointArnString' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, ], 'SparkEmrPropertiesPatchPythonVirtualEnvString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkEmrPropertiesPatchRuntimeRoleString' => [ 'type' => 'string', 'pattern' => 'arn:aws[^:]*:iam::\\d{12}:(role|role/service-role)/[\\w+=,.@-]*', ], 'SparkEmrPropertiesPatchTrustedCertificatesS3UriString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkGlueArgs' => [ 'type' => 'structure', 'members' => [ 'connection' => [ 'shape' => 'String', ], ], ], 'SparkGluePropertiesInput' => [ 'type' => 'structure', 'members' => [ 'additionalArgs' => [ 'shape' => 'SparkGlueArgs', ], 'glueConnectionName' => [ 'shape' => 'SparkGluePropertiesInputGlueConnectionNameString', ], 'glueVersion' => [ 'shape' => 'SparkGluePropertiesInputGlueVersionString', ], 'idleTimeout' => [ 'shape' => 'Integer', ], 'javaVirtualEnv' => [ 'shape' => 'SparkGluePropertiesInputJavaVirtualEnvString', ], 'numberOfWorkers' => [ 'shape' => 'Integer', ], 'pythonVirtualEnv' => [ 'shape' => 'SparkGluePropertiesInputPythonVirtualEnvString', ], 'workerType' => [ 'shape' => 'SparkGluePropertiesInputWorkerTypeString', ], ], ], 'SparkGluePropertiesInputGlueConnectionNameString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkGluePropertiesInputGlueVersionString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkGluePropertiesInputJavaVirtualEnvString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkGluePropertiesInputPythonVirtualEnvString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkGluePropertiesInputWorkerTypeString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'SparkGluePropertiesOutput' => [ 'type' => 'structure', 'members' => [ 'additionalArgs' => [ 'shape' => 'SparkGlueArgs', ], 'glueConnectionName' => [ 'shape' => 'String', ], 'glueVersion' => [ 'shape' => 'String', ], 'idleTimeout' => [ 'shape' => 'Integer', ], 'javaVirtualEnv' => [ 'shape' => 'String', ], 'numberOfWorkers' => [ 'shape' => 'Integer', ], 'pythonVirtualEnv' => [ 'shape' => 'String', ], 'workerType' => [ 'shape' => 'String', ], ], ], 'SsoUserProfileDetails' => [ 'type' => 'structure', 'members' => [ 'username' => [ 'shape' => 'UserProfileName', ], 'firstName' => [ 'shape' => 'FirstName', ], 'lastName' => [ 'shape' => 'LastName', ], ], ], 'StartDataSourceRunInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'dataSourceIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'dataSourceIdentifier' => [ 'shape' => 'DataSourceId', 'location' => 'uri', 'locationName' => 'dataSourceIdentifier', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], ], ], 'StartDataSourceRunOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'dataSourceId', 'id', 'projectId', 'status', 'type', 'createdAt', 'updatedAt', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'dataSourceId' => [ 'shape' => 'DataSourceId', ], 'id' => [ 'shape' => 'DataSourceRunId', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'status' => [ 'shape' => 'DataSourceRunStatus', ], 'type' => [ 'shape' => 'DataSourceRunType', ], 'dataSourceConfigurationSnapshot' => [ 'shape' => 'String', ], 'runStatisticsForAssets' => [ 'shape' => 'RunStatisticsForAssets', ], 'errorMessage' => [ 'shape' => 'DataSourceErrorMessage', ], 'createdAt' => [ 'shape' => 'DateTime', ], 'updatedAt' => [ 'shape' => 'DateTime', ], 'startedAt' => [ 'shape' => 'DateTime', ], 'stoppedAt' => [ 'shape' => 'DateTime', ], ], ], 'StartMetadataGenerationRunInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'target', 'owningProjectIdentifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'type' => [ 'shape' => 'MetadataGenerationRunType', 'deprecated' => true, 'deprecatedMessage' => 'This field is going to be deprecated, please use the \'types\' field to provide the MetadataGenerationRun types', 'deprecatedSince' => '2025-11-21', ], 'types' => [ 'shape' => 'MetadataGenerationRunTypes', ], 'target' => [ 'shape' => 'MetadataGenerationRunTarget', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'owningProjectIdentifier' => [ 'shape' => 'ProjectId', ], ], ], 'StartMetadataGenerationRunOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'MetadataGenerationRunIdentifier', ], 'status' => [ 'shape' => 'MetadataGenerationRunStatus', ], 'type' => [ 'shape' => 'MetadataGenerationRunType', 'deprecated' => true, 'deprecatedMessage' => 'This field is going to be deprecated, please use the \'types\' field to provide the MetadataGenerationRun types', 'deprecatedSince' => '2025-11-21', ], 'types' => [ 'shape' => 'MetadataGenerationRunTypes', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], ], ], 'Status' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'String' => [ 'type' => 'string', ], 'StringList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'SubnetId' => [ 'type' => 'string', 'max' => 32, 'min' => 0, 'pattern' => 'subnet-[a-z0-9]+', ], 'SubnetIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubnetId', ], 'max' => 50, 'min' => 1, ], 'SubscribedAsset' => [ 'type' => 'structure', 'required' => [ 'assetId', 'assetRevision', 'status', ], 'members' => [ 'assetId' => [ 'shape' => 'AssetId', ], 'assetRevision' => [ 'shape' => 'Revision', ], 'status' => [ 'shape' => 'SubscriptionGrantStatus', ], 'targetName' => [ 'shape' => 'String', ], 'failureCause' => [ 'shape' => 'FailureCause', ], 'grantedTimestamp' => [ 'shape' => 'Timestamp', ], 'failureTimestamp' => [ 'shape' => 'Timestamp', ], 'assetScope' => [ 'shape' => 'AssetScope', ], 'permissions' => [ 'shape' => 'Permissions', ], ], ], 'SubscribedAssetListing' => [ 'type' => 'structure', 'members' => [ 'entityId' => [ 'shape' => 'AssetId', ], 'entityRevision' => [ 'shape' => 'Revision', ], 'entityType' => [ 'shape' => 'TypeName', ], 'forms' => [ 'shape' => 'Forms', ], 'glossaryTerms' => [ 'shape' => 'DetailedGlossaryTerms', ], 'assetScope' => [ 'shape' => 'AssetScope', ], 'permissions' => [ 'shape' => 'Permissions', ], ], ], 'SubscribedAssets' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedAsset', ], ], 'SubscribedGroup' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'GroupProfileId', ], 'name' => [ 'shape' => 'GroupProfileName', ], ], ], 'SubscribedGroupInput' => [ 'type' => 'structure', 'members' => [ 'identifier' => [ 'shape' => 'GroupProfileId', ], ], ], 'SubscribedIamPrincipal' => [ 'type' => 'structure', 'members' => [ 'principalArn' => [ 'shape' => 'IamPrincipalArn', ], ], ], 'SubscribedIamPrincipalInput' => [ 'type' => 'structure', 'members' => [ 'identifier' => [ 'shape' => 'IamPrincipalArn', ], ], ], 'SubscribedListing' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'description', 'item', 'ownerProjectId', ], 'members' => [ 'id' => [ 'shape' => 'ListingId', ], 'revision' => [ 'shape' => 'Revision', ], 'name' => [ 'shape' => 'ListingName', ], 'description' => [ 'shape' => 'Description', ], 'item' => [ 'shape' => 'SubscribedListingItem', ], 'ownerProjectId' => [ 'shape' => 'ProjectId', ], 'ownerProjectName' => [ 'shape' => 'String', ], ], ], 'SubscribedListingInput' => [ 'type' => 'structure', 'required' => [ 'identifier', ], 'members' => [ 'identifier' => [ 'shape' => 'ListingId', ], ], ], 'SubscribedListingInputs' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedListingInput', ], 'max' => 1, 'min' => 1, ], 'SubscribedListingItem' => [ 'type' => 'structure', 'members' => [ 'assetListing' => [ 'shape' => 'SubscribedAssetListing', ], 'productListing' => [ 'shape' => 'SubscribedProductListing', ], ], 'union' => true, ], 'SubscribedPrincipal' => [ 'type' => 'structure', 'members' => [ 'project' => [ 'shape' => 'SubscribedProject', ], 'user' => [ 'shape' => 'SubscribedUser', ], 'group' => [ 'shape' => 'SubscribedGroup', ], 'iam' => [ 'shape' => 'SubscribedIamPrincipal', ], ], 'union' => true, ], 'SubscribedPrincipalInput' => [ 'type' => 'structure', 'members' => [ 'project' => [ 'shape' => 'SubscribedProjectInput', ], 'user' => [ 'shape' => 'SubscribedUserInput', ], 'group' => [ 'shape' => 'SubscribedGroupInput', ], 'iam' => [ 'shape' => 'SubscribedIamPrincipalInput', ], ], 'union' => true, ], 'SubscribedPrincipalInputs' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedPrincipalInput', ], 'max' => 1, 'min' => 1, ], 'SubscribedProductListing' => [ 'type' => 'structure', 'members' => [ 'entityId' => [ 'shape' => 'AssetId', ], 'entityRevision' => [ 'shape' => 'Revision', ], 'glossaryTerms' => [ 'shape' => 'DetailedGlossaryTerms', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'assetListings' => [ 'shape' => 'AssetInDataProductListingItems', ], ], ], 'SubscribedProject' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'ProjectId', ], 'name' => [ 'shape' => 'ProjectName', ], ], ], 'SubscribedProjectInput' => [ 'type' => 'structure', 'members' => [ 'identifier' => [ 'shape' => 'ProjectId', ], ], ], 'SubscribedUser' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'UserProfileId', ], 'details' => [ 'shape' => 'UserProfileDetails', ], ], ], 'SubscribedUserInput' => [ 'type' => 'structure', 'members' => [ 'identifier' => [ 'shape' => 'UserProfileId', ], ], ], 'SubscriptionGrantCreationMode' => [ 'type' => 'string', 'enum' => [ 'AUTOMATIC', 'MANUAL', ], ], 'SubscriptionGrantId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'SubscriptionGrantOverallStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'IN_PROGRESS', 'GRANT_FAILED', 'REVOKE_FAILED', 'GRANT_AND_REVOKE_FAILED', 'COMPLETED', 'INACCESSIBLE', ], ], 'SubscriptionGrantStatus' => [ 'type' => 'string', 'enum' => [ 'GRANT_PENDING', 'REVOKE_PENDING', 'GRANT_IN_PROGRESS', 'REVOKE_IN_PROGRESS', 'GRANTED', 'REVOKED', 'GRANT_FAILED', 'REVOKE_FAILED', ], ], 'SubscriptionGrantSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'createdAt', 'updatedAt', 'subscriptionTargetId', 'grantedEntity', 'status', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionGrantId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'subscriptionTargetId' => [ 'shape' => 'SubscriptionTargetId', ], 'grantedEntity' => [ 'shape' => 'GrantedEntity', ], 'status' => [ 'shape' => 'SubscriptionGrantOverallStatus', ], 'assets' => [ 'shape' => 'SubscribedAssets', ], 'subscriptionId' => [ 'shape' => 'SubscriptionId', 'deprecated' => true, 'deprecatedMessage' => 'Multiple subscriptions can exist for a single grant', ], ], ], 'SubscriptionGrants' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscriptionGrantSummary', ], ], 'SubscriptionId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'SubscriptionRequestId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'SubscriptionRequestStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'ACCEPTED', 'REJECTED', ], ], 'SubscriptionRequestSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'status', 'createdAt', 'updatedAt', 'requestReason', 'subscribedPrincipals', 'subscribedListings', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionRequestId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'status' => [ 'shape' => 'SubscriptionRequestStatus', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'requestReason' => [ 'shape' => 'RequestReason', ], 'subscribedPrincipals' => [ 'shape' => 'SubscriptionRequestSummarySubscribedPrincipalsList', ], 'subscribedListings' => [ 'shape' => 'SubscriptionRequestSummarySubscribedListingsList', ], 'reviewerId' => [ 'shape' => 'String', ], 'decisionComment' => [ 'shape' => 'DecisionComment', ], 'existingSubscriptionId' => [ 'shape' => 'SubscriptionId', ], 'metadataFormsSummary' => [ 'shape' => 'MetadataFormsSummary', ], ], ], 'SubscriptionRequestSummarySubscribedListingsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedListing', ], 'max' => 1, 'min' => 1, ], 'SubscriptionRequestSummarySubscribedPrincipalsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedPrincipal', ], 'max' => 1, 'min' => 1, ], 'SubscriptionRequests' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscriptionRequestSummary', ], ], 'SubscriptionStatus' => [ 'type' => 'string', 'enum' => [ 'APPROVED', 'REVOKED', 'CANCELLED', ], ], 'SubscriptionSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'status', 'createdAt', 'updatedAt', 'subscribedPrincipal', 'subscribedListing', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'status' => [ 'shape' => 'SubscriptionStatus', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'subscribedPrincipal' => [ 'shape' => 'SubscribedPrincipal', ], 'subscribedListing' => [ 'shape' => 'SubscribedListing', ], 'subscriptionRequestId' => [ 'shape' => 'SubscriptionRequestId', ], 'retainPermissions' => [ 'shape' => 'Boolean', ], ], ], 'SubscriptionTargetForm' => [ 'type' => 'structure', 'required' => [ 'formName', 'content', ], 'members' => [ 'formName' => [ 'shape' => 'FormName', ], 'content' => [ 'shape' => 'String', ], ], ], 'SubscriptionTargetForms' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscriptionTargetForm', ], ], 'SubscriptionTargetId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'SubscriptionTargetName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'sensitive' => true, ], 'SubscriptionTargetSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'authorizedPrincipals', 'domainId', 'projectId', 'environmentId', 'name', 'type', 'createdBy', 'createdAt', 'applicableAssetTypes', 'subscriptionTargetConfig', 'provider', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionTargetId', ], 'authorizedPrincipals' => [ 'shape' => 'AuthorizedPrincipalIdentifiers', ], 'domainId' => [ 'shape' => 'DomainId', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'name' => [ 'shape' => 'SubscriptionTargetName', ], 'type' => [ 'shape' => 'String', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'manageAccessRole' => [ 'shape' => 'IamRoleArn', ], 'applicableAssetTypes' => [ 'shape' => 'ApplicableAssetTypes', ], 'subscriptionTargetConfig' => [ 'shape' => 'SubscriptionTargetForms', ], 'provider' => [ 'shape' => 'String', ], 'subscriptionGrantCreationMode' => [ 'shape' => 'SubscriptionGrantCreationMode', ], ], ], 'SubscriptionTargets' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscriptionTargetSummary', ], ], 'Subscriptions' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscriptionSummary', ], ], 'SyntheticTimestamp_date_time' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[\\w \\.:/=+@-]+', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'Tags', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '[\\w \\.:/=+@-]*', ], 'Tags' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], ], 'TargetEntityType' => [ 'type' => 'string', 'enum' => [ 'DOMAIN_UNIT', 'ENVIRONMENT_BLUEPRINT_CONFIGURATION', 'ENVIRONMENT_PROFILE', 'ASSET_TYPE', ], ], 'TaskId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'TaskStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'INACTIVE', ], ], 'TermRelations' => [ 'type' => 'structure', 'members' => [ 'isA' => [ 'shape' => 'TermRelationsIsAList', ], 'classifies' => [ 'shape' => 'TermRelationsClassifiesList', ], ], ], 'TermRelationsClassifiesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GlossaryTermId', ], 'max' => 10, 'min' => 1, ], 'TermRelationsIsAList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GlossaryTermId', ], 'max' => 10, 'min' => 1, ], 'TextMatchItem' => [ 'type' => 'structure', 'members' => [ 'attribute' => [ 'shape' => 'Attribute', ], 'text' => [ 'shape' => 'String', ], 'matchOffsets' => [ 'shape' => 'MatchOffsets', ], ], ], 'TextMatches' => [ 'type' => 'list', 'member' => [ 'shape' => 'TextMatchItem', ], ], 'ThrottlingException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, 'retryable' => [ 'throttling' => false, ], ], 'TimeSeriesDataPointFormInput' => [ 'type' => 'structure', 'required' => [ 'formName', 'typeIdentifier', 'timestamp', ], 'members' => [ 'formName' => [ 'shape' => 'TimeSeriesFormName', ], 'typeIdentifier' => [ 'shape' => 'FormTypeIdentifier', ], 'typeRevision' => [ 'shape' => 'Revision', ], 'timestamp' => [ 'shape' => 'Timestamp', ], 'content' => [ 'shape' => 'TimeSeriesDataPointFormInputContentString', ], ], ], 'TimeSeriesDataPointFormInputContentString' => [ 'type' => 'string', 'max' => 500000, 'min' => 0, ], 'TimeSeriesDataPointFormInputList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TimeSeriesDataPointFormInput', ], ], 'TimeSeriesDataPointFormOutput' => [ 'type' => 'structure', 'required' => [ 'formName', 'typeIdentifier', 'timestamp', ], 'members' => [ 'formName' => [ 'shape' => 'TimeSeriesFormName', ], 'typeIdentifier' => [ 'shape' => 'FormTypeIdentifier', ], 'typeRevision' => [ 'shape' => 'Revision', ], 'timestamp' => [ 'shape' => 'Timestamp', ], 'content' => [ 'shape' => 'TimeSeriesDataPointFormOutputContentString', ], 'id' => [ 'shape' => 'DataPointIdentifier', ], ], ], 'TimeSeriesDataPointFormOutputContentString' => [ 'type' => 'string', 'max' => 500000, 'min' => 0, ], 'TimeSeriesDataPointFormOutputList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TimeSeriesDataPointFormOutput', ], ], 'TimeSeriesDataPointIdentifier' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9_-]{1,36}', ], 'TimeSeriesDataPointSummaryFormOutput' => [ 'type' => 'structure', 'required' => [ 'formName', 'typeIdentifier', 'timestamp', ], 'members' => [ 'formName' => [ 'shape' => 'TimeSeriesFormName', ], 'typeIdentifier' => [ 'shape' => 'FormTypeIdentifier', ], 'typeRevision' => [ 'shape' => 'Revision', ], 'timestamp' => [ 'shape' => 'Timestamp', ], 'contentSummary' => [ 'shape' => 'TimeSeriesDataPointSummaryFormOutputContentSummaryString', ], 'id' => [ 'shape' => 'DataPointIdentifier', ], ], ], 'TimeSeriesDataPointSummaryFormOutputContentSummaryString' => [ 'type' => 'string', 'max' => 20000, 'min' => 0, ], 'TimeSeriesDataPointSummaryFormOutputList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TimeSeriesDataPointSummaryFormOutput', ], ], 'TimeSeriesEntityType' => [ 'type' => 'string', 'enum' => [ 'ASSET', 'LISTING', ], ], 'TimeSeriesFormName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'Timestamp' => [ 'type' => 'timestamp', ], 'Timezone' => [ 'type' => 'string', 'enum' => [ 'UTC', 'AFRICA_JOHANNESBURG', 'AMERICA_MONTREAL', 'AMERICA_SAO_PAULO', 'ASIA_BAHRAIN', 'ASIA_BANGKOK', 'ASIA_CALCUTTA', 'ASIA_DUBAI', 'ASIA_HONG_KONG', 'ASIA_JAKARTA', 'ASIA_KUALA_LUMPUR', 'ASIA_SEOUL', 'ASIA_SHANGHAI', 'ASIA_SINGAPORE', 'ASIA_TAIPEI', 'ASIA_TOKYO', 'AUSTRALIA_MELBOURNE', 'AUSTRALIA_SYDNEY', 'CANADA_CENTRAL', 'CET', 'CST6CDT', 'ETC_GMT', 'ETC_GMT0', 'ETC_GMT_ADD_0', 'ETC_GMT_ADD_1', 'ETC_GMT_ADD_10', 'ETC_GMT_ADD_11', 'ETC_GMT_ADD_12', 'ETC_GMT_ADD_2', 'ETC_GMT_ADD_3', 'ETC_GMT_ADD_4', 'ETC_GMT_ADD_5', 'ETC_GMT_ADD_6', 'ETC_GMT_ADD_7', 'ETC_GMT_ADD_8', 'ETC_GMT_ADD_9', 'ETC_GMT_NEG_0', 'ETC_GMT_NEG_1', 'ETC_GMT_NEG_10', 'ETC_GMT_NEG_11', 'ETC_GMT_NEG_12', 'ETC_GMT_NEG_13', 'ETC_GMT_NEG_14', 'ETC_GMT_NEG_2', 'ETC_GMT_NEG_3', 'ETC_GMT_NEG_4', 'ETC_GMT_NEG_5', 'ETC_GMT_NEG_6', 'ETC_GMT_NEG_7', 'ETC_GMT_NEG_8', 'ETC_GMT_NEG_9', 'EUROPE_DUBLIN', 'EUROPE_LONDON', 'EUROPE_PARIS', 'EUROPE_STOCKHOLM', 'EUROPE_ZURICH', 'ISRAEL', 'MEXICO_GENERAL', 'MST7MDT', 'PACIFIC_AUCKLAND', 'US_CENTRAL', 'US_EASTERN', 'US_MOUNTAIN', 'US_PACIFIC', ], ], 'Title' => [ 'type' => 'string', 'max' => 1000, 'min' => 0, 'sensitive' => true, ], 'TokenUrlParametersMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TokenUrlParametersMapKeyString', ], 'value' => [ 'shape' => 'TokenUrlParametersMapValueString', ], ], 'TokenUrlParametersMapKeyString' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'TokenUrlParametersMapValueString' => [ 'type' => 'string', 'max' => 512, 'min' => 1, ], 'Topic' => [ 'type' => 'structure', 'required' => [ 'subject', 'resource', 'role', ], 'members' => [ 'subject' => [ 'shape' => 'String', ], 'resource' => [ 'shape' => 'NotificationResource', ], 'role' => [ 'shape' => 'NotificationRole', ], ], ], 'TrackingAssetArns' => [ 'type' => 'list', 'member' => [ 'shape' => 'SageMakerResourceArn', ], 'max' => 500, 'min' => 0, ], 'TrackingAssets' => [ 'type' => 'map', 'key' => [ 'shape' => 'SageMakerAssetType', ], 'value' => [ 'shape' => 'TrackingAssetArns', ], 'max' => 1, 'min' => 1, ], 'TypeName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[^\\.]*.*', ], 'TypesSearchScope' => [ 'type' => 'string', 'enum' => [ 'ASSET_TYPE', 'FORM_TYPE', 'LINEAGE_NODE_TYPE', ], ], 'UnauthorizedException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 401, 'senderFault' => true, ], 'exception' => true, ], 'Unit' => [ 'type' => 'structure', 'members' => [], ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateAccountPoolInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'AccountPoolId', 'location' => 'uri', 'locationName' => 'identifier', ], 'name' => [ 'shape' => 'AccountPoolName', ], 'description' => [ 'shape' => 'Description', ], 'resolutionStrategy' => [ 'shape' => 'ResolutionStrategy', ], 'accountSource' => [ 'shape' => 'AccountSource', ], ], ], 'UpdateAccountPoolOutput' => [ 'type' => 'structure', 'required' => [ 'accountSource', 'createdBy', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'AccountPoolName', ], 'id' => [ 'shape' => 'AccountPoolId', ], 'description' => [ 'shape' => 'Description', ], 'resolutionStrategy' => [ 'shape' => 'ResolutionStrategy', ], 'accountSource' => [ 'shape' => 'AccountSource', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], ], ], 'UpdateAssetFilterInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'assetIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'assetIdentifier' => [ 'shape' => 'AssetId', 'location' => 'uri', 'locationName' => 'assetIdentifier', ], 'identifier' => [ 'shape' => 'FilterId', 'location' => 'uri', 'locationName' => 'identifier', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'Description', ], 'configuration' => [ 'shape' => 'AssetFilterConfiguration', ], ], ], 'UpdateAssetFilterOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'domainId', 'assetId', 'name', 'configuration', ], 'members' => [ 'id' => [ 'shape' => 'FilterId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'assetId' => [ 'shape' => 'AssetId', ], 'name' => [ 'shape' => 'FilterName', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'FilterStatus', ], 'configuration' => [ 'shape' => 'AssetFilterConfiguration', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'errorMessage' => [ 'shape' => 'String', ], 'effectiveColumnNames' => [ 'shape' => 'ColumnNameList', ], 'effectiveRowFilter' => [ 'shape' => 'String', ], ], ], 'UpdateConnectionInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'ConnectionId', 'location' => 'uri', 'locationName' => 'identifier', ], 'description' => [ 'shape' => 'UpdateConnectionInputDescriptionString', ], 'awsLocation' => [ 'shape' => 'AwsLocation', ], 'props' => [ 'shape' => 'ConnectionPropertiesPatch', ], ], ], 'UpdateConnectionInputDescriptionString' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'sensitive' => true, ], 'UpdateConnectionOutput' => [ 'type' => 'structure', 'required' => [ 'connectionId', 'domainId', 'domainUnitId', 'name', 'physicalEndpoints', 'type', ], 'members' => [ 'connectionId' => [ 'shape' => 'ConnectionId', ], 'description' => [ 'shape' => 'Description', ], 'domainId' => [ 'shape' => 'DomainId', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'name' => [ 'shape' => 'ConnectionName', ], 'physicalEndpoints' => [ 'shape' => 'PhysicalEndpoints', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'props' => [ 'shape' => 'ConnectionPropertiesOutput', ], 'type' => [ 'shape' => 'ConnectionType', ], 'scope' => [ 'shape' => 'ConnectionScope', ], ], ], 'UpdateDataSourceInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'DataSourceId', 'location' => 'uri', 'locationName' => 'identifier', ], 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'enableSetting' => [ 'shape' => 'EnableSetting', ], 'publishOnImport' => [ 'shape' => 'Boolean', ], 'assetFormsInput' => [ 'shape' => 'FormInputList', ], 'schedule' => [ 'shape' => 'ScheduleConfiguration', ], 'configuration' => [ 'shape' => 'DataSourceConfigurationInput', ], 'recommendation' => [ 'shape' => 'RecommendationConfiguration', ], 'retainPermissionsOnRevokeFailure' => [ 'shape' => 'Boolean', ], ], ], 'UpdateDataSourceOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'domainId', 'projectId', ], 'members' => [ 'id' => [ 'shape' => 'DataSourceId', ], 'status' => [ 'shape' => 'DataSourceStatus', ], 'type' => [ 'shape' => 'DataSourceType', ], 'name' => [ 'shape' => 'Name', ], 'description' => [ 'shape' => 'Description', ], 'domainId' => [ 'shape' => 'DomainId', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'connectionId' => [ 'shape' => 'String', ], 'configuration' => [ 'shape' => 'DataSourceConfigurationOutput', ], 'recommendation' => [ 'shape' => 'RecommendationConfiguration', ], 'enableSetting' => [ 'shape' => 'EnableSetting', ], 'publishOnImport' => [ 'shape' => 'Boolean', ], 'assetFormsOutput' => [ 'shape' => 'FormOutputList', ], 'schedule' => [ 'shape' => 'ScheduleConfiguration', ], 'lastRunStatus' => [ 'shape' => 'DataSourceRunStatus', ], 'lastRunAt' => [ 'shape' => 'DateTime', ], 'lastRunErrorMessage' => [ 'shape' => 'DataSourceErrorMessage', ], 'errorMessage' => [ 'shape' => 'DataSourceErrorMessage', ], 'createdAt' => [ 'shape' => 'DateTime', ], 'updatedAt' => [ 'shape' => 'DateTime', ], 'selfGrantStatus' => [ 'shape' => 'SelfGrantStatusOutput', ], 'retainPermissionsOnRevokeFailure' => [ 'shape' => 'Boolean', ], ], ], 'UpdateDomainInput' => [ 'type' => 'structure', 'required' => [ 'identifier', ], 'members' => [ 'identifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'identifier', ], 'description' => [ 'shape' => 'String', ], 'singleSignOn' => [ 'shape' => 'SingleSignOn', ], 'domainExecutionRole' => [ 'shape' => 'RoleArn', ], 'serviceRole' => [ 'shape' => 'RoleArn', ], 'name' => [ 'shape' => 'String', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, 'location' => 'querystring', 'locationName' => 'clientToken', ], ], ], 'UpdateDomainOutput' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'DomainId', ], 'rootDomainUnitId' => [ 'shape' => 'DomainUnitId', ], 'description' => [ 'shape' => 'String', ], 'singleSignOn' => [ 'shape' => 'SingleSignOn', ], 'domainExecutionRole' => [ 'shape' => 'RoleArn', ], 'serviceRole' => [ 'shape' => 'RoleArn', ], 'name' => [ 'shape' => 'String', ], 'lastUpdatedAt' => [ 'shape' => 'UpdatedAt', ], ], ], 'UpdateDomainUnitInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'DomainUnitId', 'location' => 'uri', 'locationName' => 'identifier', ], 'description' => [ 'shape' => 'DomainUnitDescription', ], 'name' => [ 'shape' => 'DomainUnitName', ], ], ], 'UpdateDomainUnitOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'domainId', 'name', 'owners', ], 'members' => [ 'id' => [ 'shape' => 'DomainUnitId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'name' => [ 'shape' => 'DomainUnitName', ], 'owners' => [ 'shape' => 'DomainUnitOwners', ], 'description' => [ 'shape' => 'DomainUnitDescription', ], 'parentDomainUnitId' => [ 'shape' => 'DomainUnitId', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'lastUpdatedAt' => [ 'shape' => 'UpdatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'lastUpdatedBy' => [ 'shape' => 'UpdatedBy', ], ], ], 'UpdateEnvironmentActionInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'environmentIdentifier', ], 'identifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'identifier', ], 'parameters' => [ 'shape' => 'ActionParameters', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], ], ], 'UpdateEnvironmentActionOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'environmentId', 'id', 'name', 'parameters', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'id' => [ 'shape' => 'EnvironmentActionId', ], 'name' => [ 'shape' => 'String', ], 'parameters' => [ 'shape' => 'ActionParameters', ], 'description' => [ 'shape' => 'String', ], ], ], 'UpdateEnvironmentBlueprintInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'EnvironmentBlueprintId', 'location' => 'uri', 'locationName' => 'identifier', ], 'description' => [ 'shape' => 'String', ], 'provisioningProperties' => [ 'shape' => 'ProvisioningProperties', ], 'userParameters' => [ 'shape' => 'CustomParameterList', ], ], ], 'UpdateEnvironmentBlueprintOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'provider', 'provisioningProperties', ], 'members' => [ 'id' => [ 'shape' => 'EnvironmentBlueprintId', ], 'name' => [ 'shape' => 'EnvironmentBlueprintName', ], 'description' => [ 'shape' => 'Description', ], 'provider' => [ 'shape' => 'String', ], 'provisioningProperties' => [ 'shape' => 'ProvisioningProperties', ], 'deploymentProperties' => [ 'shape' => 'DeploymentProperties', ], 'userParameters' => [ 'shape' => 'CustomParameterList', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], ], ], 'UpdateEnvironmentInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'identifier', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'blueprintVersion' => [ 'shape' => 'String', ], 'userParameters' => [ 'shape' => 'EnvironmentParametersList', ], ], ], 'UpdateEnvironmentOutput' => [ 'type' => 'structure', 'required' => [ 'projectId', 'domainId', 'createdBy', 'name', 'provider', ], 'members' => [ 'projectId' => [ 'shape' => 'ProjectId', ], 'id' => [ 'shape' => 'EnvironmentId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'createdBy' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'name' => [ 'shape' => 'EnvironmentName', ], 'description' => [ 'shape' => 'Description', ], 'environmentProfileId' => [ 'shape' => 'EnvironmentProfileId', ], 'awsAccountId' => [ 'shape' => 'AwsAccountId', ], 'awsAccountRegion' => [ 'shape' => 'AwsRegion', ], 'provider' => [ 'shape' => 'String', ], 'provisionedResources' => [ 'shape' => 'ResourceList', ], 'status' => [ 'shape' => 'EnvironmentStatus', ], 'environmentActions' => [ 'shape' => 'EnvironmentActionList', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'userParameters' => [ 'shape' => 'CustomParameterList', ], 'lastDeployment' => [ 'shape' => 'Deployment', ], 'provisioningProperties' => [ 'shape' => 'ProvisioningProperties', ], 'deploymentProperties' => [ 'shape' => 'DeploymentProperties', ], 'environmentBlueprintId' => [ 'shape' => 'EnvironmentBlueprintId', ], 'environmentConfigurationId' => [ 'shape' => 'EnvironmentConfigurationId', ], ], ], 'UpdateEnvironmentProfileInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'EnvironmentProfileId', 'location' => 'uri', 'locationName' => 'identifier', ], 'name' => [ 'shape' => 'EnvironmentProfileName', ], 'description' => [ 'shape' => 'String', ], 'userParameters' => [ 'shape' => 'EnvironmentParametersList', ], 'awsAccountId' => [ 'shape' => 'AwsAccountId', ], 'awsAccountRegion' => [ 'shape' => 'AwsRegion', ], ], ], 'UpdateEnvironmentProfileOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'domainId', 'createdBy', 'name', 'environmentBlueprintId', ], 'members' => [ 'id' => [ 'shape' => 'EnvironmentProfileId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'awsAccountId' => [ 'shape' => 'AwsAccountId', ], 'awsAccountRegion' => [ 'shape' => 'AwsRegion', ], 'createdBy' => [ 'shape' => 'String', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'updatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'name' => [ 'shape' => 'EnvironmentProfileName', ], 'description' => [ 'shape' => 'Description', ], 'environmentBlueprintId' => [ 'shape' => 'EnvironmentBlueprintId', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'userParameters' => [ 'shape' => 'CustomParameterList', ], ], ], 'UpdateGlossaryInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'GlossaryId', 'location' => 'uri', 'locationName' => 'identifier', ], 'name' => [ 'shape' => 'GlossaryName', ], 'description' => [ 'shape' => 'GlossaryDescription', ], 'status' => [ 'shape' => 'GlossaryStatus', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'UpdateGlossaryOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'name', 'owningProjectId', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'GlossaryId', ], 'name' => [ 'shape' => 'GlossaryName', ], 'owningProjectId' => [ 'shape' => 'ProjectId', ], 'description' => [ 'shape' => 'GlossaryDescription', ], 'status' => [ 'shape' => 'GlossaryStatus', ], 'usageRestrictions' => [ 'shape' => 'GlossaryUsageRestrictions', ], ], ], 'UpdateGlossaryTermInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'glossaryIdentifier' => [ 'shape' => 'GlossaryTermId', ], 'identifier' => [ 'shape' => 'GlossaryTermId', 'location' => 'uri', 'locationName' => 'identifier', ], 'name' => [ 'shape' => 'GlossaryTermName', ], 'shortDescription' => [ 'shape' => 'ShortDescription', ], 'longDescription' => [ 'shape' => 'LongDescription', ], 'termRelations' => [ 'shape' => 'TermRelations', ], 'status' => [ 'shape' => 'GlossaryTermStatus', ], ], ], 'UpdateGlossaryTermOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'domainId', 'glossaryId', 'name', 'status', ], 'members' => [ 'id' => [ 'shape' => 'GlossaryTermId', ], 'domainId' => [ 'shape' => 'DomainId', ], 'glossaryId' => [ 'shape' => 'GlossaryId', ], 'name' => [ 'shape' => 'GlossaryTermName', ], 'status' => [ 'shape' => 'GlossaryTermStatus', ], 'shortDescription' => [ 'shape' => 'ShortDescription', ], 'longDescription' => [ 'shape' => 'LongDescription', ], 'termRelations' => [ 'shape' => 'TermRelations', ], 'usageRestrictions' => [ 'shape' => 'GlossaryUsageRestrictions', ], ], ], 'UpdateGroupProfileInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'groupIdentifier', 'status', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'groupIdentifier' => [ 'shape' => 'GroupIdentifier', 'location' => 'uri', 'locationName' => 'groupIdentifier', ], 'status' => [ 'shape' => 'GroupProfileStatus', ], ], ], 'UpdateGroupProfileOutput' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'GroupProfileId', ], 'status' => [ 'shape' => 'GroupProfileStatus', ], 'groupName' => [ 'shape' => 'GroupProfileName', ], ], ], 'UpdateProjectInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'ProjectId', 'location' => 'uri', 'locationName' => 'identifier', ], 'name' => [ 'shape' => 'ProjectName', ], 'description' => [ 'shape' => 'Description', ], 'resourceTags' => [ 'shape' => 'UpdateProjectInputResourceTagsMap', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], 'environmentDeploymentDetails' => [ 'shape' => 'EnvironmentDeploymentDetails', ], 'userParameters' => [ 'shape' => 'EnvironmentConfigurationUserParametersList', ], 'projectProfileVersion' => [ 'shape' => 'String', ], ], ], 'UpdateProjectInputResourceTagsMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 25, 'min' => 0, ], 'UpdateProjectOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'name', 'createdBy', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'ProjectId', ], 'name' => [ 'shape' => 'ProjectName', ], 'description' => [ 'shape' => 'Description', ], 'projectStatus' => [ 'shape' => 'ProjectStatus', ], 'failureReasons' => [ 'shape' => 'FailureReasons', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'resourceTags' => [ 'shape' => 'ResourceTags', ], 'glossaryTerms' => [ 'shape' => 'GlossaryTerms', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], 'projectProfileId' => [ 'shape' => 'ProjectProfileId', ], 'userParameters' => [ 'shape' => 'EnvironmentConfigurationUserParametersList', ], 'environmentDeploymentDetails' => [ 'shape' => 'EnvironmentDeploymentDetails', ], ], ], 'UpdateProjectProfileInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'ProjectProfileId', 'location' => 'uri', 'locationName' => 'identifier', ], 'name' => [ 'shape' => 'ProjectProfileName', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'Status', ], 'projectResourceTags' => [ 'shape' => 'ProjectResourceTagParameters', ], 'allowCustomProjectResourceTags' => [ 'shape' => 'Boolean', ], 'projectResourceTagsDescription' => [ 'shape' => 'Description', ], 'environmentConfigurations' => [ 'shape' => 'EnvironmentConfigurationsList', ], 'domainUnitIdentifier' => [ 'shape' => 'DomainUnitId', ], ], ], 'UpdateProjectProfileOutput' => [ 'type' => 'structure', 'required' => [ 'domainId', 'id', 'name', 'createdBy', ], 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'ProjectProfileId', ], 'name' => [ 'shape' => 'ProjectProfileName', ], 'description' => [ 'shape' => 'Description', ], 'status' => [ 'shape' => 'Status', ], 'projectResourceTags' => [ 'shape' => 'ProjectResourceTagParameters', ], 'allowCustomProjectResourceTags' => [ 'shape' => 'Boolean', ], 'projectResourceTagsDescription' => [ 'shape' => 'Description', ], 'environmentConfigurations' => [ 'shape' => 'EnvironmentConfigurationsList', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'createdAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'lastUpdatedAt' => [ 'shape' => 'SyntheticTimestamp_date_time', ], 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], ], ], 'UpdateRootDomainUnitOwnerInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'currentOwner', 'newOwner', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'currentOwner' => [ 'shape' => 'UserIdentifier', ], 'newOwner' => [ 'shape' => 'String', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'UpdateRootDomainUnitOwnerOutput' => [ 'type' => 'structure', 'members' => [], ], 'UpdateRuleInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'RuleId', 'location' => 'uri', 'locationName' => 'identifier', ], 'name' => [ 'shape' => 'RuleName', ], 'description' => [ 'shape' => 'Description', ], 'scope' => [ 'shape' => 'RuleScope', ], 'detail' => [ 'shape' => 'RuleDetail', ], 'includeChildDomainUnits' => [ 'shape' => 'Boolean', ], ], ], 'UpdateRuleOutput' => [ 'type' => 'structure', 'required' => [ 'identifier', 'revision', 'name', 'ruleType', 'target', 'action', 'scope', 'detail', 'createdAt', 'updatedAt', 'createdBy', 'lastUpdatedBy', ], 'members' => [ 'identifier' => [ 'shape' => 'RuleId', ], 'revision' => [ 'shape' => 'Revision', ], 'name' => [ 'shape' => 'RuleName', ], 'ruleType' => [ 'shape' => 'RuleType', ], 'target' => [ 'shape' => 'RuleTarget', ], 'action' => [ 'shape' => 'RuleAction', ], 'scope' => [ 'shape' => 'RuleScope', ], 'detail' => [ 'shape' => 'RuleDetail', ], 'description' => [ 'shape' => 'Description', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'lastUpdatedBy' => [ 'shape' => 'UpdatedBy', ], ], ], 'UpdateSubscriptionGrantStatusInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', 'assetIdentifier', 'status', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'SubscriptionGrantId', 'location' => 'uri', 'locationName' => 'identifier', ], 'assetIdentifier' => [ 'shape' => 'AssetId', 'location' => 'uri', 'locationName' => 'assetIdentifier', ], 'status' => [ 'shape' => 'SubscriptionGrantStatus', ], 'failureCause' => [ 'shape' => 'FailureCause', ], 'targetName' => [ 'shape' => 'String', ], ], ], 'UpdateSubscriptionGrantStatusOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'createdAt', 'updatedAt', 'subscriptionTargetId', 'grantedEntity', 'status', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionGrantId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'subscriptionTargetId' => [ 'shape' => 'SubscriptionTargetId', ], 'grantedEntity' => [ 'shape' => 'GrantedEntity', ], 'status' => [ 'shape' => 'SubscriptionGrantOverallStatus', ], 'assets' => [ 'shape' => 'SubscribedAssets', ], 'subscriptionId' => [ 'shape' => 'SubscriptionId', 'deprecated' => true, 'deprecatedMessage' => 'Multiple subscriptions can exist for a single grant', ], ], ], 'UpdateSubscriptionRequestInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'identifier', 'requestReason', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'identifier' => [ 'shape' => 'SubscriptionRequestId', 'location' => 'uri', 'locationName' => 'identifier', ], 'requestReason' => [ 'shape' => 'RequestReason', ], ], ], 'UpdateSubscriptionRequestOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'createdBy', 'domainId', 'status', 'createdAt', 'updatedAt', 'requestReason', 'subscribedPrincipals', 'subscribedListings', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionRequestId', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'domainId' => [ 'shape' => 'DomainId', ], 'status' => [ 'shape' => 'SubscriptionRequestStatus', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'requestReason' => [ 'shape' => 'RequestReason', ], 'subscribedPrincipals' => [ 'shape' => 'UpdateSubscriptionRequestOutputSubscribedPrincipalsList', ], 'subscribedListings' => [ 'shape' => 'UpdateSubscriptionRequestOutputSubscribedListingsList', ], 'reviewerId' => [ 'shape' => 'String', ], 'decisionComment' => [ 'shape' => 'DecisionComment', ], 'existingSubscriptionId' => [ 'shape' => 'SubscriptionId', ], 'metadataForms' => [ 'shape' => 'MetadataForms', ], ], ], 'UpdateSubscriptionRequestOutputSubscribedListingsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedListing', ], 'max' => 1, 'min' => 1, ], 'UpdateSubscriptionRequestOutputSubscribedPrincipalsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubscribedPrincipal', ], 'max' => 1, 'min' => 1, ], 'UpdateSubscriptionTargetInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'environmentIdentifier', 'identifier', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'environmentIdentifier' => [ 'shape' => 'EnvironmentId', 'location' => 'uri', 'locationName' => 'environmentIdentifier', ], 'identifier' => [ 'shape' => 'SubscriptionTargetId', 'location' => 'uri', 'locationName' => 'identifier', ], 'name' => [ 'shape' => 'SubscriptionTargetName', ], 'authorizedPrincipals' => [ 'shape' => 'AuthorizedPrincipalIdentifiers', ], 'applicableAssetTypes' => [ 'shape' => 'ApplicableAssetTypes', ], 'subscriptionTargetConfig' => [ 'shape' => 'SubscriptionTargetForms', ], 'manageAccessRole' => [ 'shape' => 'IamRoleArn', ], 'provider' => [ 'shape' => 'String', ], 'subscriptionGrantCreationMode' => [ 'shape' => 'SubscriptionGrantCreationMode', ], ], ], 'UpdateSubscriptionTargetOutput' => [ 'type' => 'structure', 'required' => [ 'id', 'authorizedPrincipals', 'domainId', 'projectId', 'environmentId', 'name', 'type', 'createdBy', 'createdAt', 'applicableAssetTypes', 'subscriptionTargetConfig', 'provider', ], 'members' => [ 'id' => [ 'shape' => 'SubscriptionTargetId', ], 'authorizedPrincipals' => [ 'shape' => 'AuthorizedPrincipalIdentifiers', ], 'domainId' => [ 'shape' => 'DomainId', ], 'projectId' => [ 'shape' => 'ProjectId', ], 'environmentId' => [ 'shape' => 'EnvironmentId', ], 'name' => [ 'shape' => 'SubscriptionTargetName', ], 'type' => [ 'shape' => 'String', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'updatedBy' => [ 'shape' => 'UpdatedBy', ], 'createdAt' => [ 'shape' => 'CreatedAt', ], 'updatedAt' => [ 'shape' => 'UpdatedAt', ], 'manageAccessRole' => [ 'shape' => 'IamRoleArn', ], 'applicableAssetTypes' => [ 'shape' => 'ApplicableAssetTypes', ], 'subscriptionTargetConfig' => [ 'shape' => 'SubscriptionTargetForms', ], 'provider' => [ 'shape' => 'String', ], 'subscriptionGrantCreationMode' => [ 'shape' => 'SubscriptionGrantCreationMode', ], ], ], 'UpdateUserProfileInput' => [ 'type' => 'structure', 'required' => [ 'domainIdentifier', 'userIdentifier', 'status', ], 'members' => [ 'domainIdentifier' => [ 'shape' => 'DomainId', 'location' => 'uri', 'locationName' => 'domainIdentifier', ], 'userIdentifier' => [ 'shape' => 'UserIdentifier', 'location' => 'uri', 'locationName' => 'userIdentifier', ], 'type' => [ 'shape' => 'UserProfileType', ], 'status' => [ 'shape' => 'UserProfileStatus', ], ], ], 'UpdateUserProfileOutput' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'UserProfileId', ], 'type' => [ 'shape' => 'UserProfileType', ], 'status' => [ 'shape' => 'UserProfileStatus', ], 'details' => [ 'shape' => 'UserProfileDetails', ], ], ], 'UpdatedAt' => [ 'type' => 'timestamp', ], 'UpdatedBy' => [ 'type' => 'string', ], 'UseAssetTypePolicyGrantDetail' => [ 'type' => 'structure', 'members' => [ 'domainUnitId' => [ 'shape' => 'DomainUnitId', ], ], ], 'UserAssignment' => [ 'type' => 'string', 'enum' => [ 'AUTOMATIC', 'MANUAL', ], ], 'UserDesignation' => [ 'type' => 'string', 'enum' => [ 'PROJECT_OWNER', 'PROJECT_CONTRIBUTOR', 'PROJECT_CATALOG_VIEWER', 'PROJECT_CATALOG_CONSUMER', 'PROJECT_CATALOG_STEWARD', ], ], 'UserDetails' => [ 'type' => 'structure', 'required' => [ 'userId', ], 'members' => [ 'userId' => [ 'shape' => 'String', ], ], ], 'UserIdentifier' => [ 'type' => 'string', 'pattern' => '.*(^([0-9a-f]{10}-|)[A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12}$|^[a-zA-Z_0-9+=,.@-]+$|^arn:aws:iam::\\d{12}:.+$).*', ], 'UserPolicyGrantPrincipal' => [ 'type' => 'structure', 'members' => [ 'userIdentifier' => [ 'shape' => 'UserIdentifier', ], 'allUsersGrantFilter' => [ 'shape' => 'AllUsersGrantFilter', ], ], 'union' => true, ], 'UserProfileDetails' => [ 'type' => 'structure', 'members' => [ 'iam' => [ 'shape' => 'IamUserProfileDetails', ], 'sso' => [ 'shape' => 'SsoUserProfileDetails', ], ], 'union' => true, ], 'UserProfileId' => [ 'type' => 'string', 'pattern' => '([0-9a-f]{10}-|)[A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12}', ], 'UserProfileName' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '[a-zA-Z_0-9+=,.@-]+', 'sensitive' => true, ], 'UserProfileStatus' => [ 'type' => 'string', 'enum' => [ 'ASSIGNED', 'NOT_ASSIGNED', 'ACTIVATED', 'DEACTIVATED', ], ], 'UserProfileSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'UserProfileSummary', ], ], 'UserProfileSummary' => [ 'type' => 'structure', 'members' => [ 'domainId' => [ 'shape' => 'DomainId', ], 'id' => [ 'shape' => 'UserProfileId', ], 'type' => [ 'shape' => 'UserProfileType', ], 'status' => [ 'shape' => 'UserProfileStatus', ], 'details' => [ 'shape' => 'UserProfileDetails', ], ], ], 'UserProfileType' => [ 'type' => 'string', 'enum' => [ 'IAM', 'SSO', ], ], 'UserSearchText' => [ 'type' => 'string', 'max' => 1024, 'min' => 0, 'sensitive' => true, ], 'UserSearchType' => [ 'type' => 'string', 'enum' => [ 'SSO_USER', 'DATAZONE_USER', 'DATAZONE_SSO_USER', 'DATAZONE_IAM_USER', ], ], 'UserType' => [ 'type' => 'string', 'enum' => [ 'IAM_USER', 'IAM_ROLE', 'SSO_USER', ], ], 'Username' => [ 'type' => 'string', 'max' => 64, 'min' => 0, ], 'UsernamePassword' => [ 'type' => 'structure', 'required' => [ 'password', 'username', ], 'members' => [ 'password' => [ 'shape' => 'Password', ], 'username' => [ 'shape' => 'Username', ], ], 'sensitive' => true, ], 'ValidationException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'WorkflowsMwaaPropertiesInput' => [ 'type' => 'structure', 'members' => [ 'mwaaEnvironmentName' => [ 'shape' => 'String', ], ], ], 'WorkflowsMwaaPropertiesOutput' => [ 'type' => 'structure', 'members' => [ 'mwaaEnvironmentName' => [ 'shape' => 'String', ], ], ], 'WorkflowsServerlessPropertiesInput' => [ 'type' => 'structure', 'members' => [], ], 'WorkflowsServerlessPropertiesOutput' => [ 'type' => 'structure', 'members' => [], ], ],];
