<?php

namespace App\Livewire\Settings;

use App\Models\Tax;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class TaxSettings extends Component
{

    use LivewireAlert;

    protected $listeners = ['refreshTaxes' => 'mount'];

    public $taxes;
    public $tax;
    public $showEditCurrencyModal = false;
    public $showAddCurrencyModal = false;
    public $confirmDeleteCurrencyModal = false;
    public $settings;
    public $taxMode = 'order';
    public $itemTaxInclusive = 0;
    public $includeChargesInTaxBase = true;
    public $activeTab = 'settings';
    public $assignAllTaxesToItems = false;

    public function mount()
    {
        $this->taxes = Tax::get();

        if ($this->settings) {
            $this->taxMode = $this->settings->tax_mode ?? 'order';
            $this->itemTaxInclusive = $this->settings->tax_inclusive ?? 0;
            $this->includeChargesInTaxBase = $this->settings->include_charges_in_tax_base ?? true;
        }
    }

    public function showAddCurrency()
    {
        $this->showAddCurrencyModal = true;
    }

    public function showEditCurrency($id)
    {
        $this->tax = Tax::findOrFail($id);
        $this->showEditCurrencyModal = true;
    }

    public function showDeleteCurrency($id)
    {
        $this->tax = Tax::findOrFail($id);
        $this->confirmDeleteCurrencyModal = true;
    }

    public function deleteCurrency($id)
    {
        Tax::destroy($id);
        $this->tax = null;

        $this->confirmDeleteCurrencyModal = false;

        $this->dispatch('refreshTaxes');

        $this->alert('success', __('messages.taxDeleted'), [
            'toast' => true,
            'position' => 'top-end',
            'showCancelButton' => false,
            'cancelButtonText' => __('app.close')
        ]);
    }

    #[On('hideEditCurrency')]
    public function hideEditCurrency()
    {
        $this->showEditCurrencyModal = false;
        $this->dispatch('refreshTaxes');
    }

    #[On('hideAddCurrency')]
    public function hideAddCurrency()
    {
        $this->showAddCurrencyModal = false;
        $this->dispatch('refreshTaxes');
    }

    public function saveTaxSettings()
    {
        if ($this->settings) {
            if ($this->taxMode !== 'item') {
                $this->assignAllTaxesToItems = false;
            }

            $this->settings->tax_mode = $this->taxMode;
            $this->settings->tax_inclusive = $this->itemTaxInclusive;
            $this->settings->include_charges_in_tax_base = $this->includeChargesInTaxBase;
            $this->settings->save();

            if ($this->taxMode === 'item' && $this->assignAllTaxesToItems) {
                $allTaxes = Tax::all();
                $items = \App\Models\MenuItem::doesntHave('taxes')->get();
                foreach ($items as $item) {
                    $item->taxes()->sync($allTaxes->pluck('id')->toArray());
                }
            }

            $this->alert('success', __('app.saved'), [
                'toast' => true,
                'position' => 'top-end',
                'showCancelButton' => false
            ]);
        }

        session()->forget('restaurant');
    }

    public function render()
    {
        return view('livewire.settings.tax-settings');
    }
}
